<?php
/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

if (!defined('_PS_MODULE_DIR_')) {
    exit;
}

use Nexi\NPG\Redirect\NPG;
use Nexi\XPay\Redirect\XPay;

class AdminNexiXPayController extends ModuleAdminController
{
    /**
     * Ajax call for Accounting from Back office
     */
    public function ajaxProcessAccounting()
    {
        $ret = null;

        if (\Validate::isString(\Tools::getValue('id_order')) && \Validate::isString(\Tools::getValue('amount'))) {
            if (\Tools::getValue('gateway') == PG_NPG) {
                $npg = new NPG($this->module);

                $ret = $npg->account(\Tools::getValue('id_order'), \Tools::getValue('amount'));
            } elseif (\Tools::getValue('gateway') == PG_XPAY) {
                $xpay = new XPay($this->module);

                $ret = $xpay->account(\Tools::getValue('id_order'), \Tools::getValue('amount'));
            }
        }

        echo json_encode($ret);
    }

    /**
     * Ajax call for Refunding from Back office
     */
    public function ajaxProcessRefunding()
    {
        $ret = null;

        if (\Validate::isString(\Tools::getValue('id_order')) && \Validate::isString(\Tools::getValue('amount'))) {

            

            if (\Tools::getValue('gateway') == PG_NPG) {
                $npg = new NPG($this->module);

                $ret = $npg->refund(\Tools::getValue('id_order'), \Tools::getValue('amount'));
            } elseif (\Tools::getValue('gateway') == PG_XPAY) {
                $xpay = new XPay($this->module);

                $ret = $xpay->refund(\Tools::getValue('id_order'), \Tools::getValue('amount'));
            }
        }

        echo json_encode($ret);
    }

    /**
     * Ajax call for upload Apple Pay certificates from Back office
     */
    public function ajaxProcessUploadingCertificates(): void
    {
        \Nexi\Utility\Logger::log("FILES: " . json_encode($$_FILES), 1);

        $file = $_FILES['file'];

        $json = [];

        if (empty($file['name']) || !is_uploaded_file($file['tmp_name']) || $file['error'] !== UPLOAD_ERR_OK) {
            $json['error'] = $this->module->l('Upload Error', 'nexixpay');
        }

        if (!$json) {
            $filename = basename(html_entity_decode($file['name'], ENT_QUOTES, 'UTF-8'));
            $filename = preg_replace('/[^a-zA-Z0-9_\.-]/', '_', $filename);

            if ((strlen($filename) < 3) || (strlen($filename) > 128)) {
                $json['error'] = $this->module->l('Upload Error', 'nexixpay');
            }

            $allowed = ['pem'];
            $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

            if (!in_array($extension, $allowed)) {
                $json['error'] = $this->module->l('Upload Error', 'nexixpay');
            }

            $safeName = filter_var($file['name'], FILTER_SANITIZE_STRING);
            $safeType = filter_var($file['type'], FILTER_SANITIZE_STRING);
            $safeSize = filter_var($file['size'], FILTER_VALIDATE_INT);

            \Nexi\Utility\Logger::log("Sanitized FILE: " . json_encode([
                'name' => $safeName,
                'type' => $safeType,
                'size' => $safeSize,
            ]), 1);
        }

        if (!$json) {
            $directory = _PS_MODULE_DIR_ . $this->module->name . "/upload";

            if (!is_dir($directory)) {
                mkdir($directory, 0777, true);
            }

            $destination = $directory . "/" . $filename;

            if (!move_uploaded_file($file['tmp_name'], $destination)) {
                $json['error'] = $this->module->l('Upload Error', 'nexixpay');
            } else {
                $json['filename'] = $filename;
                $json['success'] = $this->module->l('Upload succeeded', 'nexixpay');
            }
        }

        echo json_encode($json);
    }
}
