<?php
/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

use Nexi\Utility\Logger;
use \Nexi\Redirect\ApplePay\Payment as ApplePayPayment;

class NexiXPayApplePayModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();

        if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'getXPayApplePayConfiguration') {
            $this->getConfiguration();
        }
        if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'validateXPayApplePayMerchant') {
            $this->validateMerchant($_REQUEST['body']);
        }
        if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'getPlaceOrderDeferredObject') {
            $this->getPlaceOrderDeferredObject($_REQUEST['body']);
        }
    }

    private function getConfiguration()
    {
        $applePay = new ApplePayPayment($this->module);

        $configuration = $applePay->getApplePayConfiguration();

        exit(json_encode($configuration));
    }

    private function validateMerchant($request)
    {
        $applePay = new ApplePayPayment($this->module);

        exit($applePay->validateMerchant($request));
    }

    private function getPlaceOrderDeferredObject($request)
    {
        $applePay = new ApplePayPayment($this->module);

        $config = \Nexi\Redirect\Settings::getConfiguration();

        if ($config['gateway'] === 'xpay') {

            $res = $applePay->getPlaceOrderDeferredObjectXPay($request);

            if ($res['response']['esito'] === 'OK') {
                $url = $applePay->saveOrder();

                $applePay->savePaymentInfo($res);

            } else {
                Logger::log(__FUNCTION__ . ': KO - Request: ' . json_encode($res), 1);

                $url = [
                    'url' => $this->module->createModuleLink($this->module->name, 'cancellation'),
                ];
            }

            exit(json_encode($url));
        } elseif ($config['gateway'] === 'npg') {
            $res = $applePay->getPlaceOrderDeferredObjectNPG($request);

            if ($res['status_code'] === 200 && $res['response']['operation']['operationResult'] === 'EXECUTED' || $res['status_code'] === 201 && $res['response']['operation']['operationResult'] === 'EXECUTED') {

                $url = $applePay->saveOrder();

            } else {
                Logger::log(__FUNCTION__ . ': KO - Request: ' . json_encode($res), 1);

                $url = [
                    'url' => $this->module->createModuleLink($this->module->name, 'npg-cancel'),
                ];
            }

            exit(json_encode($url));
        }
    }
}
