<?php
/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

use \Nexi\Redirect\GooglePay\Payment as GooglePayPayment;

class NexiXPayGooglePayModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();

        if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'getXPayGooglePayConfiguration') {
            $this->getConfiguration();
        }
        if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'finalizeXPayGooglePayPayment') {
            $this->finalizeXPayGooglePayPayment($_REQUEST['body']);
        }
    }

    private function getConfiguration()
    {
        $googlePay = new GooglePayPayment($this->module);

        $configuration = $googlePay->getGooglePayConfiguration();

        exit(json_encode($configuration));
    }

    private function finalizeXPayGooglePayPayment($paymentData)
    {
        $googlePay = new GooglePayPayment($this->module);

        $config = \Nexi\Redirect\Settings::getConfiguration();

        if ($config['gateway'] === 'xpay') {
            exit(json_encode($googlePay->finalizePaymentXPay($paymentData)));
        } elseif ($config['gateway'] === 'npg') {
            exit(json_encode($googlePay->finalizePaymentNPG($paymentData)));
        }
    }
}
