<?php
/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

use Nexi\NPG\Redirect\API;
use Nexi\NPG\Redirect\NPG;
use Nexi\Utility\Logger;
use \Nexi\Redirect\GooglePay\Payment as GooglePayPayment;

class NexiXPayGooglePayManageSdkModuleFrontController extends \NexiXPayBaseModuleFrontController
{
    public function postProcess()
    {
        $nexixpay = new NexiXPay();
        $context = $nexixpay->getContext();

        $codTrans = Tools::getValue('codTrans');

        $api = new API();

        $googlePay = new GooglePayPayment($this->module);

        $data = $googlePay->getOrderIdsFromDB();

        $sessionId = $googlePay->getIframeSessionId($codTrans);

        $payload = [
            'sessionId' => $sessionId,
        ];

        $orderBuildState = $api->getBuildState($payload);

        if ($orderBuildState['state'] == 'REDIRECTED_TO_EXTERNAL_DOMAIN') {
            Tools::Redirect($orderBuildState['url']);
        } elseif ($orderBuildState['state'] == 'PAYMENT_COMPLETE') {
            if ($orderBuildState['operation']['operationResult'] === 'FAILED' || $orderBuildState['operation']['operationResult'] === 'CANCELED' || $orderBuildState['operation']['operationResult'] === 'DECLINED' || $orderBuildState['operation']['operationResult'] === 'THREEDS_FAILED') {
                Logger::log(__FUNCTION__ . ': KO - Request: ' . json_encode($orderBuildState['operation']), 1);

                Tools::Redirect($this->module->createModuleLink($this->module->name, 'npg-cancel'));
                exit();
            } else {
                $response = $googlePay->saveOrder($context, $data['importo'], $data['trans_id']);

                try {
                    $oI = new \OrderInfo();

                    if (\NexiXPay::isXPayBuild() && $oI->cartIdAndOrderIdExists(NPG::getCartId($orderBuildState['operation']['orderId']), $orderBuildState['operation']['orderId'])) {
                        $oI->updateExistingPaymentInfo(
                            NPG::getCartId($orderBuildState['operation']['orderId']),
                            $orderBuildState['operation']['orderId'],
                            null,
                            null,
                            $data['session_id']
                        );
                    } else {
                        $oI->saveInfo(
                            NPG::getCartId($orderBuildState['operation']['orderId']),
                            $orderBuildState['operation']['orderId'],
                            null,
                            null,
                            $data['session_id']
                        );
                    }
                } catch (\Exception $exc) {
                    Logger::logExceptionError($exc);

                    throw new \Exception($exc->getMessage());
                }

                Tools::Redirect($response['url']);
                exit();
            }
        }
    }
}
