<?php
/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

use \Nexi\Utility\Logger;
use \Nexi\Redirect\GooglePay\Payment as GooglePayPayment;
use Nexi\Utility\CurrencyHelper;

class NexiXPayGooglePayResponseModuleFrontController extends \NexiXPayBaseModuleFrontController
{
    public function postProcess()
    {
        $esito = Tools::getValue('esito');
        $xpayNonce = Tools::getValue('xpayNonce');

        $googlePay = new GooglePayPayment($this->module);

        $currencyHelper = new CurrencyHelper;

        if ($esito === 'OK') {
            $response = $googlePay->paga3ds($xpayNonce);

            if ($response['esito'] === 'OK') {

                $payInfo = $googlePay->getOrderIdsFromDB();

                $context = $googlePay->getThisContext();

                $amountToSave = $currencyHelper->fromMinUnitToAmountXPay($payInfo['importo'], $context->currency->iso_code);

                $googlePay->saveXPayPaymentInfo(
                    $context->cart,
                    $payInfo['trans_id'],
                    $response['esito'],
                    $amountToSave,
                    null,
                    null,
                    $response['brand'],
                    $response['data'] . ' ' . $response['ora'],
                    $response['nazione'],
                    $response['codiceAutorizzazione'],
                    null,
                    $context->customer->firstname,
                    $context->customer->lastname,
                    $context->customer->email
                );

                Logger::log("CALLING GOOGLE PAY RESPONSE URL", 1);

                $googlePay->googlePayResponseResult();

            } else {
                Logger::log(__FUNCTION__ . ': KO - Request: ' . json_encode($response), 2);
    
                $this->redirectToErrorPage($response['errore']['messaggio']);
            }
        } else {
            $message = Tools::getValue('messaggio');

            Logger::log(__FUNCTION__ . ': KO - Request: ' . $message, 2);

            $this->redirectToErrorPage($message['errore']['messaggio']);
        }
    }
}
