<?php
/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */

namespace Nexi\Redirect;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ApmInfo
{
    public function __construct(\NexiXPay $module)
    {
        $this->module = $module;
    }


    public function getApmMethodCodeByXPayApmName($apmName)
    {
        $apms = $this->getApms();

        foreach ($apms as $apmMethodCode => $apm) {
            if (strtolower(trim($apm['apm_name_xpay'])) == strtolower(trim($apmName))) {
                return $apmMethodCode;
            }
        }

        return null;
    }

    public function getApmMethodCodeByNpgApmName($apmName)
    {
        $apms = $this->getApms();

        foreach ($apms as $apmMethodCode => $apm) {
            if (strtolower(trim($apm['apm_name_npg'])) == strtolower(trim($apmName))) {
                return $apmMethodCode;
            }
        }

        return null;
    }

    public function getTitleByXPayApmName($apmName)
    {
        $apms = $this->getApms();

        foreach ($apms as $apm) {
            if (strtolower(trim($apm['apm_name_xpay'])) == strtolower(trim($apmName))) {
                return $apm['title'];
            }
        }

        return null;
    }

    public function getTitleByNpgApmName($apmName)
    {
        $apms = $this->getApms();

        foreach ($apms as $apm) {
            if (strtolower(trim($apm['apm_name_npg'])) == strtolower(trim($apmName))) {
                return $apm['title'];
            }
        }

        return null;
    }

    public function getApmMethodDescriptionByApmNameNPG($apmName)
    {
        $apms = $this->getApms();

        foreach ($apms as $apm) {
            if($apmName === 'SOFORT') {
                $apmName = 'KLARNA';
            }

            if (strtolower(trim($apm['apm_name_npg'])) == strtolower(trim($apmName))) {
                return $apm['description'];
            }
        }

        return null;
    }

    public function getApmMethodDescriptionByApmNameXPay($apmName)
    {
        $apms = $this->getApms();

        foreach ($apms as $apm) {
            if($apmName === 'SOFORT') {
                $apmName = 'KLARNA';
            }

            if (strtolower(trim($apm['apm_name_xpay'])) == strtolower(trim($apmName))) {
                return $apm['description'];
            }
        }

        return null;
    }

    private function getApms()
    {
        return [
            'alipay' => [
                'title' => 'Alipay',
                'apm_name_xpay' => 'alipay',
                'selected_card_xpay' => 'ALIPAY',
                'apm_name_npg' => 'alipay',
                'selected_card_npg' => 'ALIPAY',
                'description' => $this->module->l('Pay quickly and easily with your AliPay wallet', 'apminfo'),
            ],
            'amazonpay' => [
                'title' => 'Amazon Pay',
                'apm_name_xpay' => 'amazonpay',
                'selected_card_xpay' => 'AMAZONPAY',
                'apm_name_npg' => 'amazonpay',
                'selected_card_npg' => 'AMAZONPAY',
                'description' => $this->module->l('Pay easily with your Amazon account', 'apminfo'),
            ],
            'applepay' => [
                'title' => 'Apple Pay',
                'apm_name_xpay' => 'applepay',
                'selected_card_xpay' => 'APPLEPAY',
                'apm_name_npg' => 'applepay',
                'selected_card_npg' => 'APPLEPAY',
                'description' => $this->module->l('Easily pay with your Apple Pay wallet', 'apminfo'),
            ],
            'googlepay' => [
                'title' => 'Google Pay',
                'apm_name_xpay' => 'googlepay',
                'selected_card_xpay' => 'GOOGLEPAY',
                'apm_name_npg' => 'googlepay',
                'selected_card_npg' => 'GOOGLEPAY',
                'description' => $this->module->l('Easily pay with your Google Pay wallet', 'apminfo'),
            ],
            'klarna' => [
                'title' => 'Klarna',
                'apm_name_xpay' => 'sofort',
                'selected_card_xpay' => 'SOFORT',
                'apm_name_npg' => 'klarna',
                'selected_card_npg' => 'KLARNA',
                'description' => $this->module->l('Pay in 3 installments with Klarna interest-free', 'apminfo'),
            ],
            'klarnav2' => [
                'title' => 'Klarna',
                'apm_name_xpay' => 'klarna',
                'selected_card_xpay' => 'KLARNA',
                'apm_name_npg' => '',
                'selected_card_npg' => '',
                'description' => $this->module->l('Pay in 3 installments with Klarna interest-free', 'apminfo'),
            ],
            'paypal' => [
                'title' => 'PayPal',
                'apm_name_xpay' => 'paypal',
                'selected_card_xpay' => 'PAYPAL',
                'apm_name_npg' => 'paypal',
                'selected_card_npg' => 'PAYPAL',
                'description' => $this->module->l('Pay securely with your PayPal account', 'apminfo'),
            ],
            'paypal_bnpl' => [
                'title' => 'PayPal - Paga in 3 rate',
                'apm_name_xpay' => 'paypal_bnpl',
                'selected_card_xpay' => 'PAYPAL_BNPL',
                'apm_name_npg' => 'paypalpagain3',
                'selected_card_npg' => 'PAYPAL_BNPL',
                'description' => $this->module->l('Pay in 3 installments with your PayPal account', 'apminfo'),
            ],
            'wechatpay' => [
                'title' => 'WeChat Pay',
                'apm_name_xpay' => 'wechatpay',
                'selected_card_xpay' => 'WECHATPAY',
                'apm_name_npg' => 'wechatpay',
                'selected_card_npg' => 'WECHATPAY',
                'description' => $this->module->l('Pay quickly and easily with your WeChat Pay wallet', 'apminfo'),
            ],
            'giropay' => [
                'title' => 'Giropay',
                'apm_name_xpay' => 'giropay',
                'selected_card_xpay' => 'GIROPAY',
                'apm_name_npg' => 'giropay',
                'selected_card_npg' => 'GIROPAY',
                'description' => $this->module->l('Pay directly from your bank account with Giropay', 'apminfo'),
            ],
            'ideal' => [
                'title' => 'iDEAL',
                'apm_name_xpay' => 'ideal',
                'selected_card_xpay' => 'IDEAL',
                'apm_name_npg' => 'ideal',
                'selected_card_npg' => 'IDEAL',
                'description' => $this->module->l('Pay directly from your bank account with iDEAL', 'apminfo'),
            ],
            'bancontact' => [
                'title' => 'Bancontact',
                'apm_name_xpay' => 'bcmc',
                'selected_card_xpay' => 'BCMC',
                'apm_name_npg' => 'bancontact',
                'selected_card_npg' => 'BANCONTACT',
                'description' => $this->module->l('Pay easily with Bancontact', 'apminfo'),
            ],
            'eps' => [
                'title' => 'EPS',
                'apm_name_xpay' => 'eps',
                'selected_card_xpay' => 'EPS',
                'apm_name_npg' => 'eps',
                'selected_card_npg' => 'EPS',
                'description' => $this->module->l('Real time payment directly from your bank account with EPS', 'apminfo'),
            ],
            'przelewy24' => [
                'title' => 'Przelewy24',
                'apm_name_xpay' => 'p24',
                'selected_card_xpay' => 'P24',
                'apm_name_npg' => 'przelewy24',
                'selected_card_npg' => 'PRZELEWY24',
                'description' => $this->module->l('Secure payment directly from your bank account with Przelewy24', 'apminfo'),
            ],
            'mybank' => [
                'title' => 'MyBank',
                'apm_name_xpay' => 'sct',
                'selected_card_xpay' => 'SCT',
                'apm_name_npg' => 'mybank',
                'selected_card_npg' => 'MYBANK',
                'description' => $this->module->l('Pay securely by bank transfer with MyBank', 'apminfo'),
            ],
            'sct' => [
                'title' => 'MyBank',
                'apm_name_xpay' => 'sct',
                'selected_card_xpay' => 'SCT',
                'apm_name_npg' => '',
                'selected_card_npg' => '',
                'description ' => $this->module->l('Pay securely by bank transfer with MyBank', 'apminfo'),
            ],
            'bancomatpay' => [
                'title' => 'Bancomat Pay',
                'apm_name_xpay' => 'bancomatpay',
                'selected_card_xpay' => 'BANCOMATPAY',
                'apm_name_npg' => 'bancomatpay',
                'selected_card_npg' => 'BANCOMATPAY',
                'description' => $this->module->l('Pay via BANCOMAT Pay just by entering your phone number', 'apminfo'),
            ],
            'skrill' => [
                'title' => 'Skrill',
                'apm_name_xpay' => 'skrill',
                'selected_card_xpay' => 'SKRILL',
                'apm_name_npg' => 'skrill',
                'selected_card_npg' => 'SKRILL',
                'description' => $this->module->l('Pay quickly and easily with your Skrill wallet', 'apminfo'),
            ],
            'skrill1tap' => [
                'title' => 'Skrill 1tap',
                'apm_name_xpay' => 'skrillonetap',
                'selected_card_xpay' => 'SKRILLONETAP',
                'apm_name_npg' => 'skrill1tap',
                'selected_card_npg' => 'SKRILL1TAP',
                'description' => $this->module->l('Pay in one tap with your Skrill wallet', 'apminfo'),
            ],
            'paybybank' => [
                'title' => 'PayByBank',
                'apm_name_xpay' => 'paybybank',
                'selected_card_xpay' => 'PAYBYBANK',
                'apm_name_npg' => '',
                'selected_card_npg' => '',
                'description' => $this->module->l('Simply pay by bank transfer directly from your home banking with PayByBank', 'apminfo'),
            ],

            'pagoinconto' => [
                'title' => 'PagoInConto',
                'apm_name_xpay' => 'pagoinconto',
                'selected_card_xpay' => 'PAGOINCONTO',
                'apm_name_npg' => '',
                'selected_card_npg' => '',
                'description' => $this->module->l('Simply pay by bank transfer directly from your home banking with PagoInConto', 'apminfo'),
            ],
            'satispay' => [
                'title' => 'Satispay',
                'apm_name_xpay' => 'satispay',
                'selected_card_xpay' => 'SATISPAY',
                'apm_name_npg' => 'satispay',
                'selected_card_npg' => 'SATISPAY',
                'description' => $this->module->l('Pay easily with your Satispay account', 'apminfo'),
            ],
            'multibanco' => [
                'title' => 'Multibanco',
                'apm_name_xpay' => 'multibanco',
                'selected_card_xpay' => 'MULTIBANCO',
                'apm_name_npg' => 'multibanco',
                'selected_card_npg' => 'MULTIBANCO',
                'description' => $this->module->l('Secure payment directly from your home banking with Multibanco', 'apminfo'),
            ],
            'payu' => [
                'title' => 'PayU',
                'apm_name_xpay' => 'payu',
                'selected_card_xpay' => 'PAYU',
                'apm_name_npg' => 'payu',
                'selected_card_npg' => 'PAYU',
                'description' => $this->module->l('Secure payment directly from your bank account with PayU', 'apminfo'),
            ],
            'blik' => [
                'title' => 'Blik',
                'apm_name_xpay' => 'blik',
                'selected_card_xpay' => 'BLIK',
                'apm_name_npg' => 'blik',
                'selected_card_npg' => 'BLIK',
                'description' => $this->module->l('Secure payment directly from your home banking with Blik', 'apminfo'),
            ],
            'oney' => [
                'title' => 'Oney',
                'apm_name_xpay' => '',
                'selected_card_xpay' => '',
                'apm_name_npg' => 'oney',
                'selected_card_npg' => 'ONEY',
                'description' => $this->module->l('Pay in 3 or 4 installments by credit, debit or Postepay card with Oney', 'apminfo'),
            ],
            'poli' => [
                'title' => 'POLi',
                'apm_name_xpay' => 'poli',
                'selected_card_xpay' => 'POLI',
                'apm_name_npg' => '',
                'selected_card_npg' => '',
                'description' => $this->module->l('Pay easily with POLI', 'apminfo'),
            ],
            'fastcheckout' => [
                'title' => 'FastCheckout',
                'apm_name_xpay' => 'fastcheckout',
                'selected_card_xpay' => 'FASTCHECKOUT',
                'apm_name_npg' => '',
                'selected_card_npg' => '',
                'description' => $this->module->l('Pay quickly and easily with FastCheckout', 'apminfo'),
            ],
            'pagodil' => [
                'title' => 'PagoDil',
                'apm_name_xpay' => 'pagodil',
                'selected_card_xpay' => 'PAGODIL',
                'apm_name_npg' => 'pagodil',
                'selected_card_npg' => 'PAGODIL',
                'description' => $this->module->l('Buy now and pay a little by little with PagoDIL', 'apminfo'),
            ],
            'heylight' => [
                'title' => 'HeyLight',
                'apm_name_xpay' => 'pagolight',
                'selected_card_xpay' => 'PAGOLIGHT',
                'apm_name_npg' => 'heylight',
                'selected_card_npg' => 'HEYLIGHT',
                'description' => $this->module->l('Pay in installments with HeyLight', 'apminfo'),
            ],
            'iris' => [
                'title' => 'Iris',
                'apm_name_xpay' => '',
                'selected_card_xpay' => '',
                'apm_name_npg' => 'iris',
                'selected_card_npg' => 'IRIS',
                'description' => $this->module->l('Pay securely with Iris', 'apminfo'),
            ],
        ];
    }
}
