<?php

/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */

namespace Nexi\Redirect\ApplePay;

if (!defined('_PS_VERSION_')) {
    exit;
}

class Settings
{

    /**
     * @var \NexiXPay
     */
    private $module;

    public function __construct(\NexiXPay $module)
    {
        $this->module = $module;
    }

    /**
     * Main configuration form
     *
     * @return array
     */
    public function getForm($dati)
    {
        
        if (\Configuration::get('NEXIXPAY_ENABLED_GATEWAY') == 'xpay') {
            if (\Configuration::get('NEXIXPAY_TEST') == 1) {
                $description = '<b>' . $this->module->l('1. Register as an Apple Merchant', 'settings') . '</b><br/>' .
                    $this->module->l('Go to the','settings') . '<a href="https://developer.apple.com/account/resources/identifiers/list/merchant"> Apple Developer - Merchant IDs</a> ' . $this->module->l('website to register as a merchant for your Apple Developer account.', 'settings') . '<br/>' . $this->module->l('Note: If you do not have an Apple Developer account, you will be able to create one during this process.', 'settings') .
                    '<br/><b>' . $this->module->l('2. Generating certificates', 'settings') . '</b><br/>' . 
                    $this->module->l('After registration, generate the required certificates. These will need to be uploaded both to the plugin configuration and to the back office, as indicated in the following steps.', 'settings') . 
                    '<br/><b>' . $this->module->l('3. Enabling the payment method in the Nexi back office', 'settings') . '</b><br/>' .
                    $this->module->l('Access the test area at', 'settings') . '<a href="https://ecommerce.nexi.it/area-test"> https://ecommerce.nexi.it/area-test</a>' . $this->module->l(' and go to Simple Payment/OneClick → Back office access data → Alternative payments → Apple Pay, then in the Apple Pay S2S Management section upload one of the generated certificates.', 'settings') . 
                    '<br/><b>' . $this->module->l('4. Uploading certificates to the plugin', 'settings') . '</b><br/>' .
                    $this->module->l('Once Apple Pay is enabled on the terminal, upload the other certificates in the plugin configuration section, following the instructions in the official documentation:', 'settings') . '<a href="https://developer.apple.com/help/account/capabilities/configure-apple-pay"> https://developer.apple.com/help/account/capabilities/configure-apple-pay</a>' .
                    '<br/><b>' . $this->module->l('5. Retrieving parameters', 'settings') . '</b><br/>' .
                    $this->module->l('The Merchant ID and Merchant Name parameters are available in the merchant management section within your Apple Developer account.','settings') . 
                    '<br/><b>' . $this->module->l('6. Domain registration','settings') . '</b><br/>' .
                    $this->module->l('Finally, register your domain following the official Apple instructions: ', 'settings') . '<a href="https://developer.apple.com/help/account/capabilities/configure-apple-pay-on-the-web"> https://developer.apple.com/help/account/capabilities/configure-apple-pay-on-the-web</a>';
            } elseif (\Configuration::get('NEXIXPAY_TEST') == 0) {
                $description = '<b>' . $this->module->l('1. Register as an Apple Merchant', 'settings') . '</b><br/>' .
                    $this->module->l('Go to the','settings') . '<a href="https://developer.apple.com/account/resources/identifiers/list/merchant"> Apple Developer - Merchant IDs</a> ' . $this->module->l('website to register as a merchant for your Apple Developer account.', 'settings') . '<br/>' . $this->module->l('Note: If you do not have an Apple Developer account, you will be able to create one during this process.', 'settings') .
                    '<br/><b>' . $this->module->l('2. Generating certificates', 'settings') . '</b><br/>' . 
                    $this->module->l('After registration, generate the required certificates. These will need to be uploaded both to the plugin configuration and to the back office, as indicated in the following steps.', 'settings') . 
                    '<br/><b>' . $this->module->l('3. Enabling the payment method in the Nexi back office', 'settings') . '</b><br/>' .
                    $this->module->l('Log in to the portal', 'settings') . '<a href="https://business.nexi.it"> https://business.nexi.it</a>' . $this->module->l(' and go to XPay Back office → Alternative payments → Apple Pay, then in the Apple Pay S2S Management section upload one of the generated certificates.', 'settings') . 
                    '<br/><b>' . $this->module->l('4. Uploading certificates to the plugin', 'settings') . '</b><br/>' .
                    $this->module->l('Once Apple Pay is enabled on the terminal, upload the other certificates in the plugin configuration section, following the instructions in the official documentation:', 'settings') . '<a href="https://developer.apple.com/help/account/capabilities/configure-apple-pay"> https://developer.apple.com/help/account/capabilities/configure-apple-pay</a>' .
                    '<br/><b>' . $this->module->l('5. Retrieving parameters', 'settings') . '</b><br/>' .
                    $this->module->l('The Merchant ID and Merchant Name parameters are available in the merchant management section within your Apple Developer account.','settings') . 
                    '<br/><b>' . $this->module->l('6. Domain registration','settings') . '</b><br/>' .
                    $this->module->l('Finally, register your domain following the official Apple instructions: ', 'settings') . '<a href="https://developer.apple.com/help/account/capabilities/configure-apple-pay-on-the-web"> https://developer.apple.com/help/account/capabilities/configure-apple-pay-on-the-web</a>';

            }
        }

        $form = [
            'form' => [
                'legend' => [
                    'title' => $this->module->l('Settings Apple Pay', 'settings'),
                ],
                'description' => $description,
                'input' => [
                    [
                        'type' => 'switch',
                        'label' => $this->module->l('Enable Apple Pay button', 'settings'),
                        'name' => 'NEXIXPAY_ENABLE_APPLE_PAY_BUTTON',
                        'is_bool' => true,
                        'desc' => $this->module->l('Enable Apple Pay button on checkout.', 'settings'),
                        'values' => $this->getDefaultSwitchOptions(),
                    ],
                    [
                        'type' => 'file',
                        'label' => $this->module->l('Merchant identifier certificate', 'settings'),
                        'name' => 'NEXIXPAY_APPLE_PAY_MERCHANT_IDENTIFIER_CERTIFICATE',
                        'desc' => $this->module->l('Upload your merchant identifier certificate to enable Apple Pay.', 'settings') . '<div id="merchant-identifier-certificate-file-name" style="display:none;">' . \Configuration::get('NEXIXPAY_APPLE_PAY_MERCHANT_IDENTIFIER_CERTIFICATE') . '</div>',
                        'size' => 2048,
                        'class' => 'nexi-config-input',
                    ],
                    [
                        'type' => 'file',
                        'label' => $this->module->l('Merchant identifier certificate key', 'settings'),
                        'name' => 'NEXIXPAY_APPLE_PAY_MERCHANT_IDENTIFIER_CERTIFICATE_KEY',
                        'desc' => $this->module->l('Upload your merchant identifier certificate key to enable Apple Pay.', 'settings') . '<div id="merchant-identifier-certificate-key-file-name" style="display:none;">' . \Configuration::get('NEXIXPAY_APPLE_PAY_MERCHANT_IDENTIFIER_CERTIFICATE_KEY') . '</div>',
                        'size' => 2048,
                        'class' => 'nexi-config-input',
                    ],
                    [
                        'type' => 'file',
                        'label' => $this->module->l('CA root certificate', 'settings'),
                        'name' => 'NEXIXPAY_APPLE_PAY_MERCHANT_CA_ROOT_CERTIFICATE',
                        'desc' => $this->module->l('Upload your CA root certificate to enable Apple Pay.', 'settings') . '<div id="ca-root-certificate-file-name" style="display:none;">' . \Configuration::get('NEXIXPAY_APPLE_PAY_MERCHANT_CA_ROOT_CERTIFICATE') . '</div>',
                        'size' => 2048,
                        'class' => 'nexi-config-input',
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->module->l('Apple Merchant ID', 'settings'),
                        'name' => 'NEXIXPAY_APPLE_PAY_MERCHANT_ID',
                        'desc' => $this->module->l('The Apple merchant identifier given by Apple.', 'settings'),
                        'size' => 100,
                        'class' => 'nexi-config-input',
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->module->l('Merchant label', 'settings'),
                        'name' => 'NEXIXPAY_APPLE_PAY_MERCHANT_LABEL',
                        'desc' => $this->module->l('Enter your label to be displayed on the Apple interface.', 'settings'),
                        'size' => 100,
                        'class' => 'nexi-config-input',
                    ],
                    [
                        'type' => 'select',
                        'label' => $this->module->l('Button color', 'settings'),
                        'desc' => $this->module->l('Choose the color of the Apple Pay button.', 'settings'),
                        'name' => 'NEXIXPAY_APPLE_PAY_BUTTON_COLOR',
                        'options' => [
                            'query' => $this->getButtonColorOptions(),
                            'id' => 'key',
                            'name' => 'value',
                        ],
                        'class' => 'nexi-config-input',
                    ],
                    [
                        'type' => 'select',
                        'label' => $this->module->l('Button type', 'settings'),
                        'desc' => $this->module->l('Choose the type of the Apple Pay button.', 'settings'),
                        'name' => 'NEXIXPAY_APPLE_PAY_BUTTON_TYPE',
                        'options' => [
                            'query' => $this->getButtonTypeOptions(),
                            'id' => 'key',
                            'name' => 'value',
                        ],
                        'class' => 'nexi-config-input',
                    ],
                ],
                'submit' => [
                    'title' => $this->module->l('Save', 'settings'),
                    'class' => 'btn btn-default pull-right',
                ],
            ],
        ];

        return $form;
    }

    private function getDefaultSwitchOptions()
    {
        return [
            [
                'value' => 1,
                'label' => $this->module->l('YES', 'settings'),
            ],
            [
                'value' => 0,
                'label' => $this->module->l('NO', 'settings'),
            ],
        ];
    }

    private function getButtonColorOptions()
    {
        return [
            ['key' => 'black', 'value' => $this->module->l('Black', 'settings')],
            ['key' => 'white-outline', 'value' => $this->module->l('White with outline', 'settings')],
            ['key' => 'white', 'value' => $this->module->l('White', 'settings')],
        ];
    }

    private function getButtonTypeOptions()
    {
        return [
            ['key' => 'plain', 'value' => $this->module->l('Plain', 'settings')],
            ['key' => 'continue', 'value' => $this->module->l('Continue', 'settings')],
            ['key' => 'add-money', 'value' => $this->module->l('Add Money', 'settings')],
            ['key' => 'book', 'value' => $this->module->l('Book', 'settings')],
            ['key' => 'buy', 'value' => $this->module->l('Buy', 'settings')],
            ['key' => 'check-out', 'value' => $this->module->l('Check Out', 'settings')],
            ['key' => 'contribute', 'value' => $this->module->l('Contribute', 'settings')],
            ['key' => 'order', 'value' => $this->module->l('Order', 'settings')],
            ['key' => 'pay', 'value' => $this->module->l('Pay', 'settings')],
            ['key' => 'reload', 'value' => $this->module->l('Reload', 'settings')],
            ['key' => 'rent', 'value' => $this->module->l('Rent', 'settings')],
            ['key' => 'set-up', 'value' => $this->module->l('Set Up', 'settings')],
            ['key' => 'subscribe', 'value' => $this->module->l('Subscribe', 'settings')],
            ['key' => 'support', 'value' => $this->module->l('Support', 'settings')],
            ['key' => 'tip', 'value' => $this->module->l('Tip', 'settings')],
            ['key' => 'top-up', 'value' => $this->module->l('Top Up', 'settings')],
        ];
    }
}
