<?php
/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */

namespace Nexi\Redirect\GooglePay;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Nexi\XPay\Redirect\XPay;

class Configuration
{
    private $module;
    private $amount;
    private $cart;

    public function __construct($module)
    {
        $this->module = $module;
    }

    /**
     * googlepay saved configuration/settings
     *
     * @return array
     */
    public function getConfiguration()
    {
        $config = [];

        foreach (\NexiXPay::GOOGLEPAY_CONFIGURATION_FIELDS as $field) {
            $config[$field] = null;

            if ($field == 'NEXIXPAY_GOOGLE_PAY_LINK') {
                $config[$field] = 'https://pay.google.com/intl/it_it/about/';
            }
            if (\Configuration::get($field)) {
                $config[$field] = \Tools::getValue($field, \Configuration::get($field));
            }
        }

        return $config;
    }

    public function isGooglePayAvailable()
    {
        if (\NexiXPay::checkNexiConfigForGooglePay()) {
            $googlePayConfiguration = $this->getConfiguration();

            if ($googlePayConfiguration['NEXIXPAY_ENABLE_GOOGLE_PAY_BUTTON'] == '1') {
                return true;
            }
        }

        return false;
    }

    public function setCart($cart)
    {
        $this->cart = $cart;
    }

    public function setAmount($amount)
    {
        $this->amount = $amount;
    }
}
