<?php

/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */

namespace Nexi\Redirect\GooglePay;

if (!defined('_PS_VERSION_')) {
    exit;
}

class Settings
{

    /**
     * @var \NexiXPay
     */
    private $module;

    public function __construct(\NexiXPay $module)
    {
        $this->module = $module;
    }

    /**
     * Main configuration form
     *
     * @return array
     */
    public function getForm($dati)
    {
        if (\Configuration::get('NEXIXPAY_ENABLED_GATEWAY') == 'xpay') {
            if (\Configuration::get('NEXIXPAY_TEST') == 1) {
                 $description = '<b>1. </b>' . $this->module->l('Enable APM: Verify that the alternative payment method (APM) is enabled on the terminal by accessing','settings') . '<a href="https://ecommerce.nexi.it/area-test"> https://ecommerce.nexi.it/area-test </a>' . $this->module->l('→ Simple/OneClick Payment → Back office access data → Alternative payments → Google Pay.', 'settings') . 
                    '<br/><b>2. </b>' . $this->module->l('Retrieve merchant data: For the test environment, dummy data can be used to populate the Google Merchant Name (e.g. Test Merchant) and Google Merchant ID (e.g. 1234567890123456) parameters.', 'settings') . 
                    '<br/><b>3. </b>' . $this->module->l('Set up your Gateway Merchant ID: Your Google Gateway Merchant ID is the numeric part of your alias.', 'settings');
            } elseif (\Configuration::get('NEXIXPAY_TEST') == 0) {
                $description = '<b>1. </b>' . $this->module->l('Enable APM: Verify that the alternative payment method (APM) is enabled on the terminal by accessing the portal','settings') . '<a href="https://business.nexi.it"> https://business.nexi.it </a>' . $this->module->l('in the XPay Back office → Alternative Payments → Google Pay section.', 'settings') . 
                    '<br/><b>2. </b>' . $this->module->l('Register your domain: Go to the Google Pay Business Console','settings') . ' (<a href="https://pay.google.com/business/console/home">https://pay.google.com/business/console/home</a>) ' . $this->module->l('and register your domain (Google Pay API → Integrate with your website). Google must approve it before you can proceed.', 'settings') . '<br/>' . $this->module->l('Note: If you do not have a Google Merchant account, you can create one during the process.', 'settings') .
                    '<br/><b>3. </b>' . $this->module->l('Retrieve merchant data: Once the domain is approved, retrieve the following data from the Google Pay console:', 'settings') . '<br/>- ' . $this->module->l('Google Merchant Name', 'settings') . '<br/>- ' . $this->module->l('Google Merchant ID.', 'settings') .
                    '<br/><b>4. </b>' . $this->module->l('Set up your Gateway Merchant ID: Your Google Gateway Merchant ID is the numeric part of your alias.', 'settings');
            }
        } elseif (\Configuration::get('NEXIXPAY_ENABLED_GATEWAY') == 'npg') {
            if (\Configuration::get('NEXIXPAY_TEST') == 1) {
                $description = '<b>1. </b>' . $this->module->l('Enable APM: the payment method is already enabled on public test terminals','settings') . ' (<a href="https://developer.nexi.it/it/area-test/api-key">https://developer.nexi.it/it/area-test/api-key</a>) ' . 
                    '<br/><b>2. </b>' . $this->module->l('Register your domain: Go to the Google Pay Business Console','settings') . ' (<a href="https://pay.google.com/business/console/home">https://pay.google.com/business/console/home</a>) ' . $this->module->l('and register your domain (Google Pay API → Integrate with your website). Google must approve it before you can proceed.', 'settings') . '<br/>' . $this->module->l('Note: If you do not have a Google Merchant account, you can create one during the process.', 'settings') .
                    '<br/><b>3. </b>' . $this->module->l('Retrieve merchant data: Once the domain is approved, retrieve the following data from the Google Pay console:', 'settings') . '<br/>- ' . $this->module->l('Google Merchant Name', 'settings') . '<br/>- ' . $this->module->l('Google Merchant ID.', 'settings') .
                    '<br/><b>4. </b>' . $this->module->l('Set the Gateway Merchant ID: Set this parameter to a randomly generated UUID v4 string.', 'settings');
            } elseif (\Configuration::get('NEXIXPAY_TEST') == 0) {
                $description = '<b>1. </b>' . $this->module->l('Enable APM: Verify that the alternative payment method (APM) is enabled on the terminal by accessing the portal','settings') . '<a href="https://business.nexi.it/"> https://business.nexi.it/ </a> '  . $this->module->l('→ Services → Ecommerce solutions → XPay Web - Login → Configurations → Alternative payments → Google Pay.', 'settings') . 
                    '<br/><b>2. </b>' . $this->module->l('Register your domain: Go to the Google Pay Business Console','settings') . ' (<a href="https://pay.google.com/business/console/home">https://pay.google.com/business/console/home</a>) ' . $this->module->l('and register your domain (Google Pay API → Integrate with your website). Google must approve it before you can proceed.', 'settings') . '<br/>' . $this->module->l('Note: If you do not have a Google Merchant account, you can create one during the process.', 'settings') .
                    '<br/><b>3. </b>' . $this->module->l('Retrieve merchant data: Once the domain is approved, retrieve the following data from the Google Pay console:', 'settings') . '<br/>- ' . $this->module->l('Google Merchant Name', 'settings') . '<br/>- ' . $this->module->l('Google Merchant ID.', 'settings') .
                    '<br/><b>4. </b>' . $this->module->l('Set the Gateway Merchant ID: Set this parameter to a randomly generated UUID v4 string.', 'settings');
            }
        }

        $form = [
            'form' => [
                'legend' => [
                    'title' => $this->module->l('Settings GooglePay', 'settings'),
                ],
                'description' => $description,
                'input' => [
                    [
                        'type' => 'switch',
                        'label' => $this->module->l('Enable Google Pay button', 'settings'),
                        'name' => 'NEXIXPAY_ENABLE_GOOGLE_PAY_BUTTON',
                        'is_bool' => true,
                        'desc' => $this->module->l('Enable Google Pay button on checkout.', 'settings'),
                        'values' => $this->getDefaultSwitchOptions(),
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->module->l('Merchant Name', 'settings'),
                        'name' => 'NEXIXPAY_GOOGLE_PAY_MERCHANT_NAME',
                        'desc' => $this->module->l('Enter your store name to be displayed on the Google interface.', 'settings'),
                        'size' => 100,
                        'class' => 'nexi-config-input',
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->module->l('Google Merchant ID', 'settings'),
                        'name' => 'NEXIXPAY_GOOGLE_PAY_MERCHANT_ID',
                        'desc' => $this->module->l('A Google merchant identifier issued after registration with the Google Pay and Wallet Console.', 'settings'),
                        'size' => 100,
                        'class' => 'nexi-config-input',
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->module->l('Gateway Merchant ID', 'settings'),
                        'name' => 'NEXIXPAY_GOOGLE_PAY_GATEWAY_MERCHANT_ID',
                        'desc' => $this->module->l('Nexi identification number that can be found in Easy Portal and is displayed at the top of the page.', 'settings'),
                        'size' => 100,
                        'class' => 'nexi-config-input',
                    ],
                    [
                        'type' => 'select',
                        'label' => $this->module->l('Button color', 'settings'),
                        'desc' => $this->module->l('Choose the color of the Google Pay button.', 'settings'),
                        'name' => 'NEXIXPAY_GOOGLE_PAY_BUTTON_COLOR',
                        'options' => [
                            'query' => $this->getButtonColorOptions(),
                            'id' => 'key',
                            'name' => 'value',
                        ],
                        'class' => 'nexi-config-input',
                    ],
                    [
                        'type' => 'select',
                        'label' => $this->module->l('Button type', 'settings'),
                        'desc' => $this->module->l('Choose the type of the Google Pay button.', 'settings'),
                        'name' => 'NEXIXPAY_GOOGLE_PAY_BUTTON_TYPE',
                        'options' => [
                            'query' => $this->getButtonTypeOptions(),
                            'id' => 'key',
                            'name' => 'value',
                        ],
                        'class' => 'nexi-config-input',
                    ],
                ],
                'submit' => [
                    'title' => $this->module->l('Save', 'settings'),
                    'class' => 'btn btn-default pull-right',
                ],
            ],
        ];

        return $form;
    }

    private function getDefaultSwitchOptions()
    {
        return [
            [
                'value' => 1,
                'label' => $this->module->l('YES', 'settings'),
            ],
            [
                'value' => 0,
                'label' => $this->module->l('NO', 'settings'),
            ],
        ];
    }

    private function getButtonColorOptions()
    {
        return [
            ['key' => 'default', 'value' => $this->module->l('Default', 'settings')],
            ['key' => 'black', 'value' => $this->module->l('Black', 'settings')],
            ['key' => 'white', 'value' => $this->module->l('White', 'settings')],
        ];
    }

    private function getButtonTypeOptions()
    {
        return [
            ['key' => 'buy', 'value' => $this->module->l('Buy', 'settings')],
            ['key' => 'book', 'value' => $this->module->l('Book', 'settings')],
            ['key' => 'checkout', 'value' => $this->module->l('Checkout', 'settings')],
            ['key' => 'donate', 'value' => $this->module->l('Donate', 'settings')],
            ['key' => 'order', 'value' => $this->module->l('Order', 'settings')],
            ['key' => 'pay', 'value' => $this->module->l('Pay', 'settings')],
            ['key' => 'plain', 'value' => $this->module->l('Plain', 'settings')],
            ['key' => 'subscribe', 'value' => $this->module->l('Subscribe', 'settings')],
        ];
    }
}
