<?php

/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

// No namespace for compatibility with ps 1.6 object model
class NpgLock extends \ObjectModel
{

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = [
        'table' => 'npg_lock',
        'primary' => 'npg_order_id',
        'fields' => [
            'npg_order_id' => ['type' => self::TYPE_STRING, 'required' => true],
            'created_at' => ['type' => self::TYPE_DATE],
        ],
    ];
    public $npg_order_id;
    public $created_at;

    /**
     * 
     * @param string $npgOrderId
     * @return bool
     */
    public function tryToTakeLock($npgOrderId)
    {
        $i = 0;

        do {
            if ($this->takeLock($npgOrderId)) {
                return true;
            }

            sleep(1);

            $i++;
        } while ($i < 30);

        return false;
    }

    /**
     * 
     * @param string $npgOrderId
     */
    public function releaseLock($npgOrderId)
    {
        Db::getInstance()->delete('npg_lock', 'npg_order_id = "' . pSQL($npgOrderId) . '" ');
    }

    /**
     * 
     * @param string $npgOrderId
     */
    private function takeLock($npgOrderId)
    {
        try {
            return Db::getInstance()->insert('npg_lock', array('npg_order_id' => $npgOrderId));
        } catch (\Exception $ex) {
            return false;
        }
    }

}
