<?php
/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

$sql = [];

$sql[] = '  CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . "xpay_payments_info` (
                `codTrans` char(64) NOT NULL,
                `idCart` INT(11) NOT NULL,
                `amount` decimal(10,2) DEFAULT NULL,
                `currency` varchar(8) DEFAULT NULL,
                `brand` varchar(128) DEFAULT NULL,
                `result` varchar(8) DEFAULT NULL,
                `date` datetime DEFAULT NULL,
                `autCode` varchar(8) DEFAULT NULL,
                `pan` varchar(16) DEFAULT NULL,
                `exp` varchar(8) DEFAULT NULL,
                `nationality` varchar(8) DEFAULT NULL,
                `firstName` varchar(256) DEFAULT NULL,
                `lastName` varchar(256) DEFAULT NULL,
                `mail` varchar(256) DEFAULT NULL,
                `message` varchar(256) DEFAULT NULL,
                `contractNumber` VARCHAR(128) DEFAULT NULL,
                `moduleVariant` ENUM('redirect','build','build-old') NULL,
                PRIMARY KEY (`codTrans`)
            ) ENGINE=" . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;';

$sql[] = ' ALTER TABLE `' . _DB_PREFIX_ . 'xpay_payments_info` ADD INDEX(`idCart`); ';

$sql[] = ' CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'xpay_contracts` (
                    `id_contract` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
                    `id_customer` INT(10) UNSIGNED NOT NULL,
                    `num_contract` VARCHAR(30) NOT NULL,
                    `brand` VARCHAR(16) NOT NULL,
                    `pan` VARCHAR(16) NOT NULL,
                    `expiry_month` INT(10) UNSIGNED NOT NULL,
                    `expiry_year` INT(10) UNSIGNED NOT NULL
                ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;';

$sql[] = '  CREATE TABLE IF NOT EXISTS ' . _DB_PREFIX_ . 'npg_payments (
                id INT(11) NOT NULL AUTO_INCREMENT,
                id_cart INT(10) NOT NULL,
                order_id VARCHAR(27) NOT NULL,
                security_token VARCHAR(64) NOT NULL,
                session_id VARCHAR(64) NULL DEFAULT NULL,
                p_started BOOLEAN NOT NULL DEFAULT FALSE,
                order_created BOOLEAN NOT NULL DEFAULT FALSE,
                created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
                token VARCHAR(255) NULL DEFAULT NULL,
                lock_validate BOOLEAN NOT NULL DEFAULT FALSE,
                PRIMARY KEY (`id`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;';

$sql[] = '  CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'npg_contracts` (
                id INT(11) NOT NULL AUTO_INCREMENT,
                id_customer INT(10) UNSIGNED NOT NULL,
                num_contract VARCHAR(255) NOT NULL,
                brand VARCHAR(16) NOT NULL,
                pan VARCHAR(16) NOT NULL,
                expiry_month INT(10) UNSIGNED NOT NULL,
                expiry_year INT(10) UNSIGNED NOT NULL,
                PRIMARY KEY (`id`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;';

$sql[] = '  CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'npg_lock` (
                npg_order_id VARCHAR(20) NOT NULL,
                created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`npg_order_id`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;';

$sql[] = ' CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'nexi_cards` (
                card_code VARCHAR(10) NOT NULL,
                card_name VARCHAR(20) NOT NULL,
                order_value INT(2) NOT NULL,
                created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`card_code`) 
            );';
$sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'Mastercard', 'MC', 1
            );";
$sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'Visa', 'VISA', 2
            );";
$sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'Amex', 'AMEX', 3
            );";
$sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'JCB', 'JCB', 4
            );";
$sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'UPI', 'UPI', 5
            );";
$sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'MAESTRO', 'Maestro', 6
            );";

$sql[] = ' CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'nexi_googlepay` (
                cart_id VARCHAR(10) NOT NULL,
                trans_id VARCHAR(20) NOT NULL,
                html VARCHAR(1024) DEFAULT NULL,
                session_id VARCHAR(128) DEFAULT NULL,
                importo VARCHAR (50) DEFAULT NULL,
                created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`trans_id`) 
            );';

foreach ($sql as $query) {
    if (Db::getInstance()->execute($query) === false) {
        return false;
    }
}
