<?php

/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_8_0_0($module)
{
    if ($module->name == 'nexixpay') {
        $sql = [];

        $sql[] = ' CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'nexi_cards` (
                card_code VARCHAR(10) NOT NULL,
                card_name VARCHAR(20) NOT NULL,
                order_value INT(2) NOT NULL,
                created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`card_code`) 
            );';
        $sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'Mastercard', 'MC', 1
            );";
        $sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'Visa', 'VISA', 2
            );";
        $sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'Amex', 'AMEX', 3
            );";
        $sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'JCB', 'JCB', 4
            );";
        $sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'UPI', 'UPI', 5
            );";
        $sql[] = " REPLACE INTO `" . _DB_PREFIX_ . "nexi_cards` (card_name, card_code, order_value) VALUES (
                'MAESTRO', 'Maestro', 6
            );";

        $sql[] = ' CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'nexi_googlepay` (
                cart_id VARCHAR(10) NOT NULL,
                trans_id VARCHAR(20) NOT NULL,
                html VARCHAR(1024) DEFAULT NULL,
                session_id VARCHAR(128) DEFAULT NULL,
                importo VARCHAR (50) DEFAULT NULL,
                created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`trans_id`) 
            );';

        foreach ($sql as $query) {
            if (Db::getInstance()->execute($query) == false) {
                return false;
            }
        }

        return true;
    }

    return false;
}
