/**
 * Copyright (c) 2020 Nexi Payments S.p.A.
 *
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 *
 * @category    Payment Module
 *
 * @version     8.0.0
 */

var request = [];

function getXPayConfigurationApplePay() {
  getXPayApplePayConfiguration().then(function (configuration) {
    request = {
      countryCode: configuration.transactionInfo.countryCode,
      currencyCode: configuration.transactionInfo.currencyCode,
      supportedNetworks: configuration.cards,
      merchantCapabilities: ["supports3DS"],
      total: {
        label: configuration.config.NEXIXPAY_APPLE_PAY_MERCHANT_LABEL,
        amount: configuration.transactionInfo.totalPrice,
      },
    };
  });
}

function showXPayApplePayButton() {
  HTMLCollection.prototype[Symbol.iterator] = Array.prototype[Symbol.iterator];
  const buttons = document.getElementsByClassName("apple-pay-button-div");
  for (let button of buttons) {
    button.className += " visible";
  }
}

function onXPayApplePayButtonClicked() {
  var session = new ApplePaySession(14, request);
  session.onvalidatemerchant = function (event) {
    const request = {
      validationUrl: event.validationURL,
    };
    jQuery.ajax({
      type: "POST",
      data: {
        action: "validateXPayApplePayMerchant",
        body: JSON.stringify(request),
      },
      url: $("#nexi_applepay_url").val(),
      success: function (merchantSession) {
        session.completeMerchantValidation(JSON.parse(merchantSession));
      },
      error: function (xhr, ajaxOptions, thrownError) {
        console.error(
          thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText
        );
      },
    });
  };

  session.onpaymentauthorized = function (event) {
    self.applepayToken = JSON.stringify(event.payment);
    jQuery.ajax({
      type: "POST",
      data: {
        action: "getPlaceOrderDeferredObject",
        body: JSON.stringify(event.payment),
      },
      url: $("#nexi_applepay_url").val(),
      success: function (response) {
        session.completePayment({ status: 0 });
        responseObject = JSON.parse(response);
        window.location.href = responseObject.url;
      },
      error: function (xhr, ajaxOptions, thrownError) {
        session.completePayment({ status: 1 });
        console.error(
          thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText
        );
      },
    });
  };
  session.begin();
}

function getXPayApplePayConfiguration() {
  return new Promise(function (resolve, reject) {
    jQuery.ajax({
      type: "GET",
      data: {
        action: "getXPayApplePayConfiguration",
      },
      url: $("#nexi_applepay_url").val(),
      success: function (response) {
        resolve(JSON.parse(response, true));
      },
      error: function (xhr, ajaxOptions, thrownError) {
        console.error(
          thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText
        );
      },
    });
  });
}
