/*
 * Copyright (c) 2021 Nexi Payments S.p.A.
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2021 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 * @category    Payment Module
 * @version     8.0.0
 */

var buttonFlag = 0;

$(document).ready(function () {
  $("#payment-confirmation").after(
    '<div id="apple-pay-button-container"><apple-pay-button style="padding-top:10px" onclick="onXPayApplePayButtonClicked()" buttonstyle={$buttonColor} type={$buttonType} locale={$lang}></apple-pay-button></div>'
  );


  CheckApplePay();
});

$(document).ready(function () {
  $("#payment-confirmation").after(
    '<div id="google-pay-button-container" style="height:2px;"></div>'
  );
  $("#google-pay-button-container").after(
    $("#apple-pay-button-container").after(
      '<div id="google-pay-loader" style="visibility:hidden;"> <img src="' +
        $("#nexi_googlepay_loader_url").val() +
        '" style="width:250px; height:auto;"/> </div>'
    )
  );
});

$("#apple-pay-button-container").hide();

var showGooglePayButton = function () {
  if (window.onXPayGooglePayLoaded === undefined) {
    setTimeout(showGooglePayButton, 200);
  } else {
    window.onXPayGooglePayLoaded();
  }
};
showGooglePayButton();

$("#google-pay-button-container").hide();

$(document).ready(function () {
  const SELECTED_TOKEN_NEW = "NEW";

  getInstallmentsLabel();

  if (!window.ApplePaySession && $('*[data-module-name="APPLEPAY"]').length) {
    $('*[data-module-name="APPLEPAY"]')[0].parentNode.parentNode.remove();
  }

  $(document).on("change", "#pagodil-installments-number", function () {
    $("#installments").val($(this).val());

    window.localStorage.setItem(
      "lastSelectedInstallments",
      parseInt($(this).val())
    );

    getInstallmentsLabel();
  });

  function getInstallmentsAmount() {
    var total = $("#totalAmount").val();
    var total_recurrences = $("#installments").val();

    return (total / total_recurrences).toFixed(2);
  }

  function getInstallmentsLabel() {
    var installmentLabel = $("#installmentLabel").val();
    var total_recurrences = $("#installments").val();

    if ($("#installmentLabel").val() && $("#installments").val()) {
      $("#installment-text").text(
        pagodilSprintf(
          installmentLabel,
          total_recurrences,
          getInstallmentsAmount()
        )
      );
    }
  }

  function pagodilSprintf(str, ...argv) {
    if (argv.length) {
      return pagodilSprintf(str.replace("$", argv.shift()), ...argv);
    } else {
      return str;
    }
  }

  $('#nexi-payment-form input[name="selected_token"]').on(
    "change",
    function () {
      if ($(this).val() == SELECTED_TOKEN_NEW) {
        $("#save-token-checkbox").show();
        $('#save-token-checkbox input[name="save_token"]').attr(
          "disabled",
          false
        );
      } else {
        $("#save-token-checkbox").hide();
        $('#save-token-checkbox input[name="save_token"]').attr(
          "disabled",
          true
        );
      }
    }
  );
});

function CheckApplePay() {
  if (!window.ApplePaySession) {
    $('*[data-module-name="APPLEPAY"]')[0].parentNode.parentNode.remove();
  }
}

const moduleToAvailabilityKey = {
  GOOGLEPAY: "googlePay",
  APPLEPAY: "applePay",
};

function getSelectedModuleName() {
  const selectedInput = document.querySelector(
    'input[name="payment-option"]:checked'
  );
  if (!selectedInput) return null;
  return selectedInput.dataset.moduleName?.trim().toUpperCase() || null;
}

function updateOrderButtonVisibility() {
  const orderButton = document.querySelector('button[type="submit"]');
  if (!orderButton) return;

  const selectedModule = getSelectedModuleName();
  const availabilityKey = moduleToAvailabilityKey[selectedModule];

  if (
    selectedModule &&
    availabilityKey &&
    window.paymentMethodsAvailability &&
    window.paymentMethodsAvailability[availabilityKey] === true
  ) {
    $("#payment-confirmation").hide();

    if (selectedModule === "APPLEPAY") {
      $("#google-pay-button-container").hide();

      if (
        $('input[id="conditions_to_approve[terms-and-conditions]"]').is(
          ":checked"
        )
      ) {
        $("#apple-pay-button-container").show();
      } else {
        $("#apple-pay-button-container").hide();
      }
    } else if (selectedModule === "GOOGLEPAY") {
      $("#apple-pay-button-container").hide();

      if (
        $('input[id="conditions_to_approve[terms-and-conditions]"]').is(
          ":checked"
        )
      ) {
        $("#google-pay-button-container").show();
      } else {
        $("#google-pay-button-container").hide();
      }
    }
  } else {
    $("#apple-pay-button-container").hide();
    $("#google-pay-button-container").hide();

    $("#payment-confirmation").show();
  }
}

$(document).on(
  "change",
  'input[id="conditions_to_approve[terms-and-conditions]"]',
  updateOrderButtonVisibility
);

document.addEventListener("change", function (e) {
  if (e.target && e.target.name === "payment-option") {
    updateOrderButtonVisibility();
  }
});

document.addEventListener("DOMContentLoaded", updateOrderButtonVisibility);

const observer = new MutationObserver(updateOrderButtonVisibility);

observer.observe(document.body, { childList: true, subtree: true });
