/*
 * Copyright (c) 2020 Nexi Payments S.p.A.
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 * @category    Payment Module
 * @version     8.0.0
 */

jQuery(function ($) {
  var readyForPayment = false;
  var fields = [];
  var controllerUrl = null;
  var loaded = 0;
  var buildSdk = null;

  $(document).ready(function () {
    checkAndloadBuild();
  });

  var isNpgBuildSelected = function () {
    return (
      $('input[name="payment-option"]:checked').data("module-name") ==
      "npgbuild"
    );
  };

  var checkAndloadBuild = function () {
    if (isNpgBuildSelected() && loaded === 0) {
      buildFields();
      loaded = 1;
    }
  };

  var showLoading = function () {
    $(".loader-container").removeClass("nexi-hide");
  };

  var hideLoading = function () {
    $(".loader-container").addClass("nexi-hide");
  };

  $("form.npg-build-payment-form").on("submit", function (event) {
    event.preventDefault();
    getBuildSdk().confirmData();
  });

  function getBuildSdk() {
    if (!(buildSdk instanceof Build)) {
      buildSdk = new Build({
        onBuildSuccess: function (evtData) {
          if (evtData.event === "BUILD_SUCCESS") {
            document.getElementById(evtData.id).classList.remove("with-errors");
          }
        },
        onBuildError: function (evtData) {
          if (evtData.event === "BUILD_ERROR") {
            document.getElementById(evtData.id).classList.add("with-errors");
          }
        },
        onConfirmError: function (evtData) {
          if ("validationStatus" in evtData) {
            evtData.validationStatus.forEach(function (item) {
              if (document.getElementById(item.id)) {
                if (item.valid) {
                  document
                    .getElementById(item.id)
                    .classList.remove("with-errors");
                } else {
                  document.getElementById(item.id).classList.add("with-errors");
                }
              }
            });
          }
        },
        onBuildFlowStateChange: function (evtData, state) {
          if (evtData.event === "BUILD_FLOW_STATE_CHANGE") {
            if (state == "READY_FOR_PAYMENT" || state == "PAYMENT_COMPLETE") {
              setTimeout(function () {
                window.location.href = controllerUrl;
              }, 1000);
            }
          }
        },
        cssLink:
          prestashop.urls.base_url + "modules/nexixpay/views/css/npg_build.css",
      });
    }
    return buildSdk;
  }

  function loadBuildSdk(sdkLink, onBuildSdkLoad) {
    if (window.Build === undefined) {
      const imported = document.createElement("script");

      imported.onload = onBuildSdkLoad;
      imported.src = sdkLink;
      imported.type = "text/javascript";

      document.head.appendChild(imported);
    } else {
      onBuildSdkLoad();
    }
  }

  function buildFields() {
    readyForPayment = false;
    showLoading();

    cleanErrorMsg();
    cleanBuildFields();

    jQuery.ajax({
      type: "POST",
      data: {
        action: "npgBuildFields",
      },
      url: $("#nexi_ajax_url").val(),
      beforeSend: function () {
        showLoading();
      },
      success: function (response) {
        hideLoading();

        var json = JSON.parse(response);

        controllerUrl = json.controllerUrl;

        if (json.error_msg) {
          $(".npg-build-error-msg-container").text(`<p>${json.error_msg}</p>`);
        } else {
          $("#npg-orderId").val(json.orderId);

          loadBuildSdk(json.sdkLink, function () {
            getBuildSdk();

            var fields = json.fields;

            for (var i = 0; i < fields.length; i++) {
              var iframe = document.createElement("iframe");

              iframe.src = fields[i].src;
              iframe.className = "iframe_input";

              var containerElement = document.getElementById(fields[i].id);

              if (containerElement !== null && containerElement !== undefined) {
                containerElement.innerHTML = "";
                containerElement.appendChild(iframe);
              } else {
                var divFormInputRow = document.createElement("div");

                divFormInputRow.className = "form--input__row";

                var divFormWrapRow = document.createElement("div");

                divFormWrapRow.className = "form--wrap__row";

                divFormInputRow.appendChild(divFormWrapRow);

                var divFormInputWrap = document.createElement("div");

                divFormInputWrap.id = fields[i].id;
                divFormInputWrap.className = "form--input__wrap col-10";

                divFormWrapRow.appendChild(divFormInputWrap);

                divFormInputWrap.appendChild(iframe);

                document
                  .getElementById("nexi-xpay-extra-fields-container")
                  .appendChild(divFormInputRow);
              }
            }
          });

          const surnameInputIsPresent = fields.find(function (field) {
            return field.id === "CARDHOLDER_SURNAME";
          });

          if (surnameInputIsPresent) {
            document
              .getElementById("CARDHOLDER_NAME")
              .classList.remove("col-10");
            document.getElementById("CARDHOLDER_NAME").classList.add("col-5");

            document
              .getElementById("CARDHOLDER_SURNAME")
              .classList.add("col-5");
          } else {
            document
              .getElementById("CARDHOLDER_NAME")
              .classList.remove("col-5");
            document.getElementById("CARDHOLDER_NAME").classList.add("col-10");

            document
              .getElementById("CARDHOLDER_SURNAME")
              .classList.remove("col-10");
          }
        }
      },
      complete: function () {
        hideLoading();
      },
    });
  }

  var cleanBuildFields = function () {
    $(".build-field-row").each(function (_i, fRow) {
      $(fRow)
        .children("div")
        .children("iframe")
        .each(function (_j, field) {
          $(field).remove();
        });
    });
  };

  var cleanErrorMsg = function () {
    $(".npg-build-error-msg-container").html("");
  };

  $(document).on("change", 'input[name="payment-option"]', function () {
    checkAndloadBuild();
  });
});
