/*
 * Copyright (c) 2020 Nexi Payments S.p.A.
 * @author      iPlusService S.r.l.
 * @copyright   Copyright (c) 2020 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
 * @license     GNU General Public License v3.0
 * @category    Payment Module
 * @version     8.0.0
 */

$(document).ready(function () {
  $('input[name="NEXIXPAY_APPLE_PAY_MERCHANT_IDENTIFIER_CERTIFICATE"]').attr(
    "value",
    $("#merchant-identifier-certificate-file-name").html()
  );
  $(
    'input[name="NEXIXPAY_APPLE_PAY_MERCHANT_IDENTIFIER_CERTIFICATE_KEY"]'
  ).attr("value", $("#merchant-identifier-certificate-key-file-name").html());
  $('input[name="NEXIXPAY_APPLE_PAY_MERCHANT_CA_ROOT_CERTIFICATE"]').attr(
    "value",
    $("#ca-root-certificate-file-name").html()
  );

  var controller_xpay = $("#controller_xpay").val();
  var controller_xpay_url = $("#controller_xpay_url").val();
  var id_order = $("#xpay_id_order").val();

  const integrationType = $("#NEXIXPAY_INTEGRATION_TYPE").val();

  hideShowGatewayProperties($(".gateway-input option:selected").val());

  hideShowInstallmentsProperties(
    $('input[name="NEXINPG_ENABLE_INSTALLMENTS"]:checked').val()
  );

  hideShowCategoriesProperties(
    $(
      'select[name="NEXIXPAY_PAGODIL_ENABLE_ON_CATEGORIES"] option:selected'
    ).val()
  );

  hideShowWidgetProperties(
    $('input[name="NEXIXPAY_PAGODIL_SHOW_WIDGET"]:checked').val()
  );

  $(".nexi_aop").click(function () {
    var amount = $("#nexi_aop_amount").val().replace(",", ".");
    var action = $(this).attr("action");

    var actionText = "";

    if ($(this).data("action-q")) {
      actionText = $(this).data("action-q");
    } else {
      actionText =
        $("#" + $(this).attr("action") + "-s").val() +
        " " +
        amount +
        " " +
        $("#currency-label").val();
    }

    if ($.isNumeric(amount) && amount > 0) {
      var domanda = confirm($("#action-question").val() + " " + actionText);

      if (domanda === true) {
        $("html, body").css("cursor", "wait");

        $.ajax({
          type: "POST",
          dataType: "json",
          url: controller_xpay_url,
          data: {
            ajax: true,
            controller: controller_xpay,
            action: action,
            id_order: id_order,
            amount: amount,
            gateway: $("#nexi_payment_gateway").val(),
          },
          success: function (json) {
            $("html, body").css("cursor", "default");
            alert(json["msg"]);
            window.location.reload();
          },
        });
      }
    } else {
      alert("Importo non valido!");

      $("#nexi_aop_amount").val("");
      $("#nexi_aop_amount").focus();
    }
  });

  $(".gateway-input").on("change", function () {
    hideShowGatewayProperties($(this).val());
  });

  $('input[name="NEXINPG_ENABLE_INSTALLMENTS"]').on("change", function () {
    hideShowInstallmentsProperties($(this).val());
  });

  $(".max-installments-add-button").on("click", function () {
    const randomId = Math.floor(Math.random() * 1000000 + 1);

    var options = "";
    for (var i = 1; i <= 99; i++) {
      options += "<option value='" + i + "'>" + i + "</option>";
    }

    $(".max-installments-to-amount-container").append(
      "" +
        " <div style='display: flex; margin-bottom: 5px;'>" +
        "     <input type='text' name='NEXINPG_MAX_INSTALLMENTS_TO_AMOUNT[" +
        randomId +
        "][amount]' style='margin-right: 5px;' />" +
        "     <select name='NEXINPG_MAX_INSTALLMENTS_TO_AMOUNT[" +
        randomId +
        "][installments]'>" +
        "         " +
        options +
        "     </select>" +
        "     <button class='btn btn-danger max-installments-remove-button' style='margin-left: 5px; padding: 5px 10px;' type='button'>" +
        "         <i class='material-icons'>delete</i>" +
        "     </button>" +
        " </div>"
    );

    const total = parseInt($("#max-installments-to-amount-length").val()) + 1;
    $("#max-installments-to-amount-length").val(total);

    hideShowInstallmentsMaxToAmountLabels();
  });

  $(document).on("click", ".max-installments-remove-button", function () {
    const total = parseInt($("#max-installments-to-amount-length").val()) - 1;
    $("#max-installments-to-amount-length").val(total);

    $(this).parent().remove();

    hideShowInstallmentsMaxToAmountLabels();
  });

  $('button[name="submitMODULE_NAME"]').on("submit", function (e) {
    e.preventDefault();

    var isValid = true;

    $(".max-installments-amount").each(function (index, input) {
      if (!/^\d+$/.test($(input).val()) || parseInt($(input).val()) === 0) {
        isValid = false;

        $(input).css("border", "1px solid red");

        $("html, body").animate(
          {
            scrollTop: $(input).offset().top,
          },
          200
        );
      } else {
        $(input).css("border", "1px solid #dee2e6");
      }
    });

    if (isValid) {
      if (parseInt($("#max-installments-to-amount-length").val()) === 0) {
        $(this).append(
          '<input type="hidden" name="NEXINPG_MAX_INSTALLMENTS_TO_AMOUNT" value="[]">'
        );
      } else {
        $("input[name='NEXINPG_MAX_INSTALLMENTS_TO_AMOUNT']").remove();
      }
    }
  });

  function hideShowGatewayProperties(flag) {
    if (flag == "npg") {
      $(".xpay-only").each(function () {
        $(this).attr("disabled", true);
        $($(this).parents(".form-group")[0]).hide();
      });

      $(".npg-only").each(function () {
        $(this).attr("disabled", false);
        $($(this).parents(".form-group")[0]).show();
      });

      $(".xpay-only-text").each(function () {
        $(this).hide();
      });

      $(".npg-only-text").each(function () {
        $(this).show();
      });

      if (integrationType === "redirect") {
        $("input[name='NEXIXPAY_ENABLE_ONECLICK']")
          .closest(".form-group")
          .show();
      } else {
        $("input[name='NEXIXPAY_ENABLE_ONECLICK']")
          .closest(".form-group")
          .hide();
      }

      if ($("div.panel[id*='nexixpaybuild_style']").length) {
        $("div.panel[id*='nexixpaybuild_style']").hide();
      }

      $("input[name='NEXINPG_ENABLE_MULTICURRENCY']").attr("disabled", false);
      $(
        $("input[name='NEXINPG_ENABLE_MULTICURRENCY']").parents(
          ".form-group"
        )[0]
      ).show();

      $("input[name='NEXINPG_ENABLE_INSTALLMENTS']").attr("disabled", false);
      $(
        $("input[name='NEXINPG_ENABLE_INSTALLMENTS']").parents(".form-group")[0]
      ).show();

      if ($("div.panel[id*='pagodil']").length) {
        $("div.panel[id*='pagodil']").hide();
      }

      if ($("div.panel[id*='applepay']").length) {
        $("div.panel[id*='applepay']").hide();
      }
    } else {
      $(".npg-only").each(function () {
        $(this).attr("disabled", true);
        $($(this).parents(".form-group")[0]).hide();
      });

      $(".xpay-only").each(function () {
        $(this).attr("disabled", false);
        $($(this).parents(".form-group")[0]).show();
      });

      $(".npg-only-text").each(function () {
        $(this).hide();
      });

      $(".xpay-only-text").each(function () {
        $(this).show();
      });

      $("input[name='NEXIXPAY_ENABLE_ONECLICK']").attr("disabled", false);
      $(
        $("input[name='NEXIXPAY_ENABLE_ONECLICK']").parents(".form-group")[0]
      ).show();

      if ($("div.panel[id*='nexixpaybuild_style']").length) {
        $("div.panel[id*='nexixpaybuild_style']").show();
      }

      $("input[name='NEXINPG_ENABLE_MULTICURRENCY']").attr("disabled", true);
      $(
        $("input[name='NEXINPG_ENABLE_MULTICURRENCY']").parents(
          ".form-group"
        )[0]
      ).hide();

      $("input[name='NEXINPG_ENABLE_INSTALLMENTS']").attr("disabled", true);
      $(
        $("input[name='NEXINPG_ENABLE_INSTALLMENTS']").parents(".form-group")[0]
      ).hide();

      if ($("div.panel[id*='pagodil']").length) {
        $("div.panel[id*='pagodil']").show();
      }

      if ($("div.panel[id*='applepay']").length) {
        $("div.panel[id*='applepay']").show();
      }
    }
  }

  function hideShowInstallmentsProperties(flag) {
    if (flag == "1") {
      $(".installments-only").each(function () {
        $(this).attr("disabled", false);
        $($(this).parents(".form-group")[0]).show();
      });
    } else {
      $(".installments-only").each(function () {
        $(this).attr("disabled", true);
        $($(this).parents(".form-group")[0]).hide();
      });
    }

    hideShowInstallmentsMaxToAmountLabels();
  }

  function hideShowInstallmentsMaxToAmountLabels() {
    if ($("#max-installments-to-amount-length").val() == 0) {
      $(".max-installments-to-amount-labels").hide();
    } else {
      $(".max-installments-to-amount-labels").show();
    }
  }

  $('input[name="NEXIXPAY_PAGODIL_SHOW_WIDGET"]').on("change", function () {
    hideShowWidgetProperties($(this).val());
  });

  function hideShowWidgetProperties(valore) {
    if (parseInt(valore) == 0) {
      $(".widget-properties").each(function () {
        $(this).parent().parent().hide();
      });
    } else {
      $(".widget-properties").each(function () {
        $(this).parent().parent().show();
      });
    }
  }

  $('select[name="NEXIXPAY_PAGODIL_ENABLE_ON_CATEGORIES"]').on(
    "change",
    function () {
      hideShowCategoriesProperties($(this).val());
    }
  );

  function hideShowCategoriesProperties(valore) {
    if (valore == "all") {
      $("#categories-tree").parent().parent().parent().hide();
    } else {
      $("#categories-tree").parent().parent().parent().show();
    }
  }

  $(".styleBlock").each(function (_index, element) {
    renderPreview($(element));
  });

  $(".info-helper").each(function (_index, element) {
    sistemaDefault($(element), false);
  });

  $(".styleBlock").on("change", function () {
    renderPreview($(this));
  });

  $(".info-helper").click(function () {
    sistemaDefault($(this), true);
  });

  function renderPreview(element) {
    if (element.data("input-type") === "simple" || element.data("input-type") === '"simple"') {
      if (element.data("field") === "border-color" || element.data("field") === '"border-color"') {
        $(".stylePreview .content-anteprima div.Bricks").css(
          "border-color",
          element.val()
        );
      } else if (element.data("field") === "font-family" || element.data("field") === '"font-family"') {
        $("#dynamicStyle2").text(
          ".stylePreview .content-anteprima .Bricks input {font-family: " +
            element.val() +
            " !important; }"
        );
      } else {
        $(".stylePreview .content-anteprima .Bricks input").css(
          element.data("field"),
          element.val()
        );
      }
    } else {
      if (element.data("field") === "color" || element.data("field") === '"color"') {
        $("#dynamicStyle").text(
          ".stylePreview .content-anteprima .Bricks input::placeholder { color: " +
            element.val() +
            "}"
        );
      }
    }
  }

  function sistemaDefault(element, click) {
    var id = element.data("id");

    if (id) {
      if (click || !$("#" + id).val()) {
        $("#" + id).val(element.data("default"));
        $("#" + id).trigger("change");
      }
    }
  }

  $(document).on("click", 'button[name="submitAddAttachments"]', function () {
    var targetId = $(this)
      .attr("id")
      .replace(/-selectbutton/g, "");

    if (typeof timer !== "undefined") {
      clearInterval(timer);
    }

    var timer = setInterval(function () {
      if ($("#" + targetId).val() !== "") {
        clearInterval(timer);

        var fileInput = $("#" + targetId)[0].files[0];

        const formData = new FormData();

        formData.append("ajax", true);
        formData.append("controller", "AdminNexiXPay");
        formData.append("action", "uploadingCertificates");
        formData.append("file", fileInput);

        jQuery.ajax({
          type: "POST",
          url: controller_xpay_url,
          data: formData,
          processData: false,
          contentType: false,
          success: function (json) {
            // if (json["error"]) {
            //   alert(json["error"]);
            // }
          },
          error: function (xhr, ajaxOptions, thrownError) {
            console.error(
              thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText
            );
          },
        });
      }
    }, 500);
  });
});
