{**
* Copyright (c) 2019 Nexi Payments S.p.A.
*
* @author iPlusService S.r.l.
* @copyright Copyright (c) 2019 Nexi Payments S.p.A. (https://ecommerce.nexi.it)
* @license GNU General Public License v3.0
* @category Payment Module
* @version 8.0.0
*}
<div id="apm-order-body">
    {foreach $apms as $apm}
        <div class="apm-row mdi-drag-horizontal-variant" draggable="true" data-value="' . $apm['value'] . '" <link
            href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
            <div class="sort-image">
                {if $apm['value'] == "paymentcards"}
                    <div class="nexi-logo background-nexi-logo-image"></div>
                {else}
                    <img src="{$apm['imageLink']|escape:'htmlall':'UTF-8'}" alt="Logo {$apm['label']|escape:'htmlall':'UTF-8'}">
                {/if}
            </div>
            <div class="sort-label"><span>{$apm['label']|escape:'htmlall':'UTF-8'}</span></div>
            <div class="sort-description"><span>{$apm['description']|escape:'htmlall':'UTF-8'}</span></div>
            <div class="sort-icon">
                <div></div>
                <div></div>
            </div>
        </div>
    {/foreach}
</div>

<input type="hidden" name="NEXIXPAY_APM_ORDER" id="NEXIXPAY_APM_ORDER">

<script>
    let dragged;

    document.querySelectorAll("#apm-order-body .apm-row").forEach(row => {
        row.addEventListener("dragstart", (e) => {
            dragged = row;
            e.dataTransfer.effectAllowed = "move";
        });

        row.addEventListener("dragover", (e) => {
            e.preventDefault();
            e.dataTransfer.dropEffect = "move";
        });

        row.addEventListener("drop", (e) => {
            e.preventDefault();
            if (dragged && dragged !== row) {
                const tbody = row.parentNode;
                const rows = Array.from(tbody.children);
                const draggedIndex = rows.indexOf(dragged);
                const targetIndex = rows.indexOf(row);

                tbody.insertBefore(dragged, (draggedIndex < targetIndex) ? row.nextSibling : row);

                updateHiddenOrderInput();
            }
        });
    });

    function updateHiddenOrderInput() {
        const order = Array.from(document.querySelectorAll("#apm-order-body .apm-row"))
            .map(row => row.getAttribute("data-value"));
        document.getElementById("NEXIXPAY_APM_ORDER").value = JSON.stringify(order);
    }
    updateHiddenOrderInput();
</script>