<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */

namespace PrestaShop\Module\PsAccounts\ServiceProvider;

use PrestaShop\Module\PsAccounts\Api\Client\AccountsClient;
use PrestaShop\Module\PsAccounts\Api\Client\ExternalAssetsClient;
use PrestaShop\Module\PsAccounts\Api\Client\ServicesBillingClient;
use PrestaShop\Module\PsAccounts\Http\Client\ClientConfig;
use PrestaShop\Module\PsAccounts\Provider\ShopProvider;
use PrestaShop\Module\PsAccounts\Service\Accounts\AccountsService;
use PrestaShop\Module\PsAccounts\Service\AnalyticsService;
use PrestaShop\Module\PsAccounts\Service\PsAccountsService;
use PrestaShop\Module\PsAccounts\Vendor\PrestaShopCorp\LightweightContainer\ServiceContainer\Contract\IServiceProvider;
use PrestaShop\Module\PsAccounts\Vendor\PrestaShopCorp\LightweightContainer\ServiceContainer\ServiceContainer;

class ApiClientProvider implements IServiceProvider
{
    /**
     * @param ServiceContainer $container
     *
     * @return void
     */
    public function provide(ServiceContainer $container)
    {
        $container->registerProvider(AccountsClient::class, static function () use ($container) {
            return new AccountsClient($container->get(AccountsService::class));
        });
        $container->registerProvider(AccountsService::class, static function () use ($container) {
            return new AccountsService([
                ClientConfig::BASE_URI => $container->getParameter('ps_accounts.accounts_api_url'),
                ClientConfig::SSL_CHECK => $container->getParameter('ps_accounts.check_api_ssl_cert'),
                ClientConfig::HEADERS => [
                    'X-Anonymous-ID' => $container->get(AnalyticsService::class)->getAnonymousId(),
                ],
            ]);
        });
        $container->registerProvider(ExternalAssetsClient::class, static function () {
            return new ExternalAssetsClient([
                ClientConfig::BASE_URI => '',
            ]);
        });
        $container->registerProvider(ServicesBillingClient::class, static function () use ($container) {
            return new ServicesBillingClient(
                $container->getParameter('ps_accounts.billing_api_url'),
                $container->get(PsAccountsService::class),
                $container->get(ShopProvider::class)
            );
        });
    }
}
