<?php
if (!defined('_PS_VERSION_')) { exit; }

class Sbheadercustomizer extends Module
{
    const CFG_LOGO_HEIGHT = 'SBHEADERCUSTOMIZER_LOGO_HEIGHT';
    const CFG_HEADER_PAD_Y = 'SBHEADERCUSTOMIZER_HEADER_PAD_Y';
    const CFG_HEADER_BG = 'SBHEADERCUSTOMIZER_HEADER_BG';
    const CFG_CUSTOM_CSS = 'SBHEADERCUSTOMIZER_CUSTOM_CSS';

    public function __construct()
    {
        $this->name = 'sbheadercustomizer';
        $this->tab = 'front_office_features';
        $this->version = '1.0.5';
        $this->author = 'Spiderbyte';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('Header Customizer (Logo size)');
        $this->description = $this->l('Imposta altezza logo (proporzionale) e spazi header senza toccare il tema.');
        $this->ps_versions_compliancy = array('min' => '8.1.0', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        return parent::install()
            && $this->registerHook('displayHeader')
            && Configuration::updateValue(self::CFG_LOGO_HEIGHT, 90)
            && Configuration::updateValue(self::CFG_HEADER_PAD_Y, 16)
            && Configuration::updateValue(self::CFG_HEADER_BG, '')
            && Configuration::updateValue(self::CFG_CUSTOM_CSS, '');
    }

    public function uninstall()
    {
        return parent::uninstall()
            && Configuration::deleteByName(self::CFG_LOGO_HEIGHT)
            && Configuration::deleteByName(self::CFG_HEADER_PAD_Y)
            && Configuration::deleteByName(self::CFG_HEADER_BG)
            && Configuration::deleteByName(self::CFG_CUSTOM_CSS);
    }

    public function getContent()
    {
        $output = '';
        if (Tools::isSubmit('submit'.$this->name)) {
            $logoHeight = (int)Tools::getValue(self::CFG_LOGO_HEIGHT);
            $padY = (int)Tools::getValue(self::CFG_HEADER_PAD_Y);
            $bg = trim((string)Tools::getValue(self::CFG_HEADER_BG));
            $customCss = (string)Tools::getValue(self::CFG_CUSTOM_CSS);

            if ($logoHeight < 20 || $logoHeight > 240) {
                $output .= $this->displayError($this->l('Altezza logo non valida (20–240px).'));
            } elseif ($padY < 0 || $padY > 120) {
                $output .= $this->displayError($this->l('Padding verticale non valido (0–120px).'));
            } elseif ($bg !== '' && !preg_match('/^#([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/', $bg)) {
                $output .= $this->displayError($this->l('Colore non valido. Usa formato #RGB o #RRGGBB.'));
            } else {
                Configuration::updateValue(self::CFG_LOGO_HEIGHT, $logoHeight);
                Configuration::updateValue(self::CFG_HEADER_PAD_Y, $padY);
                Configuration::updateValue(self::CFG_HEADER_BG, $bg);
                Configuration::updateValue(self::CFG_CUSTOM_CSS, $customCss);
                $output .= $this->displayConfirmation($this->l('Impostazioni salvate.'));
            }
        }
        return $output . $this->renderForm();
    }

    protected function renderForm()
    {
        $defaultLang = (int)Configuration::get('PS_LANG_DEFAULT');
        $fieldsForm = array(
            'form' => array(
                'legend' => array('title' => $this->l('Impostazioni'), 'icon' => 'icon-cogs'),
                'input' => array(
                    array('type' => 'text', 'label' => $this->l('Altezza logo (px)'), 'name' => self::CFG_LOGO_HEIGHT, 'class' => 'fixed-width-sm', 'desc' => $this->l('Larghezza proporzionale automatica.')),
                    array('type' => 'text', 'label' => $this->l('Padding verticale header (px)'), 'name' => self::CFG_HEADER_PAD_Y, 'class' => 'fixed-width-sm'),
                    array('type' => 'text', 'label' => $this->l('Colore sfondo header (opzionale)'), 'name' => self::CFG_HEADER_BG, 'class' => 'fixed-width-sm'),
                    array('type' => 'textarea', 'label' => $this->l('CSS personalizzato (opzionale)'), 'name' => self::CFG_CUSTOM_CSS, 'rows' => 8),
                ),
                'submit' => array('title' => $this->l('Salva'), 'class' => 'btn btn-default pull-right')
            )
        );

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->identifier = $this->identifier;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->default_form_language = $defaultLang;
        $helper->allow_employee_form_lang = (int)Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG');
        $helper->title = $this->displayName;
        $helper->submit_action = 'submit' . $this->name;

        $helper->fields_value[self::CFG_LOGO_HEIGHT] = (int)Configuration::get(self::CFG_LOGO_HEIGHT);
        $helper->fields_value[self::CFG_HEADER_PAD_Y] = (int)Configuration::get(self::CFG_HEADER_PAD_Y);
        $helper->fields_value[self::CFG_HEADER_BG] = (string)Configuration::get(self::CFG_HEADER_BG);
        $helper->fields_value[self::CFG_CUSTOM_CSS] = (string)Configuration::get(self::CFG_CUSTOM_CSS);

        return $helper->generateForm(array($fieldsForm));
    }

    public function hookDisplayHeader($params)
    {
        $logoHeight = (int)Configuration::get(self::CFG_LOGO_HEIGHT);
        $padY = (int)Configuration::get(self::CFG_HEADER_PAD_Y);
        $bg = trim((string)Configuration::get(self::CFG_HEADER_BG));
        $customCss = (string)Configuration::get(self::CFG_CUSTOM_CSS);

        $css = $this->buildCss($logoHeight, $padY, $bg, $customCss);
        return '<style id="' . $this->name . '-inline-css">' . $css . '</style>';
    }

    protected function buildCss($logoHeight, $padY, $bg, $customCss)
    {
        $logoHeight = max(20, min(240, (int)$logoHeight));
        $padY = max(0, min(120, (int)$padY));

        $bgRule = '';
        if ($bg !== '' && preg_match('/^#([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/', $bg)) {
            $bgRule = "#header{background: {$bg} !important;}";
        }

        // Il tuo HTML: a.navbar-brand.d-block > img.logo.img-fluid
        $logoSel = '#header a.navbar-brand img.logo, #header .navbar-brand img.logo';

        // Forza altezza e lascia width proporzionale, neutralizza bootstrap img-fluid (max-width:100%, height:auto)
        $imgRule = "height: {$logoHeight}px !important; width: auto !important; max-height: none !important; max-width: none !important; object-fit: contain !important;";

        $core = "\n#header{padding-top: {$padY}px !important; padding-bottom: {$padY}px !important;}\n"
              . "#header a.navbar-brand{display:inline-flex !important; align-items:center !important;}\n"
              . $logoSel . "{" . $imgRule . "}\n"
              . $bgRule . "\n";

        if (!empty($customCss)) {
            $core .= "\n/* Custom user CSS */\n" . $customCss . "\n";
        }
        return trim($core);
    }
}
