<?php
if (!defined('_PS_VERSION_')) { exit; }
class SbpcbuilderBuilderModuleFrontController extends ModuleFrontController
{
    protected function buildImageLink($id_image, $id_product, $type = 'home_default')
    { if (!$id_image || !$id_product) { return ''; } $product = new Product((int)$id_product, false, (int)$this->context->language->id); return $this->context->link->getImageLink($product->link_rewrite, (int)$id_product.'-'.(int)$id_image, $type); }

    protected function getProductFeatureValuesByNames($id_product, array $featureNames)
    {
        $out = array(); if (empty($featureNames)) return $out; $idLang = (int)$this->context->language->id; $rows = Product::getFeaturesStatic((int)$id_product); if (!is_array($rows)) return $out; static $cacheFeatureNames=array(); static $cacheFeatureValueText=array(); foreach ($rows as $fp){ $idf=(int)$fp['id_feature']; $idv=(int)$fp['id_feature_value']; if(!isset($cacheFeatureNames[$idf])){ $name=Db::getInstance()->getValue('SELECT fl.name FROM '._DB_PREFIX_.'feature_lang fl WHERE fl.id_feature='.(int)$idf.' AND fl.id_lang='.(int)$idLang); $cacheFeatureNames[$idf]=$name?trim((string)$name):''; } $fname=$cacheFeatureNames[$idf]; if($fname==='') continue; $k=Tools::strtolower(trim($fname)); if(!isset($featureNames[$k])) continue; if(!isset($cacheFeatureValueText[$idv])){ $val=Db::getInstance()->getValue('SELECT fvl.value FROM '._DB_PREFIX_.'feature_value_lang fvl WHERE fvl.id_feature_value='.(int)$idv.' AND fvl.id_lang='.(int)$idLang); $cacheFeatureValueText[$idv]=$val?trim((string)$val):''; } $out[$featureNames[$k]]=(string)$cacheFeatureValueText[$idv]; } return $out;
    }

    protected function loadProductsForCategories(array $catIds, $allowOOS = true, $sortBy = 'price', $sortDir = 'asc', $limit = 50, array $neededFeatures = array())
    {
        $catIds = array_filter(array_map('intval', $catIds)); if (empty($catIds)) { return array(); }
        $idShop = (int)$this->context->shop->id; $idLang = (int)$this->context->language->id; $prefix = _DB_PREFIX_;
        $sql = 'SELECT cp.id_product FROM `'.pSQL($prefix).'category_product` cp '
             .'INNER JOIN `'.pSQL($prefix).'product_shop` ps ON ps.id_product=cp.id_product AND ps.id_shop='.(int)$idShop.' AND ps.active=1 '
             .'INNER JOIN `'.pSQL($prefix).'product` p ON p.id_product=ps.id_product '
             .'WHERE cp.id_category IN ('.implode(',', array_map('intval',$catIds)).') '
             .'GROUP BY cp.id_product '
             .'LIMIT '.(int)($limit*3);
        $ids = array(); foreach (Db::getInstance()->executeS($sql) as $r) { $ids[]=(int)$r['id_product']; }
        $ids = array_values(array_unique($ids)); if (!$ids) { return array(); }
        $rows = array();
        foreach ($ids as $idp) {
            $qty = (int)StockAvailable::getQuantityAvailableByProduct($idp, 0, $idShop); if (!$allowOOS && $qty<=0) { continue; }
            $price_incl = (float)Product::getPriceStatic($idp, true); $price_excl = (float)Product::getPriceStatic($idp, false);
            $p = new Product($idp, false, $idLang, $idShop); $name = is_array($p->name) ? (string)reset($p->name) : (string)$p->name;
            $cover = Product::getCover($idp); $img=''; if ($cover && isset($cover['id_image'])) { $img = $this->buildImageLink((int)$cover['id_image'], (int)$idp, 'home_default'); }
            $feat = !empty($neededFeatures) ? $this->getProductFeatureValuesByNames($idp, $neededFeatures) : array();
            $rows[] = array('id_product'=>$idp,'name'=>$name,'price_excl'=>$price_excl,'price_incl'=>$price_incl,'image'=>$img,'quantity_available'=>$qty,'features'=>$feat);
            if (count($rows) >= $limit) { break; }
        }
        $sortBy = in_array($sortBy, array('price','name'), true) ? $sortBy : 'price'; $sortDir = strtolower($sortDir)==='desc'?'desc':'asc';
        usort($rows, function($a,$b) use ($sortBy,$sortDir){ $va = ($sortBy==='name')?Tools::strtolower($a['name']):(float)$a['price_incl']; $vb = ($sortBy==='name')?Tools::strtolower($b['name']):(float)$b['price_incl']; if ($va==$vb) return 0; $res = ($va<$vb)?-1:1; return ($sortDir==='asc')?$res:-$res; });
        return $rows;
    }

    public function initContent()
    {
        parent::initContent();
        $allow_oos = (int)Configuration::get('SBPCB_ALLOW_OOS_SELECTION');
        $components_json = Configuration::get('SBPCB_COMPONENTS'); if ($components_json===false || $components_json===null) { $components_json='[]'; }
        $components = json_decode($components_json, true); if (!is_array($components)) { $components=array(); }
        $rules_json = Configuration::get('SBPCB_RULES'); $rules = json_decode($rules_json ?: '[]', true); if (!is_array($rules)) $rules = array();
        $neededFeatures = array(); foreach ($rules as $r){ if (isset($r['if']['feature']) && $r['if']['feature']) { $neededFeatures[Tools::strtolower(trim($r['if']['feature']))] = (string)$r['if']['feature']; } if (isset($r['eq']['feature']) && $r['eq']['feature']) { $neededFeatures[Tools::strtolower(trim($r['eq']['feature']))] = (string)$r['eq']['feature']; } }
        $componentProducts = array(); foreach ($components as $c) { if (!is_array($c) || empty($c['key'])) { continue; } $key = (string)$c['key']; $cats = array(); if (!empty($c['category_ids']) && is_array($c['category_ids'])) { $cats = array_filter(array_map('intval',$c['category_ids'])); } elseif (!empty($c['categories'])) { $cats = array_filter(array_map('intval', explode(',', (string)$c['categories']))); } $sortBy = !empty($c['sort_by']) ? (string)$c['sort_by'] : 'price'; $sortDir = !empty($c['sort_dir']) ? (string)$c['sort_dir'] : 'asc'; $limit   = !empty($c['limit']) ? (int)$c['limit'] : 24; $componentProducts[$key] = $cats ? $this->loadProductsForCategories($cats, (bool)$allow_oos, $sortBy, $sortDir, $limit, $neededFeatures) : array(); }
        $this->context->smarty->assign(array('module_name'=>$this->module->name,'components'=>$components,'componentProducts'=>$componentProducts,'link'=>$this->context->link,'rules'=>$rules));
        $this->setTemplate('module:sbpcbuilder/views/templates/front/builder.tpl');
    }
}
?>
