<?php
class SbpcbuilderDaneaxmlModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        try {
            $id_build = (int)Tools::getValue('id_build'); if ($id_build<=0) { header('HTTP/1.1 400 Bad Request'); die('Invalid build id'); }
            $sig = Tools::getValue('sig'); $key = Configuration::get('SBPCB_PDF_KEY'); $expected = hash_hmac('sha256', (string)$id_build, (string)$key); if (!$sig || !hash_equals($expected,(string)$sig)) { header('HTTP/1.1 403 Forbidden'); die('Forbidden'); }
            $prefix = _DB_PREFIX_;
            $build = Db::getInstance()->getRow('SELECT * FROM `'.pSQL($prefix).'sb_pc_builds` WHERE `id_build`='.(int)$id_build); if (!$build) { header('HTTP/1.1 404 Not Found'); die('Build not found'); }
            $items = Db::getInstance()->executeS('SELECT * FROM `'.pSQL($prefix).'sb_pc_build_items` WHERE `id_build`='.(int)$id_build.' ORDER BY `id_item`');

            $vatPerc = (float)Configuration::get('SBPCB_DANEA_VAT_PERC'); if ($vatPerc < 0) $vatPerc = 0; if ($vatPerc > 100) $vatPerc = 100;

            $xml = new DOMDocument('1.0', 'UTF-8'); $xml->formatOutput = true;
            $root = $xml->createElement('EasyfattDocuments'); $root->setAttribute('AppVersion','2'); $root->setAttribute('Creator','Spiderbyte PC Builder'); $root->setAttribute('CreatorUrl','spiderbyte.eu'); $xml->appendChild($root);
            $docs = $xml->createElement('Documents'); $root->appendChild($docs);
            $doc = $xml->createElement('Document'); $docs->appendChild($doc);
            // Omitting <DocumentType> to default to Ordine cliente (C)
            $this->appendNode($xml,$doc,'CustomerName', $build['customer_name']);
            $this->appendNode($xml,$doc,'Date', substr($build['date_add'],0,10));
            $this->appendNode($xml,$doc,'Number', (string)$build['id_build']);
            $this->appendNode($xml,$doc,'InternalComment', 'Preventivo: '.($build['custom_name']?:$build['reference']));
            $this->appendNode($xml,$doc,'PricesIncludeVat','true');

            $rowsEl = $xml->createElement('Rows'); $doc->appendChild($rowsEl);
            foreach ($items as $r){
                $idp=(int)$r['id_product']; $product = $idp>0 ? new Product($idp,false,(int)$this->context->language->id) : null;
                $row = $xml->createElement('Row'); $rowsEl->appendChild($row);
                $code = $product ? (string)$product->reference : '';
                $this->appendNode($xml,$row,'Code', $code);
                $this->appendNode($xml,$row,'Description', (string)$r['product_name']);
                $this->appendNode($xml,$row,'Qty', (string)$r['quantity']);
                $this->appendNode($xml,$row,'Um', 'pz');
                $this->appendNode($xml,$row,'Price', (string)number_format((float)$r['price_incl'], 2, '.', ''));
                $vat = $xml->createElement('VatCode', (string)$vatPerc); $vat->setAttribute('Perc', (string)$vatPerc); $row->appendChild($vat);
            }

            $fname = 'ordine_'.preg_replace('/[^A-Za-z0-9_-]+/','-', (string)$build['reference']).'.xml';
            while (ob_get_level()>0) { @ob_end_clean(); }
            header('Content-Type: application/xml; charset=UTF-8');
            header('Content-Disposition: attachment; filename="'.$fname.'"');
            echo $xml->saveXML(); exit;
        } catch (Exception $e) { header('HTTP/1.1 500 Internal Server Error'); echo 'Errore XML: '.htmlspecialchars($e->getMessage()); exit; }
    }

    private function appendNode($xml,$parent,$name,$value){ if($value===null||$value==='') return; $n=$xml->createElement($name); $n->appendChild($xml->createTextNode($value)); $parent->appendChild($n); }
}
?>
