<?php
require_once _PS_MODULE_DIR_.'sbpcbuilder/classes/pdf/HTMLTemplatePcQuote.php';
require_once _PS_MODULE_DIR_.'sbpcbuilder/classes/pdf/HTMLTemplatePcQuoteCodes.php';
class SbpcbuilderQuoteModuleFrontController extends ModuleFrontController
{
    protected function buildImageLink($id_image, $id_product, $type = 'home_default')
    { if (!$id_image || !$id_product) { return ''; } $product = new Product((int)$id_product, false, (int)$this->context->language->id); return $this->context->link->getImageLink($product->link_rewrite, (int)$id_product.'-'.(int)$id_image, $type); }

    public function initContent(){ parent::initContent(); $this->setTemplate('module:sbpcbuilder/views/templates/front/builder.tpl'); }
    public function postProcess(){ if (Tools::isSubmit('sbpcb_generate')) { return $this->generatePdf(); } }

    protected function generatePdf()
    {
        try {
            $components_json = Configuration::get('SBPCB_COMPONENTS'); if ($components_json===false || $components_json===null) { $components_json='[]'; }
            $components = json_decode($components_json, true); if (!is_array($components)) { $components = array(); }

            $parseBundle = function($key){ $raw = Tools::getValue('component_'.$key.'_bundle'); if (!$raw) return array(); $arr = json_decode((string)$raw, true); if (!is_array($arr)) return array(); $out=array(); foreach ($arr as $it){ $id=(int)($it['id']??0); $qty=max(0,(int)($it['qty']??0)); if($id>0 && $qty>0){ $out[] = array('id'=>$id,'qty'=>$qty); } } return $out; };

            // Required enforcement
            $missing = array(); foreach ($components as $comp) { if (!is_array($comp)) continue; $key = isset($comp['key']) ? (string)$comp['key'] : ''; if ($key==='') continue; $label = isset($comp['label']) ? (string)$comp['label'] : $key; $required = !empty($comp['required']); if ($required) { $bundle = $parseBundle($key); if (!empty($bundle)) { continue; } $idp = (int)Tools::getValue('component_'.$key.'_id'); $qty = max(0,(int)Tools::getValue('component_'.$key.'_qty')); if ($idp <= 0 || $qty <= 0) { $missing[] = $label; } } }
            if (!empty($missing)) { $this->errors[] = $this->l('Seleziona i componenti obbligatori:').' '.implode(', ', array_map('htmlspecialchars', $missing)); $this->initContent(); return; }

            // Compatibility rules (block)
            $rules_json = Configuration::get('SBPCB_RULES'); $rules = json_decode($rules_json ?: '[]', true); if (!is_array($rules)) $rules = array();
            $featureCache = array(); $idLang = (int)$this->context->language->id; $getFeat = function($idp) use (&$featureCache, $idLang){ $idp=(int)$idp; if(isset($featureCache[$idp])) return $featureCache[$idp]; $map=array(); $rows=Product::getFeaturesStatic($idp); if(is_array($rows)){ foreach($rows as $fp){ $idf=(int)$fp['id_feature']; $idv=(int)$fp['id_feature_value']; $name=Db::getInstance()->getValue('SELECT fl.name FROM '._DB_PREFIX_.'feature_lang fl WHERE fl.id_feature='.(int)$idf.' AND fl.id_lang='.(int)$idLang); if($name){ $name=trim((string)$name); $val=Db::getInstance()->getValue('SELECT fvl.value FROM '._DB_PREFIX_.'feature_value_lang fvl WHERE fvl.id_feature_value='.(int)$idv.' AND fvl.id_lang='.(int)$idLang); $map[Tools::strtolower(trim($name))] = $val ? trim((string)$val) : ''; } } } $featureCache[$idp]=$map; return $map; };

            $selectedRows = array(); $total_excl = 0.0; $total_incl = 0.0;
            foreach ($components as $comp) {
                if (!is_array($comp)) continue; $key = (string)($comp['key']??''); if ($key==='') continue; $label=(string)($comp['label']??$key);
                $bundle = $parseBundle($key);
                if (!empty($bundle)) { foreach ($bundle as $row) { $idp=(int)$row['id']; $qty=max(0,(int)$row['qty']); if($idp<=0||$qty<=0) continue; $price_excl=(float)Product::getPriceStatic($idp,false); $price_incl=(float)Product::getPriceStatic($idp,true); $total_excl += ($price_excl*$qty); $total_incl += ($price_incl*$qty); $product=new Product($idp,false,(int)$this->context->language->id); $cover=Product::getCover($idp); $image_link=''; if($cover && isset($cover['id_image'])){ $image_link=$this->buildImageLink((int)$cover['id_image'], (int)$idp, 'home_default'); } $selectedRows[] = array('key'=>$key,'label'=>$label,'id_product'=>$idp,'product_name'=>$product->name,'qty'=>$qty,'price_excl'=>$price_excl,'price_incl'=>$price_incl,'image_link'=>$image_link,'reference'=>$product->reference); } continue; }
                $idp=(int)Tools::getValue('component_'.$key.'_id'); $qty=max(0,(int)Tools::getValue('component_'.$key.'_qty')); if($idp>0&&$qty>0){ $price_excl=(float)Product::getPriceStatic($idp,false); $price_incl=(float)Product::getPriceStatic($idp,true); $total_excl += ($price_excl*$qty); $total_incl += ($price_incl*$qty); $product=new Product($idp,false,(int)$this->context->language->id); $cover=Product::getCover($idp); $image_link=''; if($cover && isset($cover['id_image'])){ $image_link=$this->buildImageLink((int)$cover['id_image'], (int)$idp, 'home_default'); } $selectedRows[] = array('key'=>$key,'label'=>$label,'id_product'=>$idp,'product_name'=>$product->name,'qty'=>$qty,'price_excl'=>$price_excl,'price_incl'=>$price_incl,'image_link'=>$image_link,'reference'=>$product->reference); }
            }

            $id_customer = (int)$this->context->customer->id; $customer_name = ($this->context->customer && $this->context->customer->id) ? ($this->context->customer->firstname.' '.$this->context->customer->lastname) : '';
            $reference = 'PCQ-'.date('Ymd-His'); $valid_days = (int)Configuration::get('SBPCB_QUOTE_VALIDITY_DAYS'); if ($valid_days<=0) { $valid_days=15; }
            $date_add = date('Y-m-d H:i:s'); $valid_until = date('Y-m-d H:i:s', strtotime('+'.$valid_days.' days'));
            $currency_iso = $this->context->currency ? $this->context->currency->iso_code : 'EUR'; $custom_name = Tools::getValue('sbpcb_custom_name');
            Db::getInstance()->insert('sb_pc_builds', array('reference'=>pSQL($reference),'custom_name'=>pSQL($custom_name),'id_customer'=>(int)$id_customer,'customer_name'=>pSQL($customer_name),'date_add'=>pSQL($date_add),'valid_until'=>pSQL($valid_until),'total_excl'=>(float)$total_excl,'total_incl'=>(float)$total_incl,'currency'=>pSQL($currency_iso)));
            $id_build = (int)Db::getInstance()->Insert_ID();
            foreach ($selectedRows as $row) { Db::getInstance()->insert('sb_pc_build_items', array('id_build'=>(int)$id_build,'component_key'=>pSQL($row['key']),'component_label'=>pSQL($row['label']),'id_product'=>(int)$row['id_product'],'product_name'=>pSQL($row['product_name']),'quantity'=>(int)$row['qty'],'price_excl'=>(float)$row['price_excl'],'price_incl'=>(float)$row['price_incl'])); }

            $sig = hash_hmac('sha256', (string)$id_build, (string)Configuration::get('SBPCB_PDF_KEY'));
            $url = $this->context->link->getModuleLink($this->module->name, 'quotepdf', array('id_build'=>$id_build, 'sig'=>$sig));
            Tools::redirect($url); exit;
        } catch (Exception $e) { header('HTTP/1.1 500 Internal Server Error'); echo 'Errore generazione PDF: '.htmlspecialchars($e->getMessage()); exit; }
    }
}
?>
