<?php
require_once _PS_MODULE_DIR_.'sbpcbuilder/classes/pdf/HTMLTemplatePcQuote.php';
class SbpcbuilderQuotepdfModuleFrontController extends ModuleFrontController
{
    protected function buildImageLink($id_image, $id_product, $type = 'home_default')
    { if (!$id_image || !$id_product) { return ''; } $product = new Product((int)$id_product, false, (int)$this->context->language->id); return $this->context->link->getImageLink($product->link_rewrite, (int)$id_product.'-'.(int)$id_image, $type); }

    public function initContent()
    {
        parent::initContent();
        try {
            $id_build = (int)Tools::getValue('id_build'); if ($id_build<=0) { header('HTTP/1.1 400 Bad Request'); die('Invalid build id'); }
            $sig = Tools::getValue('sig'); $key = Configuration::get('SBPCB_PDF_KEY'); $expected = hash_hmac('sha256', (string)$id_build, (string)$key); if (!$sig || !hash_equals($expected,(string)$sig)) { header('HTTP/1.1 403 Forbidden'); die('Forbidden'); }
            $prefix = _DB_PREFIX_;
            $build = Db::getInstance()->getRow('SELECT * FROM `'.pSQL($prefix).'sb_pc_builds` WHERE `id_build`='.(int)$id_build); if (!$build) { header('HTTP/1.1 404 Not Found'); die('Build not found'); }
            if (!empty($build['valid_until'])) { try { $now=new DateTime(); $vu=new DateTime($build['valid_until']); if ($now>$vu) { header('HTTP/1.1 410 Gone'); die('Quote expired'); } } catch (Exception $e) {} }
            $raw_items = Db::getInstance()->executeS('SELECT * FROM `'.pSQL($prefix).'sb_pc_build_items` WHERE `id_build`='.(int)$id_build.' ORDER BY `id_item`');
            $items=array(); foreach ($raw_items as $r) { $idp=(int)$r['id_product']; $image_link=''; if ($idp>0) { $cover=Product::getCover($idp); if ($cover && isset($cover['id_image'])) { $image_link=$this->buildImageLink((int)$cover['id_image'], (int)$idp, 'home_default'); } } $r['image_link']=$image_link; $items[]=$r; }
            $sbpcb_build = array('id_build'=>(int)$build['id_build'],'reference'=>$build['reference'],'custom_name'=>$build['custom_name'],'customer_name'=>$build['customer_name'],'date_add'=>$build['date_add'],'valid_until'=>$build['valid_until'],'currency'=>$build['currency'],'total_excl'=>(float)$build['total_excl'],'total_incl'=>(float)$build['total_incl'],'items'=>$items);
            $this->context->smarty->assign(array('sbpcb_build'=>$sbpcb_build)); while (ob_get_level()>0) { @ob_end_clean(); }
            $pdf = new PDF((object)array('id_build'=>$build['id_build']), 'PcQuote', $this->context->smarty); $pdf->render(); exit;
        } catch (Exception $e) { header('HTTP/1.1 500 Internal Server Error'); echo 'Errore PDF: '.htmlspecialchars($e->getMessage()); exit; }
    }
}
?>
