
<?php
if (!defined('_PS_VERSION_')) { exit; }

class Sbpcbuilder extends Module
{
    public function __construct()
    {
        $this->name = 'sbpcbuilder';
        $this->tab = 'front_office_features';
        $this->version = '0.2.0.0';
        $this->author = 'Spiderbyte';
        $this->need_instance = 0;

        parent::__construct();

        $this->displayName = $this->l('Spiderbyte PC Builder');
        $this->description = $this->l('PC builder and quote PDF generator with secure PDF links and selective compatibility blocking.');
        $this->ps_versions_compliancy = array('min' => '1.7.0.0', 'max' => _PS_VERSION_);
    }

    /**
     * Aggiunge la voce di menu "PC Builder" sotto Catalogo (AdminCatalog)
     * e la associa al modulo. Ordine in coda, senza icona.
     */
    private function installTabs()
    {
        // Evita duplicati se la tab esiste già
        $existingId = (int) Tab::getIdFromClassName('AdminSbpcbuilder');
        if ($existingId) {
            return true;
        }

        $tab = new Tab();
        $tab->class_name = 'AdminSbpcbuilder';
        $tab->module = $this->name;

        // Padre = Catalogo
        $id_parent = (int) Tab::getIdFromClassName('AdminCatalog');
        if (!$id_parent) {
            $id_parent = 0;
        }
        $tab->id_parent = $id_parent;

        // Posizione in coda
        $tab->position = 99999;

        // Nessuna icona
        $tab->icon = '';

        // Nome per tutte le lingue attive in BO
        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[(int)$lang['id_lang']] = 'PC Builder';
        }

        return (bool) $tab->add();
    }

    /**
     * Rimuove la voce di menu "PC Builder"
     */
    private function uninstallTabs()
    {
        $id_tab = (int) Tab::getIdFromClassName('AdminSbpcbuilder');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            return (bool) $tab->delete();
        }
        return true;
    }

    protected function isValidBackOfficeToken()
    {
        $tokenReq = (string)Tools::getValue('token');
        $tokenCtl = (isset($this->context->controller) && isset($this->context->controller->token)) ? (string)$this->context->controller->token : '';
        $ctrl = (string)Tools::getValue('controller'); if ($ctrl === '') { $ctrl = 'AdminModules'; }
        $tokCurrent = Tools::getAdminTokenLite($ctrl);
        $tokLegacy = Tools::getAdminTokenLite('AdminModules');
        $tokSf = Tools::getAdminTokenLite('AdminModulesSf');

        if ($tokenReq !== '' && (
            $tokenReq === $tokCurrent ||
            $tokenReq === $tokLegacy ||
            $tokenReq === $tokSf ||
            $tokenReq === $tokenCtl
        )) return true;

        if ($tokenCtl !== '' && (
            $tokenCtl === $tokCurrent ||
            $tokenCtl === $tokLegacy ||
            $tokenCtl === $tokSf
        )) return true;

        return false;
    }

    public function install()
    {
        return parent::install()
            && $this->registerHook('displayHeader')
            && $this->installDb()
            && Configuration::updateValue('SBPCB_QUOTE_VALIDITY_DAYS', 15)
            && Configuration::updateValue('SBPCB_ALLOW_OOS_SELECTION', 1)
            && Configuration::updateValue('SBPCB_AUTO_ADVANCE', 1)
            && Configuration::updateValue('SBPCB_COMPONENTS', '[]')
            && Configuration::updateValue('SBPCB_RULES', '[]')
            && Configuration::updateValue('SBPCB_PDF_KEY', Tools::passwdGen(32))
            && Configuration::updateValue('SBPCB_DANEA_VAT_PERC', 22)
            && $this->installTabs(); // <— aggiunta la creazione della Tab
    }

    public function uninstall()
    {
        Configuration::deleteByName('SBPCB_QUOTE_VALIDITY_DAYS');
        Configuration::deleteByName('SBPCB_ALLOW_OOS_SELECTION');
        Configuration::deleteByName('SBPCB_AUTO_ADVANCE');
        Configuration::deleteByName('SBPCB_COMPONENTS');
        Configuration::deleteByName('SBPCB_RULES');
        Configuration::deleteByName('SBPCB_PDF_KEY');
        Configuration::deleteByName('SBPCB_DANEA_VAT_PERC');

        // <— rimozione della Tab
        $this->uninstallTabs();

        return parent::uninstall();
    }

    protected function installDb()
    {
        $prefix = _DB_PREFIX_;
        $engine = _MYSQL_ENGINE_;

        $sql1 = "CREATE TABLE IF NOT EXISTS `".$prefix."sb_pc_builds` (
            `id_build` INT UNSIGNED NOT NULL AUTO_INCREMENT,
            `reference` VARCHAR(64) NOT NULL,
            `custom_name` VARCHAR(255) NOT NULL DEFAULT '',
            `id_customer` INT UNSIGNED NOT NULL DEFAULT 0,
            `customer_name` VARCHAR(255) NOT NULL DEFAULT '',
            `date_add` DATETIME NOT NULL,
            `valid_until` DATETIME NOT NULL,
            `total_excl` DECIMAL(20,6) NOT NULL DEFAULT 0,
            `total_incl` DECIMAL(20,6) NOT NULL DEFAULT 0,
            `currency` VARCHAR(8) NOT NULL DEFAULT '',
            `notes` TEXT NULL,
            PRIMARY KEY(`id_build`), KEY `id_customer` (`id_customer`)
        ) ENGINE=".$engine." DEFAULT CHARSET=utf8mb4;";

        $sql2 = "CREATE TABLE IF NOT EXISTS `".$prefix."sb_pc_build_items` (
            `id_item` INT UNSIGNED NOT NULL AUTO_INCREMENT,
            `id_build` INT UNSIGNED NOT NULL,
            `component_key` VARCHAR(64) NOT NULL,
            `component_label` VARCHAR(255) NOT NULL,
            `id_product` INT UNSIGNED NOT NULL,
            `product_name` VARCHAR(255) NOT NULL,
            `quantity` INT UNSIGNED NOT NULL DEFAULT 1,
            `price_excl` DECIMAL(20,6) NOT NULL,
            `price_incl` DECIMAL(20,6) NOT NULL,
            PRIMARY KEY(`id_item`), INDEX `id_build` (`id_build`),
            CONSTRAINT `fk_sbpcb_build_items_build` FOREIGN KEY (`id_build`) REFERENCES `".$prefix."sb_pc_builds`(`id_build`) ON DELETE CASCADE
        ) ENGINE=".$engine." DEFAULT CHARSET=utf8mb4;";

        return Db::getInstance()->execute($sql1) && Db::getInstance()->execute($sql2);
    }

    public function hookDisplayHeader($params)
    {
        $cssPath = 'modules/'.$this->name.'/views/assets/builder.css';
        $jsPath = 'modules/'.$this->name.'/views/assets/sbpcbuilder.js';

        $this->context->controller->registerStylesheet(
            'sbpcb-builder',
            $cssPath,
            array('media'=>'all','priority'=>50,'version'=>@filemtime(_PS_MODULE_DIR_.$this->name.'/views/assets/builder.css'))
        );

        $this->context->controller->registerJavascript(
            'sbpcb-js',
            $jsPath,
            array('priority'=>50,'attribute'=>'defer','version'=>@filemtime(_PS_MODULE_DIR_.$this->name.'/views/assets/sbpcbuilder.js'))
        );

        $iso = isset($this->context->currency) ? $this->context->currency->iso_code : 'EUR';
        Media::addJsDef(array(
            'SBPCB_ISO' => $iso,
            'SBPCB_AUTO_ADVANCE' => (int)Configuration::get('SBPCB_AUTO_ADVANCE')
        ));
    }

    public function getContent()
    {
        // Delete single
        if (Tools::isSubmit('sbpcb_delete')) {
            if (!$this->isValidBackOfficeToken()) { $this->context->controller->errors[] = $this->l('Invalid token.'); }
            else {
                $id_build = (int)Tools::getValue('id_build');
                if ($id_build > 0) { Db::getInstance()->execute('DELETE FROM `'.pSQL(_DB_PREFIX_).'sb_pc_builds` WHERE `id_build`='.(int)$id_build); }
                Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules').'&configure='.$this->name); exit;
            }
        }

        // Bulk delete
        if (Tools::isSubmit('sbpcb_bulk_delete')) {
            if (!$this->isValidBackOfficeToken()) { $this->context->controller->errors[] = $this->l('Invalid token.'); }
            else {
                $ids = Tools::getValue('ids', array());
                $ids = is_array($ids) ? array_filter(array_map('intval', $ids)) : array();
                if (!empty($ids)) {
                    $in = implode(',', array_map('intval', $ids));
                    Db::getInstance()->execute('DELETE FROM `'.pSQL(_DB_PREFIX_).'sb_pc_builds` WHERE `id_build` IN ('.$in.')');
                }
                Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules').'&configure='.$this->name); exit;
            }
        }

        // Save config
        if (Tools::isSubmit('submitSbpcbConfig')) {
            if (!$this->isValidBackOfficeToken()) { $this->context->controller->errors[] = $this->l('Invalid token.'); }
            else {
                $days = (int)Tools::getValue('SBPCB_QUOTE_VALIDITY_DAYS');
                $allow_oos = (int)(bool)Tools::getValue('SBPCB_ALLOW_OOS_SELECTION');
                $auto_advance = (int)(bool)Tools::getValue('SBPCB_AUTO_ADVANCE');
                $components_raw = (string)Tools::getValue('SBPCB_COMPONENTS');
                $rules_raw = (string)Tools::getValue('SBPCB_RULES');
                $vat_perc = (float)Tools::getValue('SBPCB_DANEA_VAT_PERC'); if ($vat_perc < 0) $vat_perc = 0; if ($vat_perc > 100) $vat_perc = 100;

                $ok_json = true; $rules_ok = true;
                if ($components_raw !== '') { json_decode($components_raw, true); if (json_last_error() !== JSON_ERROR_NONE) { $ok_json=false; $this->context->controller->errors[]=$this->l('Invalid components JSON.'); } }
                if ($rules_raw !== '') { json_decode($rules_raw, true); if (json_last_error() !== JSON_ERROR_NONE) { $rules_ok=false; $this->context->controller->errors[]=$this->l('Invalid compatibility rules JSON.'); } }

                if ($ok_json && $rules_ok) {
                    Configuration::updateValue('SBPCB_QUOTE_VALIDITY_DAYS', $days);
                    Configuration::updateValue('SBPCB_ALLOW_OOS_SELECTION', $allow_oos);
                    Configuration::updateValue('SBPCB_AUTO_ADVANCE', $auto_advance);
                    Configuration::updateValue('SBPCB_COMPONENTS', $components_raw);
                    Configuration::updateValue('SBPCB_RULES', $rules_raw);
                    Configuration::updateValue('SBPCB_DANEA_VAT_PERC', $vat_perc);

                    Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules').'&configure='.$this->name.'&conf=4'); exit;
                }
            }
        }

        // Filters / sorting / pagination
        $ref = trim((string)Tools::getValue('filter_reference', ''));
        $name = trim((string)Tools::getValue('filter_name', ''));
        $cur = trim((string)Tools::getValue('filter_currency', ''));
        $date_from = trim((string)Tools::getValue('filter_date_from', ''));
        $date_to = trim((string)Tools::getValue('filter_date_to', ''));
        $min_total = Tools::getValue('filter_min_total', '');
        $max_total = Tools::getValue('filter_max_total', '');
        $limit = max(1, (int)Tools::getValue('limit', 25));
        $page = max(1, (int)Tools::getValue('page', 1));
        $offset = ($page - 1) * $limit;
        $sort = trim((string)Tools::getValue('sort', 'id_build'));
        $dir = Tools::strtolower(trim((string)Tools::getValue('dir', 'desc')));
        $allowedSort = array('id_build','reference','custom_name','date_add','total_incl','currency');
        if (!in_array($sort, $allowedSort, true)) $sort = 'id_build';
        $dir = ($dir === 'asc') ? 'asc' : 'desc';

        $where = array('1');
        if ($ref !== '') { $where[] = "b.reference LIKE '%".pSQL($ref)."%'";
        }
        if ($name !== '') { $where[] = "b.custom_name LIKE '%".pSQL($name)."%'";
        }
        if ($cur !== '') { $where[] = "b.currency = '".pSQL($cur)."'";
        }
        if ($date_from !== '') { $where[] = "b.date_add >= '".pSQL($date_from)." 00:00:00'";
        }
        if ($date_to !== '') { $where[] = "b.date_add <= '".pSQL($date_to)." 23:59:59'";
        }
        if ($min_total !== '' && is_numeric($min_total)) { $where[] = "b.total_incl >= ".(float)$min_total;
        }
        if ($max_total !== '' && is_numeric($max_total)) { $where[] = "b.total_incl <= ".(float)$max_total;
        }

        $where_sql = implode(' AND ', $where);
        $prefix = _DB_PREFIX_;

        // Distinct currencies for dropdown
        $currencies = Db::getInstance()->executeS('SELECT DISTINCT currency FROM `'.pSQL($prefix).'sb_pc_builds` ORDER BY currency ASC');

        // CSV export of filtered results
        if (Tools::isSubmit('sbpcb_export')) {
            if (!$this->isValidBackOfficeToken()) { die('Invalid token'); }
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename="sbpcbuilder_history_export.csv"');
            $out = fopen('php://output','w');
            fputcsv($out, array('ID','Riferimento','Nome','Data','Totale IVA incl.','Valuta'));
            $rows = Db::getInstance()->executeS('SELECT * FROM `'.pSQL($prefix).'sb_pc_builds` b WHERE '.$where_sql.' ORDER BY b.' . pSQL($sort) . ' ' . strtoupper($dir));
            foreach ($rows as $r) { fputcsv($out, array($r['id_build'],$r['reference'],$r['custom_name'],$r['date_add'],$r['total_incl'],$r['currency'])); }
            fclose($out); exit;
        }

        $count = (int)Db::getInstance()->getValue('SELECT COUNT(*) FROM `'.pSQL($prefix).'sb_pc_builds` b WHERE '.$where_sql);
        $builds = Db::getInstance()->executeS(
            'SELECT * FROM `'.pSQL($prefix).'sb_pc_builds` b ' .
            'WHERE '.$where_sql.' ' .
            'ORDER BY b.' . pSQL($sort) . ' ' . strtoupper($dir) . ' ' .
            'LIMIT '.(int)$offset.', '.(int)$limit
        );

        $key = (string)Configuration::get('SBPCB_PDF_KEY');
        foreach ($builds as &$b) { $b['sig'] = hash_hmac('sha256', (string)$b['id_build'], $key); } unset($b);

        if (!class_exists('HelperTreeCategories') && defined('_PS_ADMIN_DIR_')) { @include_once(_PS_ADMIN_DIR_.'/helpers/tree/HelperTreeCategories.php'); }
        $category_tree_html = '';
        if (class_exists('HelperTreeCategories')) {
            $rootCat = Category::getRootCategory($this->context->language->id);
            $tree = new HelperTreeCategories('sbpcb_category_tree');
            $tree->setRootCategory($rootCat ? (int)$rootCat->id : 1);
            $tree->setUseSearch(true);
            $tree->setUseCheckbox(true);
            $tree->setSelectedCategories(array());
            $category_tree_html = $tree->render();
        }

        $rules_json = Configuration::get('SBPCB_RULES');

        $filters = array(
            'filter_reference' => $ref,
            'filter_name' => $name,
            'filter_currency' => $cur,
            'filter_date_from' => $date_from,
            'filter_date_to' => $date_to,
            'filter_min_total' => $min_total,
            'filter_max_total' => $max_total,
            'limit' => $limit,
            'sort' => $sort,
            'dir' => $dir,
        );

        $total_pages = max(1, (int)ceil($count / $limit));

        $this->context->smarty->assign(array(
            'quote_days' => (int)Configuration::get('SBPCB_QUOTE_VALIDITY_DAYS'),
            'allow_oos' => (int)Configuration::get('SBPCB_ALLOW_OOS_SELECTION'),
            'auto_advance' => (int)Configuration::get('SBPCB_AUTO_ADVANCE'),
            'components_json' => Configuration::get('SBPCB_COMPONENTS'),
            'rules_json' => ($rules_json!==false ? $rules_json : '[]'),
            'pdf_key' => Configuration::get('SBPCB_PDF_KEY'),
            'danea_vat_perc' => (float)Configuration::get('SBPCB_DANEA_VAT_PERC'),
            'builds' => $builds,
            'filters' => $filters,
            'page' => $page,
            'pages' => $total_pages,
            'count' => $count,
            'currencies' => $currencies,
            'module_name' => $this->name,
            'link' => $this->context->link,
            'token' => Tools::getAdminTokenLite('AdminModules'),
            'category_tree_html' => $category_tree_html,
        ));

        return $this->fetch('module:sbpcbuilder/views/templates/admin/config.tpl');
    }
}
?>