(function(){
  function ready(fn){ if(document.readyState!='loading'){ fn(); } else { document.addEventListener('DOMContentLoaded', fn); } }
  ready(function(){
    var form = document.getElementById('sbpcb-builder-form'); if (!form) return;
    var errorsBox = document.getElementById('sbpcb-errors');
    function showErrors(msgs){ if (!errorsBox) return; if (!msgs || !msgs.length) { errorsBox.style.display='none'; errorsBox.innerHTML=''; return; } var html = '<ul style="margin:0; padding-left:18px;">'+ msgs.map(function(m){ return '<li>'+m+'</li>'; }).join('') +'</ul>'; errorsBox.innerHTML = '<strong>Correggi i seguenti errori:</strong> '+html; errorsBox.style.display = 'block'; errorsBox.scrollIntoView({behavior:'smooth', block:'start'}); }

    form.addEventListener('submit', function(){ var nameInput = document.getElementById('sbpcb_custom_name'); if (nameInput) { var hidden = form.querySelector('input[name="sbpcb_custom_name"]'); if (!hidden) { hidden=document.createElement('input'); hidden.type='hidden'; hidden.name='sbpcb_custom_name'; form.appendChild(hidden); } hidden.value = nameInput.value || ''; } serializeBundles(); });

    var components = (window.SBPCB_COMPONENTS && Array.isArray(window.SBPCB_COMPONENTS)) ? window.SBPCB_COMPONENTS : [];
    var compMap = {}; components.forEach(function(c){ if(c && c.key){ compMap[c.key] = c; } });

    document.querySelectorAll('.sbpcb-row').forEach(function(row){ row.addEventListener('click', function(e){ if (e.target.closest('input,button,.sbpcb-qty')) { return; } var section=row.closest('.sbpcb-component'); document.querySelectorAll('.sbpcb-component.open').forEach(function(sec){ if (sec!==section) sec.classList.remove('open'); }); section.classList.toggle('open'); }); });

    var iso=(typeof SBPCB_ISO!=='undefined'&&SBPCB_ISO)?SBPCB_ISO:'EUR'; var currencyFmt=new Intl.NumberFormat('it-IT',{style:'currency',currency:iso,minimumFractionDigits:2}); function fmt(n){ var x=parseFloat(n||0); if(isNaN(x))x=0; return currencyFmt.format(x); }

    document.querySelectorAll('.sbpcb-card').forEach(function(card){ var p=parseFloat(card.getAttribute('data-price-incl')||'0'); var el=card.querySelector('.sbpcb-price'); if(el)el.textContent=fmt(p); });

    function sectionIsMulti(sec){ var key=sec.getAttribute('data-key'); var c=compMap[key]||{}; return !!c.multi; }
    function selectedCards(sec){ return Array.prototype.slice.call(sec.querySelectorAll('.sbpcb-card.selected')); }

    function rowSubtotal(sec){ if(sectionIsMulti(sec)){ var tot=0; selectedCards(sec).forEach(function(card){ var price=parseFloat(card.getAttribute('data-price-incl')||'0'); var qEl=card.querySelector('.sbpcb-card-qty'); var q=parseInt((qEl&&qEl.value)||'0',10); if(isNaN(q)||q<0)q=0; tot+=price*q; }); return tot; } else { var card=sec.querySelector('.sbpcb-card.selected'); if(!card)return 0; var priceIncl=parseFloat(card.getAttribute('data-price-incl')||'0'); var qtyEl=sec.querySelector('.sbpcb-qty'); var qty=parseInt((qtyEl&&qtyEl.value)||'0',10); if(isNaN(qty)||qty<0)qty=0; return priceIncl*qty; } }

    function updateRowUI(sec){ var subtotal=rowSubtotal(sec); var row=sec.querySelector('.sbpcb-row'); if(row){ var el=row.querySelector('.sbpcb-selected-price'); if(el) el.textContent=subtotal>0?fmt(subtotal):'–'; var nameEl=row.querySelector('.sbpcb-selected-name'); var imgEl=row.querySelector('.sbpcb-thumb'); if(sectionIsMulti(sec)){ var cards=selectedCards(sec); var count=cards.length; if(count===1){ var card=cards[0]; var name=card.getAttribute('data-name')||''; var img=card.getAttribute('data-img')||''; if(nameEl) nameEl.textContent = name || 'Nessun prodotto selezionato'; if(imgEl){ if(img){ imgEl.src=img; imgEl.alt=name; imgEl.style.display='inline-block'; } else { imgEl.style.display='none'; imgEl.src=''; imgEl.alt=''; } } } else { if(nameEl) nameEl.textContent = count>0 ? (count+" articoli selezionati") : 'Nessun prodotto selezionato'; if(imgEl){ imgEl.style.display='none'; imgEl.src=''; imgEl.alt=''; } } } }
    }

    function recalc(){ var totalIn=0.0; document.querySelectorAll('.sbpcb-component').forEach(function(sec){ totalIn+=rowSubtotal(sec); }); var elIn=document.getElementById('sbpcb-total-incl'); if(elIn)elIn.textContent=fmt(totalIn); }

    function cardFeatures(card){ try { return JSON.parse(card.getAttribute('data-features')||'{}'); } catch(e){ return {}; } }

    function srcValues(rule){ var sK=rule.if&&rule.if.component, sF=rule.if&&rule.if.feature; if(!sK||!sF) return []; var sec=document.querySelector('.sbpcb-component[data-key="'+sK+'"]'); if(!sec) return []; var vals=[]; var cards=sectionIsMulti(sec)?selectedCards(sec):Array.prototype.slice.call(sec.querySelectorAll('.sbpcb-card.selected')); cards.forEach(function(c){ var v=((cardFeatures(c)[sF]||'')+'').trim().toLowerCase(); if(v) vals.indexOf(v)<0 && vals.push(v); }); return vals; }

    function applyRule(rule){ var srcKey=rule.if&&rule.if.component, srcFeat=rule.if&&rule.if.feature; var dstKey=rule.eq&&rule.eq.component, dstFeat=rule.eq&&rule.eq.feature; var mode=(rule.mode||'filter').toLowerCase(); if(!srcKey||!srcFeat||!dstKey||!dstFeat) return; var secSrc=document.querySelector('.sbpcb-component[data-key="'+srcKey+'"]'); var secDst=document.querySelector('.sbpcb-component[data-key="'+dstKey+'"]'); if(!secSrc||!secDst) return; var sVals = srcValues(rule); var cards=secDst.querySelectorAll('.sbpcb-card'); cards.forEach(function(card){ var f=cardFeatures(card); var val=(f&&typeof f[dstFeat]==='string')?f[dstFeat].trim().toLowerCase():''; var compatible= (sVals.length===0) || (sVals.indexOf(val)>=0); if(mode==='filter'){ card.style.display=compatible?'':'none'; card.classList.toggle('incompatible', !compatible); card.classList.remove('disabled'); } else if(mode==='warn'){ card.style.display=''; card.classList.toggle('incompatible', !compatible); if(!compatible){ card.classList.add('disabled'); } else { card.classList.remove('disabled'); } } else { card.style.display=''; card.classList.toggle('incompatible', !compatible); card.classList.remove('disabled'); } }); var selDst=secDst.querySelectorAll('.sbpcb-card.selected'); Array.prototype.forEach.call(selDst, function(sel){ var fsel=cardFeatures(sel); var vsel=(fsel&&typeof fsel[dstFeat]==='string')?fsel[dstFeat].trim().toLowerCase():''; if(sVals.length>0 && vsel && sVals.indexOf(vsel)<0){ sel.classList.remove('selected'); var qw=sel.querySelector('.sbpcb-card-qtywrap'); if(qw) qw.remove(); var idInput=form.querySelector('input[name="component_'+dstKey+'_id"]'); if(idInput && !sectionIsMulti(secDst)) idInput.value=''; var row=secDst.querySelector('.sbpcb-row'); if(row && !sectionIsMulti(secDst)){ var nameEl=row.querySelector('.sbpcb-selected-name'); if(nameEl) nameEl.textContent='Nessun prodotto selezionato'; var imgEl=row.querySelector('.sbpcb-thumb'); if(imgEl){ imgEl.style.display='none'; imgEl.src=''; imgEl.alt=''; } var qtyInput=row.querySelector('.sbpcb-qty'); if(qtyInput) qtyInput.value=0; var priceEl=row.querySelector('.sbpcb-selected-price'); if(priceEl) priceEl.textContent='–'; } } }); }

    function applyAllRules(){ var rules=(window.SBPCB_RULES&&Array.isArray(window.SBPCB_RULES))?window.SBPCB_RULES:[]; rules.forEach(applyRule); }

    function serializeBundles(){ document.querySelectorAll('.sbpcb-component').forEach(function(sec){ var key=sec.getAttribute('data-key'); var isMulti=sectionIsMulti(sec); var hidden=sec.querySelector('input.sbpcb-bundle[name="component_'+key+'_bundle"]'); if(!hidden) return; if(!isMulti){ hidden.value=''; return; } var data=[]; selectedCards(sec).forEach(function(card){ var id=parseInt(card.getAttribute('data-id'),10)||0; var qEl=card.querySelector('.sbpcb-card-qty'); var qty=parseInt((qEl&&qEl.value)||'0',10); if(id>0 && qty>0) data.push({id:id, qty:qty}); }); hidden.value = JSON.stringify(data); }); }

    document.querySelectorAll('.sbpcb-component').forEach(function(sec){ var isMulti = sectionIsMulti(sec); if(isMulti){ var qRow=sec.querySelector('.sbpcb-qty'); if(qRow){ qRow.style.display='none'; qRow.disabled=true; } var idInput=form.querySelector('input[name="component_'+sec.getAttribute('data-key')+'_id"]'); if(idInput){ idInput.value=''; } } });

    function closeSection(currentSection){ try { if (!currentSection) return; currentSection.classList.remove('open'); } catch(e){} }

    document.querySelectorAll('.sbpcb-card').forEach(function(card){ card.addEventListener('click', function(){ var sec=card.closest('.sbpcb-component'); if(card.classList.contains('disabled')) return; var isMulti=sectionIsMulti(sec); if(isMulti){ var wasSelected = card.classList.contains('selected'); if(wasSelected){ card.classList.remove('selected'); var qw=card.querySelector('.sbpcb-card-qtywrap'); if(qw) qw.remove(); } else { card.classList.add('selected'); if(!card.querySelector('.sbpcb-card-qtywrap')){ var qw=document.createElement('div'); qw.className='sbpcb-card-qtywrap'; qw.innerHTML='<input type="number" class="form-control form-control-sm sbpcb-card-qty" min="1" max="99" value="1" />'; card.appendChild(qw); var qi=qw.querySelector('.sbpcb-card-qty'); qi.addEventListener('click', function(e){e.stopPropagation();}); qi.addEventListener('input', function(){ updateRowUI(sec); recalc(); serializeBundles(); }); qi.addEventListener('change', function(){ updateRowUI(sec); recalc(); serializeBundles(); }); } } updateRowUI(sec); recalc(); applyAllRules(); serializeBundles(); } else { sec.querySelectorAll('.sbpcb-card').forEach(function(c){ c.classList.remove('selected'); var qw=c.querySelector('.sbpcb-card-qtywrap'); if(qw) qw.remove(); }); card.classList.add('selected'); var key=sec.getAttribute('data-key'); var idInput=form.querySelector('input[name="component_'+key+'_id"]'); if(idInput) idInput.value=card.getAttribute('data-id'); var name=card.getAttribute('data-name')||''; var img=card.getAttribute('data-img')||''; var row=sec.querySelector('.sbpcb-row'); if(row){ var nameEl=row.querySelector('.sbpcb-selected-name'); if(nameEl) nameEl.textContent=name||'Nessun prodotto selezionato'; var imgEl=row.querySelector('.sbpcb-thumb'); if(imgEl){ if(img){ imgEl.src=img; imgEl.alt=name; imgEl.style.display='inline-block'; } else { imgEl.style.display='none'; imgEl.src=''; imgEl.alt=''; } } var qtyEl=row.querySelector('.sbpcb-qty'); if(qtyEl&&(parseInt(qtyEl.value||'0',10)<=0)){ qtyEl.value=1; } } sec.classList.remove('sbpcb-error'); var msg=sec.querySelector('.sbpcb-required-msg'); if(msg){ msg.parentNode.removeChild(msg); } updateRowUI(sec); recalc(); applyAllRules(); if (typeof SBPCB_AUTO_ADVANCE==='undefined' || SBPCB_AUTO_ADVANCE) { closeSection(sec); } } }); });

    document.querySelectorAll('.sbpcb-qty').forEach(function(inp){ inp.addEventListener('click',function(e){e.stopPropagation();}); inp.addEventListener('input',function(){ var sec=inp.closest('.sbpcb-component'); updateRowUI(sec); recalc(); }); inp.addEventListener('change',function(){ var sec=inp.closest('.sbpcb-component'); updateRowUI(sec); recalc(); }); });

    document.querySelectorAll('.sbpcb-remove').forEach(function(btn){ btn.addEventListener('click', function(e){ e.preventDefault(); e.stopPropagation(); var sec=btn.closest('.sbpcb-component'); var key=sec.getAttribute('data-key'); var isMulti=sectionIsMulti(sec); if(isMulti){ selectedCards(sec).forEach(function(c){ c.classList.remove('selected'); var qw=c.querySelector('.sbpcb-card-qtywrap'); if(qw) qw.remove(); }); var b=sec.querySelector('input.sbpcb-bundle[name="component_'+key+'_bundle"]'); if(b) b.value=''; var row=sec.querySelector('.sbpcb-row'); if(row){ var nameEl=row.querySelector('.sbpcb-selected-name'); if(nameEl) nameEl.textContent='Nessun prodotto selezionato'; var priceEl=row.querySelector('.sbpcb-selected-price'); if(priceEl) priceEl.textContent='–'; var imgEl=row.querySelector('.sbpcb-thumb'); if(imgEl){ imgEl.style.display='none'; imgEl.src=''; imgEl.alt=''; } } } else { var idInput=form.querySelector('input[name="component_'+key+'_id"]'); if(idInput) idInput.value=''; sec.querySelectorAll('.sbpcb-card.selected').forEach(function(c){ c.classList.remove('selected'); }); var row=sec.querySelector('.sbpcb-row'); if(row){ var nameEl=row.querySelector('.sbpcb-selected-name'); if(nameEl) nameEl.textContent='Nessun prodotto selezionato'; var imgEl=row.querySelector('.sbpcb-thumb'); if(imgEl){ imgEl.style.display='none'; imgEl.src=''; imgEl.alt=''; } var priceEl=row.querySelector('.sbpcb-selected-price'); if(priceEl) priceEl.textContent='–'; var qtyInput=row.querySelector('.sbpcb-qty'); if(qtyInput) qtyInput.value=0; } } recalc(); applyAllRules(); serializeBundles(); }); });

    function validateRequired(){ var errors=[]; document.querySelectorAll('.sbpcb-component').forEach(function(sec){ var required=sec.getAttribute('data-required')==='1'; if(!required) return; var key=sec.getAttribute('data-key'); if(sectionIsMulti(sec)){ var b=sec.querySelector('input.sbpcb-bundle[name="component_'+key+'_bundle"]'); var arr=[]; try{ arr=JSON.parse((b&&b.value)||'[]'); }catch(e){} var ok=Array.isArray(arr) && arr.some(function(it){ return it && it.id>0 && it.qty>0; }); if(!ok){ sec.classList.add('sbpcb-error'); var title=sec.querySelector('.sbpcb-title'); if(title && !sec.querySelector('.sbpcb-required-msg')){ var small=document.createElement('div'); small.className='sbpcb-required-msg text-danger mt-1'; small.textContent='Questo componente è obbligatorio.'; title.parentNode.appendChild(small); } var label=(title?title.textContent.trim():key); errors.push('Seleziona "'+label+'" (almeno 1 articolo con quantità > 0)'); } } else { var idInput=form.querySelector('input[name="component_'+key+'_id"]'); var qtyEl=sec.querySelector('.sbpcb-qty'); var qty=parseInt((qtyEl&&qtyEl.value)||'0',10); var valid=idInput&&idInput.value&&parseInt(idInput.value,10)>0&&qty>0; if(!valid){ sec.classList.add('sbpcb-error'); var title=sec.querySelector('.sbpcb-title'); if(title && !sec.querySelector('.sbpcb-required-msg')){ var small=document.createElement('div'); small.className='sbpcb-required-msg text-danger mt-1'; small.textContent='Questo componente è obbligatorio.'; title.parentNode.appendChild(small); } var label=(title?title.textContent.trim():key); errors.push('Seleziona "'+label+'" con quantità > 0'); } } }); showErrors(errors); return errors.length===0; }

    function validateCompatibility(){ var errs=[]; var rules=(window.SBPCB_RULES&&Array.isArray(window.SBPCB_RULES))?window.SBPCB_RULES:[]; rules.forEach(function(rule){ var mode=(rule.mode||'filter').toLowerCase(); if(mode!=='block') return; var sK=rule.if&&rule.if.component, sF=rule.if&&rule.if.feature; var tK=rule.eq&&rule.eq.component, tF=rule.eq&&rule.eq.feature; if(!sK||!sF||!tK||!tF) return; var secS=document.querySelector('.sbpcb-component[data-key="'+sK+'"]'); var secT=document.querySelector('.sbpcb-component[data-key="'+tK+'"]'); if(!secS||!secT) return; var cardsS = sectionIsMulti(secS)?selectedCards(secS):Array.prototype.slice.call(secS.querySelectorAll('.sbpcb-card.selected')); var cardsT = sectionIsMulti(secT)?selectedCards(secT):Array.prototype.slice.call(secT.querySelectorAll('.sbpcb-card.selected')); if(cardsS.length===0 || cardsT.length===0) return; cardsS.forEach(function(cs){ var sv=((cardFeatures(cs)[sF]||'')+'').trim().toLowerCase(); cardsT.forEach(function(ct){ var tv=((cardFeatures(ct)[tF]||'')+'').trim().toLowerCase(); if(sv&&tv&&sv!==tv){ errs.push('Incompatibilità tra '+sK+' ('+sF+') e '+tK+' ('+tF+').'); } }); }); }); if(errs.length){ showErrors(errs); return false; } return true; }

    form.addEventListener('submit', function(e){ serializeBundles(); if (!validateRequired() || !validateCompatibility()){ e.preventDefault(); e.stopPropagation(); return false; } });

    recalc(); applyAllRules();
  });
})();
