<div class="panel">
  <h3>{l s='Spiderbyte PC Builder - Settings' mod='sbpcbuilder'}</h3>
  <form id="sbpcb-config-form" method="post" action="{$link->getAdminLink('AdminModules')}&configure={$module_name}">
    <div class="form-group">
      <label for="sbpcb_days">{l s='Quote validity (days)' mod='sbpcbuilder'}</label>
      <input type="number" id="sbpcb_days" name="SBPCB_QUOTE_VALIDITY_DAYS" value="{$quote_days}" />
    </div>
    <div class="form-group">
      <label for="sbpcb_oos">{l s='Allow selection of out-of-stock' mod='sbpcbuilder'}</label>
      <input type="checkbox" id="sbpcb_oos" name="SBPCB_ALLOW_OOS_SELECTION" value="1" {if $allow_oos}checked{/if} />
    </div>
    <div class="form-group">
      <label for="sbpcb_auto_advance">{l s='Auto-chiudi la griglia dopo la selezione (solo sezioni singole)' mod='sbpcbuilder'}</label>
      <input type="checkbox" id="sbpcb_auto_advance" name="SBPCB_AUTO_ADVANCE" value="1" {if $auto_advance}checked{/if} />
    </div>
    <div class="form-group">
      <label for="sbpcb_danea_vat">{l s='Aliquota IVA predefinita per XML Danea (%)' mod='sbpcbuilder'}</label>
      <input type="number" step="0.1" id="sbpcb_danea_vat" name="SBPCB_DANEA_VAT_PERC" value="{$danea_vat_perc}" />
    </div>
    <hr/>
    <h4>{l s='Componenti (categorie, obbligatorietà, multi e ordinamento)' mod='sbpcbuilder'}</h4>
    <p class="help-block">{l s='Aggiungi voci (CPU, GPU, SSD...). Per ogni voce seleziona categorie, obbligatorietà, multi-selezione, ordinamento e limite.' mod='sbpcbuilder'}</p>
    <table class="table" id="sbpcb-components-table">
      <thead>
        <tr>
          <th style="width:16%">{l s='Etichetta' mod='sbpcbuilder'}</th>
          <th style="width:14%">{l s='Chiave' mod='sbpcbuilder'}</th>
          <th style="width:26%">{l s='Categorie' mod='sbpcbuilder'}</th>
          <th style="width:8%" title="{l s='Obbligatorio' mod='sbpcbuilder'}">{l s='Obb.' mod='sbpcbuilder'}</th>
          <th style="width:10%" title="{l s='Consenti più articoli' mod='sbpcbuilder'}">{l s='Multi' mod='sbpcbuilder'}</th>
          <th style="width:16%">{l s='Ordina per' mod='sbpcbuilder'}</th>
          <th style="width:6%">{l s='Limite' mod='sbpcbuilder'}</th>
          <th style="width:4%"></th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
    <button type="button" class="btn btn-default" id="sbpcb-add-row" onclick="window.SBPCB_addRow && window.SBPCB_addRow();">+ {l s='Aggiungi voce' mod='sbpcbuilder'}</button>
    <textarea id="sbpcb_components" name="SBPCB_COMPONENTS" rows="8" cols="80" style="display:none;">{$components_json|escape:'htmlall':'UTF-8'}</textarea>

    <hr/>
    <h4>{l s='Regole di compatibilità' mod='sbpcbuilder'}</h4>
    <p class="help-block">{l s='Definisci regole JSON. Esempio: se CPU.Socket = MB.Socket → mostra solo MB con lo stesso Socket.' mod='sbpcbuilder'}</p>
    {literal}
    <pre style="font-size:12px; background:#f8f9fa; padding:8px; border:1px solid #ddd;">[
  {"if": {"component":"cpu","feature":"Socket"},
   "eq": {"component":"motherboard","feature":"Socket"},
   "mode": "filter"}
]</pre>
    {/literal}
    <textarea id="sbpcb_rules" name="SBPCB_RULES" rows="8" class="form-control" style="font-family:monospace;">{$rules_json|escape:'htmlall':'UTF-8'}</textarea>

    <input type="hidden" name="token" value="{$token}" />
    <br/><br/>
    <button type="submit" name="submitSbpcbConfig" class="btn btn-primary">{l s='Save settings' mod='sbpcbuilder'}</button>
  </form>
</div>

<div class="panel">
  <h3>{l s='Storico preventivi' mod='sbpcbuilder'}</h3>

  <form method="get" action="{$link->getAdminLink('AdminModules')|escape:'htmlall':'UTF-8'}">
    <input type="hidden" name="configure" value="{$module_name|escape:'htmlall':'UTF-8'}" />
    <div class="row">
      <div class="col-md-2">
        <label>{l s='Riferimento' mod='sbpcbuilder'}</label>
        <input type="text" class="form-control" name="filter_reference" value="{$filters.filter_reference|escape:'htmlall':'UTF-8'}" />
      </div>
      <div class="col-md-3">
        <label>{l s='Nome preventivo' mod='sbpcbuilder'}</label>
        <input type="text" class="form-control" name="filter_name" value="{$filters.filter_name|escape:'htmlall':'UTF-8'}" />
      </div>
      <div class="col-md-2">
        <label>{l s='Valuta' mod='sbpcbuilder'}</label>
        <select class="form-control" name="filter_currency">
          <option value="">{l s='(Tutte)' mod='sbpcbuilder'}</option>
          {foreach from=$currencies item=c}
            <option value="{$c.currency|escape:'htmlall':'UTF-8'}" {if $filters.filter_currency==$c.currency}selected{/if}>{$c.currency|escape:'htmlall':'UTF-8'}</option>
          {/foreach}
        </select>
      </div>
      <div class="col-md-2">
        <label>{l s='Data da' mod='sbpcbuilder'}</label>
        <input type="date" class="form-control" name="filter_date_from" value="{$filters.filter_date_from|escape:'htmlall':'UTF-8'}" />
      </div>
      <div class="col-md-2">
        <label>{l s='Data a' mod='sbpcbuilder'}</label>
        <input type="date" class="form-control" name="filter_date_to" value="{$filters.filter_date_to|escape:'htmlall':'UTF-8'}" />
      </div>
      <div class="col-md-1">
        <label>{l s='Per pagina' mod='sbpcbuilder'}</label>
        <input type="number" class="form-control" name="limit" value="{$filters.limit|intval}" min="1" max="200" />
      </div>
    </div>
    <div class="row" style="margin-top:8px;">
      <div class="col-md-2">
        <label>{l s='Totale min (IVA inc.)' mod='sbpcbuilder'}</label>
        <input type="number" step="0.01" class="form-control" name="filter_min_total" value="{$filters.filter_min_total|escape:'htmlall':'UTF-8'}" />
      </div>
      <div class="col-md-2">
        <label>{l s='Totale max (IVA inc.)' mod='sbpcbuilder'}</label>
        <input type="number" step="0.01" class="form-control" name="filter_max_total" value="{$filters.filter_max_total|escape:'htmlall':'UTF-8'}" />
      </div>
      <div class="col-md-4" style="display:flex; gap:8px; align-items:flex-end;">
        <button type="submit" class="btn btn-primary">{l s='Filtra' mod='sbpcbuilder'}</button>
        <a class="btn btn-default" href="{$link->getAdminLink('AdminModules')|escape:'htmlall':'UTF-8'}&configure={$module_name|escape:'htmlall':'UTF-8'}">{l s='Azzera filtri' mod='sbpcbuilder'}</a>
        <a class="btn btn-outline-secondary" href="{$link->getAdminLink('AdminModules')|escape:'htmlall':'UTF-8'}&configure={$module_name|escape:'htmlall':'UTF-8'}&sbpcb_export=1&filter_reference={$filters.filter_reference|escape:'url'}&filter_name={$filters.filter_name|escape:'url'}&filter_currency={$filters.filter_currency|escape:'url'}&filter_date_from={$filters.filter_date_from|escape:'url'}&filter_date_to={$filters.filter_date_to|escape:'url'}&filter_min_total={$filters.filter_min_total|escape:'url'}&filter_max_total={$filters.filter_max_total|escape:'url'}&sort={$filters.sort|escape:'url'}&dir={$filters.dir|escape:'url'}&token={$token|escape:'url'}">{l s='Esporta CSV' mod='sbpcbuilder'}</a>
      </div>
      <div class="col-md-4 text-right" style="display:flex; align-items:flex-end; justify-content:flex-end;">
        <div><strong>{l s='Totale risultati:' mod='sbpcbuilder'} {$count|intval}</strong></div>
      </div>
    </div>
  </form>

  <form method="post" action="{$link->getAdminLink('AdminModules')|escape:'htmlall':'UTF-8'}&configure={$module_name|escape:'htmlall':'UTF-8'}" id="sbpcb-bulk-form" onsubmit="return confirm('{l s='Eliminare i preventivi selezionati?' mod='sbpcbuilder'}');">
    <input type="hidden" name="token" value="{$token}" />
    <input type="hidden" name="sbpcb_bulk_delete" value="1" />

    {assign var=base value=$link->getAdminLink('AdminModules')}
    {assign var=q value="&configure=`$module_name`&filter_reference=`$filters.filter_reference|escape:'url'`&filter_name=`$filters.filter_name|escape:'url'`&filter_currency=`$filters.filter_currency|escape:'url'`&filter_date_from=`$filters.filter_date_from|escape:'url'`&filter_date_to=`$filters.filter_date_to|escape:'url'`&filter_min_total=`$filters.filter_min_total|escape:'url'`&filter_max_total=`$filters.filter_max_total|escape:'url'`&limit=`$filters.limit|escape:'url'`"}

    <table class="table">
      <thead>
        <tr>
          <th style="width:32px;"><input type="checkbox" id="sbpcb-checkall" /></th>
          {assign var=nd_id value=($filters.sort=='id_build' && $filters.dir=='asc') ? 'desc' : 'asc'}
          <th><a href="{$base}{$q}&sort=id_build&dir={$nd_id}">ID</a></th>
          {assign var=nd_ref value=($filters.sort=='reference' && $filters.dir=='asc') ? 'desc' : 'asc'}
          <th><a href="{$base}{$q}&sort=reference&dir={$nd_ref}">{l s='Riferimento' mod='sbpcbuilder'}</a></th>
          {assign var=nd_name value=($filters.sort=='custom_name' && $filters.dir=='asc') ? 'desc' : 'asc'}
          <th><a href="{$base}{$q}&sort=custom_name&dir={$nd_name}">{l s='Nome' mod='sbpcbuilder'}</a></th>
          {assign var=nd_date value=($filters.sort=='date_add' && $filters.dir=='asc') ? 'desc' : 'asc'}
          <th><a href="{$base}{$q}&sort=date_add&dir={$nd_date}">{l s='Data' mod='sbpcbuilder'}</a></th>
          {assign var=nd_tot value=($filters.sort=='total_incl' && $filters.dir=='asc') ? 'desc' : 'asc'}
          <th><a href="{$base}{$q}&sort=total_incl&dir={$nd_tot}">{l s='Totale (IVA incl.)' mod='sbpcbuilder'}</a></th>
          {assign var=nd_cur value=($filters.sort=='currency' && $filters.dir=='asc') ? 'desc' : 'asc'}
          <th><a href="{$base}{$q}&sort=currency&dir={$nd_cur}">{l s='Valuta' mod='sbpcbuilder'}</a></th>
          <th>{l s='Azioni' mod='sbpcbuilder'}</th>
        </tr>
      </thead>
      <tbody>
        {foreach from=$builds item=b}
          {assign var=pdfUrl value=$link->getModuleLink($module_name,'quotepdf', ['id_build'=>$b.id_build, 'sig'=>$b.sig], true)}
          {assign var=pdfUrlCodes value=$link->getModuleLink($module_name,'quotepdfcodes', ['id_build'=>$b.id_build, 'sig'=>$b.sig], true)}
          {assign var=xmlUrl value=$link->getModuleLink($module_name,'daneaxml', ['id_build'=>$b.id_build, 'sig'=>$b.sig], true)}
          <tr>
            <td><input type="checkbox" name="ids[]" value="{$b.id_build|intval}" class="sbpcb-rowcheck" /></td>
            <td>{$b.id_build|intval}</td>
            <td>{$b.reference|escape:'htmlall':'UTF-8'}</td>
            <td>{$b.custom_name|default:''|escape:'htmlall':'UTF-8'}</td>
            <td>{$b.date_add|escape:'htmlall':'UTF-8'}</td>
            <td>€{sprintf("%.2f", $b.total_incl)}</td>
            <td>{$b.currency|escape:'htmlall':'UTF-8'}</td>
            <td>
              <a class="btn btn-default" href="{$pdfUrl|escape:'htmlall':'UTF-8'}" target="_blank">{l s='Ristampa PDF' mod='sbpcbuilder'}</a>
              <a class="btn btn-default" href="{$pdfUrlCodes|escape:'htmlall':'UTF-8'}" target="_blank">{l s='Stampa con codici' mod='sbpcbuilder'}</a>
              <a class="btn btn-default" href="{$xmlUrl|escape:'htmlall':'UTF-8'}" target="_blank">{l s='XML Danea' mod='sbpcbuilder'}</a>
              <form method="post" action="{$link->getAdminLink('AdminModules')|escape:'htmlall':'UTF-8'}&configure={$module_name|escape:'htmlall':'UTF-8'}" style="display:inline-block">
                <input type="hidden" name="id_build" value="{$b.id_build|intval}" />
                <input type="hidden" name="token" value="{$token}" />
                <button class="btn btn-danger" name="sbpcb_delete" value="1" onclick="return confirm('{l s='Eliminare il preventivo?' mod='sbpcbuilder'}');">{l s='Elimina' mod='sbpcbuilder'}</button>
              </form>
            </td>
          </tr>
        {/foreach}
        {if !count($builds)}
          <tr><td colspan="9" class="text-center text-muted">{l s='Nessun risultato' mod='sbpcbuilder'}</td></tr>
        {/if}
      </tbody>
    </table>

    <div class="row">
      <div class="col-md-6">
        <button type="submit" class="btn btn-danger" {if !count($builds)}disabled{/if}>{l s='Elimina selezionati' mod='sbpcbuilder'}</button>
      </div>
      <div class="col-md-6 text-right">
        {assign var=q2 value="$q&sort=`$filters.sort|escape:'url'`&dir=`$filters.dir|escape:'url'`"}
        <div class="pagination">
          {if $page > 1}
            <a class="btn btn-default" href="{$base|escape:'htmlall':'UTF-8'}{$q2|escape:'htmlall':'UTF-8'}&page={$page-1}">&laquo; {l s='Prec.' mod='sbpcbuilder'}</a>
          {/if}
          {section name=p loop=$pages+1 start=1}
            {if $smarty.section.p.index == $page}
              <span class="btn btn-primary disabled">{$smarty.section.p.index}</span>
            {else}
              <a class="btn btn-default" href="{$base|escape:'htmlall':'UTF-8'}{$q2|escape:'htmlall':'UTF-8'}&page={$smarty.section.p.index}">{$smarty.section.p.index}</a>
            {/if}
          {/section}
          {if $page < $pages}
            <a class="btn btn-default" href="{$base|escape:'htmlall':'UTF-8'}{$q2|escape:'htmlall':'UTF-8'}&page={$page+1}">{l s='Succ.' mod='sbpcbuilder'} &raquo;</a>
          {/if}
        </div>
      </div>
    </div>
  </form>
</div>

<div class="modal fade" id="sbpcbCategoryModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{l s='Seleziona categorie' mod='sbpcbuilder'}</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
      </div>
      <div class="modal-body">{$category_tree_html nofilter}</div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">{l s='Annulla' mod='sbpcbuilder'}</button>
        <button type="button" class="btn btn-primary" id="sbpcbCategoryApply">{l s='Applica' mod='sbpcbuilder'}</button>
      </div>
    </div>
  </div>
</div>

{literal}
<script>
(function(init){
  if (typeof window.jQuery !== 'undefined') { jQuery(function(){ init(); }); }
  else if (document.readyState !== 'loading') { init(); }
  else { document.addEventListener('DOMContentLoaded', init); }
})(function init(){
  // Components builder UI
  var table = document.getElementById('sbpcb-components-table'); if (!table) return;
  var tbody = table.querySelector('tbody');
  var addBtn = document.getElementById('sbpcb-add-row');
  var jsonTextarea = document.getElementById('sbpcb_components');
  var form = document.getElementById('sbpcb-config-form');
  var currentRow = null;

  function makeRow(data){
    data = data || {sort_by:'price', sort_dir:'asc', limit:24, required:false, multi:false};
    var tr = document.createElement('tr');
    tr.innerHTML = ''
      + '<td><input type="text" class="form-control" name="label" value="'+(data.label||'')+'" placeholder="CPU, GPU, SSD..." /></td>'
      + '<td><input type="text" class="form-control" name="key" value="'+(data.key||'')+'" placeholder="cpu, gpu, ssd" /></td>'
      + '<td>'
      +   '<input type="text" class="form-control" name="categories" value="'+((data.category_ids && data.category_ids.join ? data.category_ids.join(',') : (data.categories||'')))+'" placeholder="es. 12,34,56" />'
      +   '<br/><button type="button" class="btn btn-default sbpcb-pickcats">Scegli categorie</button>'
      + '</td>'
      + '<td style="text-align:center"><input type="checkbox" name="required" '+(data.required?'checked':'')+' /></td>'
      + '<td style="text-align:center"><input type="checkbox" name="multi" '+(data.multi?'checked':'')+' /></td>'
      + '<td>'
      +   '<div class="input-group">'
      +     '<select name="sort_by" class="form-control">'
      +       '<option value="price" '+(data.sort_by==='price'?'selected':'')+'>Prezzo</option>'
      +       '<option value="name" '+(data.sort_by==='name'?'selected':'')+'>Nome</option>'
      +     '</select>'
      +     '<select name="sort_dir" class="form-control" style="max-width:90px">'
      +       '<option value="asc" '+(data.sort_dir==='asc'?'selected':'')+'>ASC</option>'
      +       '<option value="desc" '+(data.sort_dir==='desc'?'selected':'')+'>DESC</option>'
      +     '</select>'
      +   '</div>'
      + '</td>'
      + '<td><input type="number" class="form-control" name="limit" min="1" max="200" value="'+(data.limit||24)+'" /></td>'
      + '<td><button type="button" class="btn btn-danger sbpcb-del">&times;</button></td>';

    var del = tr.querySelector('.sbpcb-del'); if (del) del.addEventListener('click', function(){ if (tr.parentNode) tr.parentNode.removeChild(tr); });
    var pick = tr.querySelector('.sbpcb-pickcats'); if (pick) pick.addEventListener('click', function(){ openModalForRow(tr); });
    return tr;
  }

  function loadFromJson(){ var arr=[]; try { arr = JSON.parse(jsonTextarea.value||'[]'); } catch(e){} tbody.innerHTML=''; (arr||[]).forEach(function(c){ tbody.appendChild(makeRow(c)); }); }
  function toJson(){
    var rows = tbody.querySelectorAll('tr'); var out = [];
    rows.forEach(function(tr){
      var label = tr.querySelector('input[name=\"label\"]').value.trim();
      var key = tr.querySelector('input[name=\"key\"]').value.trim();
      var cats = tr.querySelector('input[name=\"categories\"]').value.trim();
      var required = tr.querySelector('input[name=\"required\"]').checked;
      var multi = tr.querySelector('input[name=\"multi\"]').checked;
      var sort_by = tr.querySelector('select[name=\"sort_by\"]').value;
      var sort_dir = tr.querySelector('select[name=\"sort_dir\"]').value;
      var limit = parseInt(tr.querySelector('input[name=\"limit\"]').value||'24',10);
      if (!label || !key) return;
      var category_ids = cats ? cats.split(',').map(function(x){ return parseInt(x,10); }).filter(function(n){ return !isNaN(n) && n>0; }) : [];
      out.push({ label: label, key: key, category_ids: category_ids, required: !!required, multi: !!multi, sort_by: sort_by, sort_dir: sort_dir, limit: limit });
    });
    jsonTextarea.value = JSON.stringify(out);
  }

  function showModal(){ var m=document.getElementById('sbpcbCategoryModal'); if(!m) return; if (window.jQuery && jQuery.fn && jQuery.fn.modal) { jQuery(m).modal('show'); } else { m.style.display='block'; m.classList.add('open'); } }
  function hideModal(){ var m=document.getElementById('sbpcbCategoryModal'); if(!m) return; if (window.jQuery && jQuery.fn && jQuery.fn.modal) { jQuery(m).modal('hide'); } else { m.style.display='none'; m.classList.remove('open'); } }
  function setCheckboxes(ids){ var boxes = document.querySelectorAll('#sbpcbCategoryModal input[type=\"checkbox\"]'); if (!boxes.length) return; boxes.forEach(function(cb){ cb.checked = false; }); (ids||[]).forEach(function(id){ var cb = document.querySelector('#sbpcbCategoryModal input[type=\"checkbox\"][value=\"'+id+'\"]'); if (cb) cb.checked = true; }); }
  function openModalForRow(tr){ currentRow = tr; var catsField = tr.querySelector('input[name=\"categories\"]'); var ids = []; if (catsField && catsField.value){ ids = catsField.value.split(',').map(function(x){ var n=parseInt(x,10); return isNaN(n)?null:n; }).filter(function(n){ return n>0; }); } setCheckboxes(ids); showModal(); }

  var applyBtn = document.getElementById('sbpcbCategoryApply'); if (applyBtn) applyBtn.addEventListener('click', function(){ if (!currentRow) return; var selected = []; document.querySelectorAll('#sbpcbCategoryModal input[type=\"checkbox\"]:checked').forEach(function(cb){ var v=parseInt(cb.value,10); if(!isNaN(v)&&v>0) selected.push(v); }); var catsField = currentRow.querySelector('input[name=\"categories\"]'); if (catsField) { catsField.value = selected.join(','); catsField.dispatchEvent(new Event('change')); } hideModal(); });

  function addRow(){ tbody.appendChild(makeRow({})); }
  if (addBtn) addBtn.addEventListener('click', addRow); window.SBPCB_addRow = addRow;

  if (form) form.addEventListener('submit', function(){ toJson(); });
  loadFromJson();

  // History check-all
  var all = document.getElementById('sbpcb-checkall');
  var rows = document.querySelectorAll('.sbpcb-rowcheck');
  if (all) { all.addEventListener('change', function(){ rows.forEach(function(cb){ cb.checked = all.checked; }); }); }
});
</script>
{/literal}
