{extends file='page.tpl'}
{block name='content'}
<div id="sbpcb-builder" class="sbpcb">
  <h1>{l s='PC Builder' mod='sbpcbuilder'}</h1>
  <div id="sbpcb-errors" class="alert alert-danger" style="display:none;"></div>
  <div class="card mb-3"><div class="card-body">
    <label for="sbpcb_custom_name" class="form-label">{l s='Nome preventivo' mod='sbpcbuilder'}</label>
    <input id="sbpcb_custom_name" type="text" class="form-control" placeholder="{l s='Es. PC Ufficio Mario' mod='sbpcbuilder'}" />
  </div></div>
  <form method="post" action="{$link->getModuleLink('sbpcbuilder','quote',[],true)}" id="sbpcb-builder-form" target="_blank">
    {foreach from=$components item=comp}
      <section class="sbpcb-component card" data-key="{$comp.key}" data-required="{if $comp.required}1{else}0{/if}">
        <div class="card-body">
          <div class="row align-items-center sbpcb-row">
            <div class="col-12 col-md-4"><h2 class="sbpcb-title mb-0">{$comp.label}</h2></div>
            <div class="col-7 col-md-4 d-flex align-items-center gap-2">
              <img class="sbpcb-thumb" src="" alt="" width="56" height="56" style="display:none;" />
              <div class="sbpcb-selected-name text-muted">{l s='Nessun prodotto selezionato' mod='sbpcbuilder'}</div>
            </div>
            <div class="col-3 col-md-2 text-end"><span class="sbpcb-selected-price">–</span></div>
            <div class="col-2 col-md-2 d-flex justify-content-end align-items-center gap-2">
              <input type="number" class="form-control form-control-sm sbpcb-qty" name="component_{$comp.key}_qty" value="1" min="0" max="99" inputmode="numeric" />
              <button type="button" class="btn btn-outline-danger btn-sm sbpcb-remove" data-key="{$comp.key}">×</button>
            </div>
          </div>
          <input type="hidden" name="component_{$comp.key}_id" value="" />
          <input type="hidden" class="sbpcb-bundle" name="component_{$comp.key}_bundle" value="" />
          <div class="sbpcb-products mt-3">
            {assign var=k value=$comp.key}
            {foreach from=$componentProducts[$k] item=p}
              {assign var=featJson value=$p.features|@json_encode}
              <div class="sbpcb-card" data-id="{$p.id_product}" data-price-excl="{$p.price_excl}" data-price-incl="{$p.price_incl}" data-img="{$p.image|escape:'htmlall':'UTF-8'}" data-name="{$p.name|escape:'htmlall':'UTF-8'}" data-features="{$featJson|escape:'htmlall':'UTF-8'}">
                {if $p.image}<img src="{$p.image}" alt="{$p.name}" width="80" height="80" />{/if}
                <div class="sbpcb-name">{$p.name}</div>
                <div class="sbpcb-price">{$p.price_incl}</div>
                <div class="sbpcb-availability {if $p.quantity_available>0}ok{else}ko{/if}">
                  {if $p.quantity_available>0}{l s='Disponibile' mod='sbpcbuilder'}{else}{l s='Non disponibile' mod='sbpcbuilder'}{/if}
                </div>
              </div>
            {/foreach}
          </div>
        </div>
      </section>
    {/foreach}
    <div class="sbpcb-total card mt-2 p-2">
      <div>{l s='Totale IVA inclusa' mod='sbpcbuilder'}: <span id="sbpcb-total-incl">€ 0,00</span></div>
    </div>
    <div class="d-flex gap-2 mt-2"><button type="submit" name="sbpcb_generate" class="btn btn-primary">{l s='Genera PDF del preventivo' mod='sbpcbuilder'}</button></div>
  </form>
</div>
<script>
  window.SBPCB_RULES = {$rules|@json_encode nofilter};
  window.SBPCB_COMPONENTS = {$components|@json_encode nofilter};
</script>
{/block}
