<style>
  body { font-family: DejaVu Sans, sans-serif; font-size: 10px; margin: 6mm; }
  table { width: 100%; border-collapse: collapse; }
  .grid th, .grid td { border-bottom: 1px solid #ccc; }
  h2, p { margin: 0 0 4px 0; }
  .img { width: 18px; height: 18px; object-fit: contain; }
</style>
<div class="quote">
  <h2>{l s='Preventivo PC (con codici):' mod='sbpcbuilder'} {$sbpcb_build.reference}</h2>
  <p>{l s='Nome:' mod='sbpcbuilder'} {$sbpcb_build.custom_name}</p>
  <p>
    {l s='Data:' mod='sbpcbuilder'} {$sbpcb_build.date_add|date_format:"%d/%m/%Y"}
    &nbsp; {l s='Valido fino al:' mod='sbpcbuilder'} {$sbpcb_build.valid_until|date_format:"%d/%m/%Y"}
  </p>
  <table class="grid" cellpadding="4" cellspacing="0">
    <thead>
      <tr height="20">
        <th style="width:12%; line-height:20px;">{l s='Immagine' mod='sbpcbuilder'}</th>
        <th style="width:45%; line-height:20px;">{l s='Prodotto' mod='sbpcbuilder'}</th>
        <th style="width:15%; line-height:20px;">{l s='Codice' mod='sbpcbuilder'}</th>
        <th style="width:8%; line-height:20px;" align="right">{l s='Q.tà' mod='sbpcbuilder'}</th>
        <th style="width:20%; line-height:20px;" align="right">{l s='Subtotale (IVA incl.)' mod='sbpcbuilder'}</th>
      </tr>
    </thead>
    <tbody>
      {foreach from=$sbpcb_build.items item=row}
        {assign var=_qty value=$row.quantity|default:$row.qty}
        {assign var=_sub value=$row.price_incl*$_qty}
        <tr height="20">
          <td style="width:12%; line-height:20px;">{if $row.image_link}<img class="img" src="{$row.image_link}" alt="{$row.product_name}" />{/if}</td>
          <td style="width:45%; line-height:20px;">{$row.product_name}</td>
          <td style="width:15%; line-height:20px;">{$row.reference|escape:'htmlall':'UTF-8'}</td>
          <td style="width:8%; line-height:20px;" align="right">{$_qty}</td>
          <td style="width:20%; line-height:20px;" align="right">€{sprintf("%.2f", $_sub)}</td>
        </tr>
      {/foreach}
    </tbody>
  </table>
  <table width="100%" border="0" cellpadding="0" cellspacing="0"><tr height="4"><td>&nbsp;</td></tr></table>
  <div style="text-align:right;"><strong>{l s='Totale IVA inclusa:' mod='sbpcbuilder'} €{sprintf("%.2f", $sbpcb_build.total_incl)}</strong></div>
</div>
