<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

class spider_backtotop extends Module
{
    public function __construct()
    {
        $this->name = 'spider_backtotop';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'Spiderbyte';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = array('min' => '8.0.0', 'max' => _PS_VERSION_);
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('Back to Top');
        $this->description = $this->l('Aggiunge un pulsante per tornare in cima alla pagina.');
    }

    public function install()
    {
        return parent::install()
            && $this->registerHook('displayFooter')
            && $this->registerHook('header');
    }

    public function uninstall()
    {
        return parent::uninstall();
    }

    public function hookHeader($params)
    {
        $this->context->controller->registerStylesheet(
            'spider_backtotop-css',
            'modules/spider_backtotop/views/css/backtotop.css',
            array('server' => 'local', 'priority' => 150)
        );
        $this->context->controller->registerJavascript(
            'spider_backtotop-js',
            'modules/spider_backtotop/views/js/backtotop.js',
            array('server' => 'local', 'priority' => 150, 'position' => 'bottom')
        );
    }

    public function hookDisplayFooter($params)
    {
        return $this->fetch('module:spider_backtotop/views/templates/hook/backtotop.tpl');
    }
}
