<?php
if (!defined('_PS_VERSION_')) {
    exit;
}
class Spider_Breadcrumb_Control extends Module
{
    public function __construct()
    {
        $this->name = 'spider_breadcrumb_control';
        $this->tab = 'front_office_features';
        $this->version = '1.1.0';
        $this->author = 'Spiderbyte';
        $this->need_instance = 0;
        $this->bootstrap = true;
        $this->ps_versions_compliancy = ['min' => '1.7.0.0', 'max' => _PS_VERSION_];
        parent::__construct();
        $this->displayName = $this->l('Breadcrumb & CMS Title Control');
        $this->description = $this->l('Hides breadcrumb outside shop pages and hides H1 titles on CMS pages.');
    }
    public function install()
    {
        return parent::install() && $this->registerHook('header');
    }
    public function uninstall()
    {
        return parent::uninstall();
    }
    public function hookHeader($params)
    {
        // Register front stylesheet (PS 1.7/8 compatible)
        $this->context->controller->registerStylesheet(
            $this->name . '-front',
            'modules/' . $this->name . '/views/css/front.css',
            [
                'media' => 'all',
                'priority' => 50,
            ]
        );
    }
}