
<?php
if (!defined('_PS_VERSION_')) exit;
class Spider_Category_Menu extends Module{
  public function __construct(){ $this->name='spider_category_menu';$this->tab='front_office_features';$this->version='1.0.6';$this->bootstrap=true; parent::__construct();$this->displayName=$this->l('Spider - Category Menu'); }
  public function install(){ return parent::install()
    && Configuration::updateValue('SCM_DEPTH',3)
    && Configuration::updateValue('SCM_OPEN_CURRENT',1)
    && Configuration::updateValue('SCM_TITLE','')
    && Configuration::updateValue('SCM_PADDING',6)
    && Configuration::updateValue('SCM_SUBCOLOR','#000000')
    && Configuration::updateValue('SCM_GAP',4)
    && $this->registerHook('header') && $this->registerHook('displayLeftColumn'); }
  public function uninstall(){ foreach(['SCM_DEPTH','SCM_OPEN_CURRENT','SCM_TITLE','SCM_PADDING','SCM_SUBCOLOR','SCM_GAP'] as $k) Configuration::deleteByName($k); return parent::uninstall(); }
  public function hookHeader(){ $this->context->controller->registerStylesheet('scm','modules/'.$this->name.'/views/css/menu.css'); }
  public function hookDisplayLeftColumn(){ return $this->renderMenu(); }
  private function renderMenu(){
    $tree=$this->buildTree(2,Configuration::get('SCM_DEPTH'),$this->context->language->id);
    $this->context->smarty->assign([
      'tree'=>$tree,
      'current'=>(int)Tools::getValue('id_category',0),
      'open'=>Configuration::get('SCM_OPEN_CURRENT'),
      'pad'=>Configuration::get('SCM_PADDING'),
      'gap'=>Configuration::get('SCM_GAP'),
      'sub'=>Configuration::get('SCM_SUBCOLOR')
    ]);
    return $this->fetch('module:spider_category_menu/views/templates/hook/menu.tpl');
  }
  private function buildTree($id,$depth,$lang){ $cat=new Category($id,$lang);$res=[];$ch=$cat->getSubCategories($lang); if(!is_array($ch))return[]; foreach($ch as $c){ $cid=(int)$c['id_category']; $node=['id'=>$cid,'name'=>$c['name'],'link'=>$this->context->link->getCategoryLink($cid),'children'=>[]]; if($depth>1)$node['children']=$this->buildTree($cid,$depth-1,$lang); $res[]=$node; } return $res; }
}
?>
