<?php
class Spider_Category_TweaksWidgetModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        header('Content-Type: text/html; charset=utf-8');
        $type = Tools::getValue('type', 'new');
        $type = in_array($type, ['new','featured','bestsellers']) ? $type : 'new';
        $limit = (int)Tools::getValue('nb', 8);
        $html = '';
        if ($type === 'new') {
            $mod = Module::getInstanceByName('ps_newproducts');
            if ($mod && $mod->active && method_exists($mod, 'renderWidget')) {
                $html = $mod->renderWidget('displayCategoryHeader', ['nbProducts'=>$limit,'nbr'=>$limit,'nb'=>$limit]);
            }
        } elseif ($type === 'featured') {
            $mod = Module::getInstanceByName('ps_featuredproducts');
            if ($mod && $mod->active && method_exists($mod, 'renderWidget')) {
                $html = $mod->renderWidget('displayCategoryHeader', ['nbProducts'=>$limit,'nbr'=>$limit,'nb'=>$limit]);
            }
        } else {
            $mod = Module::getInstanceByName('ps_bestsellers');
            if ($mod && $mod->active && method_exists($mod, 'renderWidget')) {
                $html = $mod->renderWidget('displayCategoryHeader', ['nbProducts'=>$limit,'nbr'=>$limit,'nb'=>$limit]);
            }
        }
        die($html);
    }
}
