<?php
if (!defined('_PS_VERSION_')) { exit; }

class Spider_Category_Tweaks extends Module
{
    public function __construct()
    {
        $this->name = 'spider_category_tweaks';
        $this->tab = 'front_office_features';
        $this->version = '1.2.0';
        $this->author = 'Spiderbyte';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('Spider - Category Tweaks');
        $this->description = $this->l('Nasconde le sottocategorie nelle pagine categoria e (opzionale) mostra un blocco con Ultimi Arrivi, In evidenza o Più venduti in testa alla lista prodotti, senza modificare il tema.');
        $this->ps_versions_compliancy = ['min' => '8.0.0', 'max' => _PS_VERSION_];
    }

    public function install()
    {
        return parent::install()
            && Configuration::updateValue('SPCT_ENABLE_WIDGET', 0)
            && Configuration::updateValue('SPCT_WIDGET_TYPE', 'new')
            && Configuration::updateValue('SPCT_CATEGORY_IDS', '2')
            && Configuration::updateValue('SPCT_LIMIT_NEW', 8)
            && Configuration::updateValue('SPCT_LIMIT_BEST', 8)
            && Configuration::updateValue('SPCT_LIMIT_FEATURED', 8)
            && Configuration::updateValue('SPCT_HIDE_SCOPE', 'selected')
            && $this->registerHook('header')
            && $this->registerHook('displayCategoryHeader');
    }

    public function uninstall()
    {
        Configuration::deleteByName('SPCT_ENABLE_WIDGET');
        Configuration::deleteByName('SPCT_WIDGET_TYPE');
        Configuration::deleteByName('SPCT_CATEGORY_IDS');
        Configuration::deleteByName('SPCT_LIMIT_NEW');
        Configuration::deleteByName('SPCT_LIMIT_BEST');
        Configuration::deleteByName('SPCT_LIMIT_FEATURED');
        Configuration::deleteByName('SPCT_HIDE_SCOPE');
        return parent::uninstall();
    }

    public function getContent()
    {
        $output = '';
        if (Tools::isSubmit('submitSpCt')) {
            Configuration::updateValue('SPCT_ENABLE_WIDGET', (int)Tools::getValue('SPCT_ENABLE_WIDGET', 0));
            $type = Tools::getValue('SPCT_WIDGET_TYPE', 'new');
            if (!in_array($type, ['new','featured','bestsellers'])) { $type = 'new'; }
            Configuration::updateValue('SPCT_WIDGET_TYPE', $type);
            Configuration::updateValue('SPCT_LIMIT_NEW', (int)Tools::getValue('SPCT_LIMIT_NEW', 8));
            Configuration::updateValue('SPCT_LIMIT_BEST', (int)Tools::getValue('SPCT_LIMIT_BEST', 8));
            Configuration::updateValue('SPCT_LIMIT_FEATURED', (int)Tools::getValue('SPCT_LIMIT_FEATURED', 8));
            Configuration::updateValue('SPCT_HIDE_SCOPE', (string)Tools::getValue('SPCT_HIDE_SCOPE', 'selected'));
            $ids = trim((string)Tools::getValue('SPCT_CATEGORY_IDS', ''));
            $ids = preg_replace('/\s+/', '', $ids);
            Configuration::updateValue('SPCT_CATEGORY_IDS', $ids);
            $output .= $this->displayConfirmation($this->l('Impostazioni salvate.'));
        }

        $enableWidget = (int)Configuration::get('SPCT_ENABLE_WIDGET', 0);
        $widgetType   = (string)Configuration::get('SPCT_WIDGET_TYPE', 'new');
        $limitNew     = (int)Configuration::get('SPCT_LIMIT_NEW', 8);
        $limitBest    = (int)Configuration::get('SPCT_LIMIT_BEST', 8);
        $limitFeat    = (int)Configuration::get('SPCT_LIMIT_FEATURED', 8);
        $hideScope    = (string)Configuration::get('SPCT_HIDE_SCOPE', 'selected');
        $categoryIds  = (string)Configuration::get('SPCT_CATEGORY_IDS', '');

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->module = $this;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitSpCt';
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $fieldsForm = [
            'form' => [
                'legend' => ['title' => $this->l('Impostazioni')],
                'input'  => [
                    [
                        'type' => 'switch',
                        'label' => $this->l('Mostra un blocco in testa alla pagina categoria'),
                        'name' => 'SPCT_ENABLE_WIDGET',
                        'is_bool' => true,
                        'values' => [
                            ['id' => 'on', 'value' => 1, 'label' => $this->l('Sì')],
                            ['id' => 'off', 'value' => 0, 'label' => $this->l('No')],
                        ],
                        'desc' => $this->l('Funziona sempre: se il tema non ha l\'hook displayCategoryHeader, il modulo inserisce il blocco via JS.'),
                    ],
                    [
                        'type' => 'select',
                        'label' => $this->l('Contenuto da mostrare'),
                        'name' => 'SPCT_WIDGET_TYPE',
                        'options' => [
                            'query' => [
                                ['id' => 'new', 'name' => $this->l('Ultimi arrivi')],
                                ['id' => 'featured', 'name' => $this->l('Prodotti in evidenza')],
                                ['id' => 'bestsellers', 'name' => $this->l('Più venduti / Popolari')],
                            ],
                            'id' => 'id',
                            'name' => 'name',
                        ],
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Numero di prodotti (Nuovi)'),
                        'name' => 'SPCT_LIMIT_NEW',
                        'class' => 'fixed-width-sm',
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Numero di prodotti (Popolari)'),
                        'name' => 'SPCT_LIMIT_BEST',
                        'class' => 'fixed-width-sm',
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Numero di prodotti (In evidenza)'),
                        'name' => 'SPCT_LIMIT_FEATURED',
                        'class' => 'fixed-width-sm',
                    ],
                    [
                        'type' => 'select',
                        'label' => $this->l('Dove nascondere le sottocategorie'),
                        'name' => 'SPCT_HIDE_SCOPE',
                        'options' => [
                            'query' => [
                                ['id' => 'selected', 'name' => $this->l('Solo nelle categorie indicate qui sotto')],
                                ['id' => 'all', 'name' => $this->l('In tutte le categorie')],
                                ['id' => 'top', 'name' => $this->l('Solo nelle categorie di primo livello')],
                            ],
                            'id' => 'id',
                            'name' => 'name',
                        ],
                        'desc' => $this->l('Per mostrare le sottocategorie nelle pagine figlie, usa "Solo nelle categorie indicate" e imposta ad es. 2 (Home).'),
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Limita a queste categorie (ID separati da virgole). Lascia vuoto per nessuna.'),
                        'name' => 'SPCT_CATEGORY_IDS',
                        'class' => 'fixed-width-xxl',
                        'desc' => $this->l('Esempio: 2,5,7'),
                    ],
                ],
                'submit' => ['title' => $this->l('Salva')],
            ],
        ];
        $helper->fields_value = [
            'SPCT_ENABLE_WIDGET' => $enableWidget,
            'SPCT_WIDGET_TYPE'   => $widgetType,
            'SPCT_LIMIT_NEW'     => $limitNew,
            'SPCT_LIMIT_BEST'    => $limitBest,
            'SPCT_LIMIT_FEATURED'=> $limitFeat,
            'SPCT_HIDE_SCOPE'    => $hideScope,
            'SPCT_CATEGORY_IDS'  => $categoryIds,
        ];
        return $output.$helper->generateForm([$fieldsForm]);
    }

    private function isAllowedCategory()
    {
        $controller = $this->context->controller;
        if (!($controller && get_class($controller) === 'CategoryController')) { return false; }
        $current = (int)Tools::getValue('id_category', 0);
        if ($current === 0) { return false; }
        $scope = (string)Configuration::get('SPCT_HIDE_SCOPE', 'selected');
        if ($scope === 'all') { return true; }
        if ($scope === 'top') {
            $cat = new Category($current, (int)$this->context->language->id);
            return (isset($cat->level_depth) && (int)$cat->level_depth <= 2);
        }
        $ids = trim((string)Configuration::get('SPCT_CATEGORY_IDS', ''));
        if ($ids === '') { return false; }
        $allowed = array_filter(array_map('intval', explode(',', $ids)));
        return in_array($current, $allowed);
    }

    public function hookHeader()
    {
        if ($this->isAllowedCategory()) {
            $this->context->controller->registerStylesheet('spct-front','modules/'.$this->name.'/views/css/front.css',['media'=>'all','priority'=>150]);
            $this->context->controller->registerJavascript('spct-inject','modules/'.$this->name.'/views/js/inject.js',['position'=>'bottom','priority'=>150]);
            $widgetEnabled = (int)Configuration::get('SPCT_ENABLE_WIDGET', 0);
            $type = (string)Configuration::get('SPCT_WIDGET_TYPE', 'new');
            $type = in_array($type, ['new','featured','bestsellers']) ? $type : 'new';
            $limit = ($type==='new') ? (int)Configuration::get('SPCT_LIMIT_NEW',8) : (($type==='featured') ? (int)Configuration::get('SPCT_LIMIT_FEATURED',8) : (int)Configuration::get('SPCT_LIMIT_BEST',8));
            $url = $this->context->link->getModuleLink($this->name, 'widget', ['type'=>$type, 'nb'=>$limit]);
            Media::addJsDef([
                'spct_enabled' => $widgetEnabled,
                'spct_widget_url' => $url,
            ]);
        }
    }

    public function hookDisplayCategoryHeader($params)
    {
        if (!$this->isAllowedCategory()) { return ''; }
        if (!(int)Configuration::get('SPCT_ENABLE_WIDGET')) { return ''; }
        $type = (string)Configuration::get('SPCT_WIDGET_TYPE', 'new');
        $html = '';
        if ($type === 'new') {
            $mod = Module::getInstanceByName('ps_newproducts');
            if ($mod && $mod->active && method_exists($mod, 'renderWidget')) {
                $limit = (int)Configuration::get('SPCT_LIMIT_NEW',8);
                $html = $mod->renderWidget('displayCategoryHeader', ['nbProducts'=>$limit,'nbr'=>$limit,'nb'=>$limit]);
            }
        } elseif ($type === 'featured') {
            $mod = Module::getInstanceByName('ps_featuredproducts');
            if ($mod && $mod->active && method_exists($mod, 'renderWidget')) {
                $limit = (int)Configuration::get('SPCT_LIMIT_FEATURED',8);
                $html = $mod->renderWidget('displayCategoryHeader', ['nbProducts'=>$limit,'nbr'=>$limit,'nb'=>$limit]);
            }
        } else { // bestsellers
            $mod = Module::getInstanceByName('ps_bestsellers');
            if ($mod && $mod->active && method_exists($mod, 'renderWidget')) {
                $limit = (int)Configuration::get('SPCT_LIMIT_BEST',8);
                $html = $mod->renderWidget('displayCategoryHeader', ['nbProducts'=>$limit,'nbr'=>$limit,'nb'=>$limit]);
            }
        }
        $this->context->smarty->assign(['spct_inner' => $html]);
        return $this->fetch('module:'.$this->name.'/views/templates/hook/header_block.tpl');
    }
}
