<?php
if (!defined('_PS_VERSION_')) { exit; }

class Spider_CmsInject extends Module
{
    const CFG_EDIT_CMS = 'SPIDER_CMSINJECT_EDIT_CMS';

    public function __construct()
    {
        $this->name = 'spider_cmsinject';
        $this->tab = 'front_office_features';
        $this->version = '2.3.0';
        $this->author = 'Spiderbyte';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('CMS Inject (per-pagina)');
        $this->description = $this->l('Inietta HTML e CSS per la singola pagina CMS selezionata. Posizione fissa: displayContentWrapperTop.');
        $this->ps_versions_compliancy = array('min' => '8.0.0', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        if (!parent::install() || !$this->registerHook('displayContentWrapperTop')) {
            return false;
        }

        // Seed: prova a precaricare contenuti per pagine con titolo "Consegna" e "Chi siamo" nella lingua di default
        $idDefault = (int)Configuration::get('PS_LANG_DEFAULT');
        $p = _DB_PREFIX_;
        $pages = Db::getInstance()->executeS('SELECT c.id_cms AS id, cl.meta_title AS name FROM `'.$p.'cms` c INNER JOIN `'.$p.'cms_lang` cl ON (c.id_cms=cl.id_cms AND cl.id_lang='.(int)$idDefault.')');
        if (is_array($pages)) {
            foreach ($pages as $row) {
                $title = trim($row['name']);
                $idCms = (int)$row['id'];
                if (mb_strtolower($title, 'UTF-8') === mb_strtolower('Consegna', 'UTF-8')) {
                    // Servizi
                    $css = '.services-box{display:grid;grid-template-columns:repeat(3,1fr);gap:25px;margin:35px 0;width:100%;} .service-card{border:1px solid #e5e5e5;padding:35px 20px;background:#fff;text-align:center;border-radius:4px} @media(max-width:768px){.services-box{grid-template-columns:1fr !important;gap:15px !important}}';
                    $html = '<div class="services-box">'
                          . '<div class="service-card"><h3>Spedizione rapida</h3><p>Consegne veloci in tutta Italia</p></div>'
                          . '<div class="service-card"><h3>Qualità garantita</h3><p>Componenti selezionati e testati</p></div>'
                          . '<div class="service-card"><h3>Supporto dedicato</h3><p>Assistenza amichevole</p></div>'
                          . '</div>';
                    Configuration::updateValue($this->cssKeyForCms($idCms), $css, true);
                    Configuration::updateValue($this->htmlKeyForCmsLang($idCms, $idDefault), $html, true);
                }
                if (mb_strtolower($title, 'UTF-8') === mb_strtolower('Chi siamo', 'UTF-8')) {
                    // Mosaico 6+2 (immagini segnaposto)
                    $css = '.mosaic-6-2{display:grid;grid-template-columns:repeat(4,1fr);grid-auto-rows:220px;gap:10px;margin:50px 0}.mosaic-text-left,.mosaic-text-right{display:flex;justify-content:center;align-items:center;color:#fff;font-size:22px;font-weight:600;padding:20px;text-align:center}.mosaic-text-left{background:#009CF0}.mosaic-text-right{background:#0E1A2B}.mosaic-text-left{grid-column:1 / span 2}.mosaic-text-right{grid-column:3 / span 2}.mosaic-img img{width:100%;height:100%;object-fit:cover;display:block}@media(max-width:768px){.mosaic-6-2{grid-template-columns:1fr;grid-auto-rows:180px}.mosaic-text-left,.mosaic-text-right{grid-column:1 / span 1;font-size:18px}}';
                    $html = '<div class="mosaic-6-2">'
                          . '<div class="mosaic-text-left"><span>Design e performance</span></div>'
                          . '<div class="mosaic-img"><img src="#" alt="img1"></div>'
                          . '<div class="mosaic-img"><img src="#" alt="img2"></div>'
                          . '<div class="mosaic-img"><img src="#" alt="img3"></div>'
                          . '<div class="mosaic-img"><img src="#" alt="img4"></div>'
                          . '<div class="mosaic-img"><img src="#" alt="img5"></div>'
                          . '<div class="mosaic-img"><img src="#" alt="img6"></div>'
                          . '<div class="mosaic-text-right"><span>Esperienza immersiva</span></div>'
                          . '</div>';
                    Configuration::updateValue($this->cssKeyForCms($idCms), $css, true);
                    Configuration::updateValue($this->htmlKeyForCmsLang($idCms, $idDefault), $html, true);
                }
            }
        }
        return true;
    }

    private function cssKeyForCms($id_cms)
    {
        return 'SPIDER_CMSINJECT_V2_CSS_CMS_'.(int)$id_cms;
    }

    private function htmlKeyForCmsLang($id_cms, $id_lang)
    {
        return 'SPIDER_CMSINJECT_V2_HTML_CMS_'.(int)$id_cms.'_LANG_'.(int)$id_lang;
    }

    /** HOOK fisso */
    public function hookDisplayContentWrapperTop($params)
    {
        $controller = $this->context->controller;
        $id_cms = (int)Tools::getValue('id_cms');
        $isCms = (isset($controller->php_self) && $controller->php_self === 'cms') || $id_cms > 0;
        if (!$isCms || $id_cms <= 0) return '';

        $id_lang = (int)$this->context->language->id;
        $html = Configuration::get($this->htmlKeyForCmsLang($id_cms, $id_lang));
        $css  = Configuration::get($this->cssKeyForCms($id_cms));
        if (!$html && !$css) return '';

        $this->context->smarty->assign(array(
            'sci_css'  => (string)$css,
            'sci_html' => (string)$html,
        ));
        return $this->fetch('module:'.$this->name.'/views/templates/hook/inject.tpl');
    }

    /** BACK OFFICE */
    public function getContent()
    {
        $output = '';

        // FORM 1: selezione pagina (submit separato)
        if (Tools::isSubmit('select'.$this->name)) {
            $selected = (int)Tools::getValue(self::CFG_EDIT_CMS, 0);
            Configuration::updateValue(self::CFG_EDIT_CMS, $selected);
        }

        // FORM 2: salvataggio contenuti per pagina
        if (Tools::isSubmit('submit'.$this->name.'_cms')) {
            $editCms = (int)Tools::getValue(self::CFG_EDIT_CMS, (int)Configuration::get(self::CFG_EDIT_CMS));
            Configuration::updateValue(self::CFG_EDIT_CMS, $editCms);
            if ($editCms > 0) {
                $cssPerPage = Tools::getValue('SPIDER_CMSINJECT_V2_CSS_PERPAGE', '');
                Configuration::updateValue($this->cssKeyForCms($editCms), $cssPerPage, true);
                foreach (Language::getLanguages(false) as $lang) {
                    $val = Tools::getValue('SPIDER_CMSINJECT_V2_HTML_PERPAGE_LANG_'.(int)$lang['id_lang'], '');
                    Configuration::updateValue($this->htmlKeyForCmsLang($editCms, (int)$lang['id_lang']), $val, true);
                }
                $output .= $this->displayConfirmation($this->l('Contenuti salvati per la pagina selezionata.'));
            } else {
                $output .= $this->displayError($this->l('Seleziona una pagina CMS.'));
            }
        }

        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
        $selectedId = (int)Configuration::get(self::CFG_EDIT_CMS);

        // --- FORM 1: select pagina (autosubmit on change) ---
        $form_select = array(
            'form' => array(
                'legend' => array('title' => $this->l('Seleziona pagina CMS')),
                'input'  => array(
                    array(
                        'type' => 'select',
                        'label' => $this->l('Pagina CMS'),
                        'name' => self::CFG_EDIT_CMS,
                        'options' => array('query' => $this->getCmsOptions(), 'id' => 'id', 'name' => 'name'),
                        'class' => 'js-sci-cms-select'
                    ),
                ),
                'submit' => array('title' => $this->l('Carica pagina'))
            )
        );

        $helper1 = new HelperForm();
        $helper1->show_toolbar = false;
        $helper1->module = $this;
        $helper1->default_form_language = $default_lang;
        $helper1->allow_employee_form_lang = (int)Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG');
        $helper1->identifier = $this->identifier;
        $helper1->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        $helper1->token = Tools::getAdminTokenLite('AdminModules');
        $helper1->submit_action = 'select'.$this->name;
        $helper1->fields_value = array(self::CFG_EDIT_CMS => $selectedId);
        $html = $helper1->generateForm(array($form_select));

        // --- FORM 2: editor (con hidden id_cms per salvataggio sicuro) ---
        $form_edit = array(
            'form' => array(
                'legend' => array('title' => $this->l('Contenuti della pagina selezionata (hook: displayContentWrapperTop)')),
                'input'  => array(
                    array('type' => 'hidden', 'name' => self::CFG_EDIT_CMS),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('CSS per questa pagina'),
                        'name'  => 'SPIDER_CMSINJECT_V2_CSS_PERPAGE',
                        'autoload_rte' => false,
                        'rows' => 8,
                        'cols' => 60,
                        'desc' => $this->l('Lascia vuoto se non serve CSS custom.')
                    ),
                ),
                'submit' => array('title' => $this->l('Salva pagina'))
            )
        );
        foreach (Language::getLanguages(false) as $lang) {
            $form_edit['form']['input'][] = array(
                'type' => 'textarea',
                'label' => $this->l('HTML per questa pagina').' ('.$lang['iso_code'].')',
                'name'  => 'SPIDER_CMSINJECT_V2_HTML_PERPAGE_LANG_'.(int)$lang['id_lang'],
                'autoload_rte' => false,
                'rows' => 10,
                'cols' => 60,
                'desc' => $this->l('Incolla qui i tuoi <div> (grid/flex/icone). Saranno stampati come raw HTML.')
            );
        }
        $helper2 = new HelperForm();
        $helper2->show_toolbar = false;
        $helper2->module = $this;
        $helper2->default_form_language = $default_lang;
        $helper2->allow_employee_form_lang = (int)Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG');
        $helper2->identifier = $this->identifier;
        $helper2->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        $helper2->token = Tools::getAdminTokenLite('AdminModules');
        $helper2->submit_action = 'submit'.$this->name.'_cms';
        $values_edit = array(
            self::CFG_EDIT_CMS => $selectedId,
            'SPIDER_CMSINJECT_V2_CSS_PERPAGE' => ($selectedId > 0 ? Configuration::get($this->cssKeyForCms($selectedId)) : ''),
        );
        foreach (Language::getLanguages(false) as $lang) {
            $values_edit['SPIDER_CMSINJECT_V2_HTML_PERPAGE_LANG_'.(int)$lang['id_lang']] = ($selectedId > 0 ? Configuration::get($this->htmlKeyForCmsLang($selectedId, (int)$lang['id_lang'])) : '');
        }
        $helper2->fields_value = $values_edit;
        $html .= $helper2->generateForm(array($form_edit));

        // JS: autosubmit on change (solo select form)
        $html .= '<script>document.addEventListener("DOMContentLoaded",function(){var s=document.querySelector("form select[name=\''
              . self::CFG_EDIT_CMS
              . '\']");if(s){s.addEventListener("change",function(){var f=s.closest("form");if(f){f.submit();}});}});</script>';

        return $output.$html;
    }

    protected function getCmsOptions()
    {
        $idLang = (int)$this->context->language->id;
        $p = _DB_PREFIX_;
        $sql = 'SELECT c.id_cms as id, cl.meta_title as name FROM `'.$p.'cms` c '
             . 'INNER JOIN `'.$p.'cms_lang` cl ON (c.id_cms=cl.id_cms AND cl.id_lang='.(int)$idLang.') '
             . 'ORDER BY cl.meta_title ASC';
        $rows = Db::getInstance()->executeS($sql) ?: array();
        return $rows;
    }
}
