<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

class Spider_Googlemapfooter extends Module
{
    public function __construct()
    {
        $this->name = 'spider_googlemapfooter';
        $this->tab = 'front_office_features';
        $this->version = '1.1.0';
        $this->author = 'Spiderbyte';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Google Map Footer');
        $this->description = $this->l("Mostra una mappa di Google nel footer con un indirizzo configurabile.");
        $this->confirmUninstall = $this->l('Sei sicuro di voler disinstallare?');
    }

    public function install()
    {
        if (!parent::install()) {
            return false;
        }
        $ok = true;
        $ok = $ok && Configuration::updateValue('SPIDER_GMF_ADDRESS', 'Piazza del Duomo, 44121 Ferrara FE, Italia');
        $ok = $ok && Configuration::updateValue('SPIDER_GMF_ZOOM', 15);
        $ok = $ok && Configuration::updateValue('SPIDER_GMF_HEIGHT', 280);
        $ok = $ok && $this->registerHook('displayFooterBefore');
        $ok = $ok && $this->registerHook('displayFooter');
        return $ok;
    }

    public function uninstall()
    {
        $ok = true;
        $ok = $ok && Configuration::deleteByName('SPIDER_GMF_ADDRESS');
        $ok = $ok && Configuration::deleteByName('SPIDER_GMF_ZOOM');
        $ok = $ok && Configuration::deleteByName('SPIDER_GMF_HEIGHT');
        return parent::uninstall() && $ok;
    }

    public function getContent()
    {
        $output = '';
        if (Tools::isSubmit('submit'.$this->name)) {
            $address = (string)Tools::getValue('SPIDER_GMF_ADDRESS', '');
            $zoom = (int)Tools::getValue('SPIDER_GMF_ZOOM', 15);
            $height = (int)Tools::getValue('SPIDER_GMF_HEIGHT', 280);

            if ($address === '') {
                $output .= $this->displayError($this->l('Indirizzo obbligatorio.'));
            } else {
                Configuration::updateValue('SPIDER_GMF_ADDRESS', $address);
                Configuration::updateValue('SPIDER_GMF_ZOOM', max(1, min(21, $zoom)));
                Configuration::updateValue('SPIDER_GMF_HEIGHT', max(120, min(1200, $height)));
                $output .= $this->displayConfirmation($this->l('Impostazioni aggiornate.'));
            }
        }
        return $output.$this->renderForm();
    }

    protected function renderForm()
    {
        $fields_form = [];
        $fields_form[0]['form'] = [
            'legend' => [
                'title' => $this->l('Impostazioni mappa'),
                'icon' => 'icon-map-marker'
            ],
            'input' => [
                [
                    'type' => 'text',
                    'label' => $this->l('Indirizzo'),
                    'name' => 'SPIDER_GMF_ADDRESS',
                    'desc' => $this->l("Inserisci l'indirizzo da mostrare sulla mappa."),
                    'required' => true,
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Altezza (px)'),
                    'name' => 'SPIDER_GMF_HEIGHT',
                    'class' => 'fixed-width-sm',
                    'desc' => $this->l("Altezza dell'iframe in pixel (min 120, max 1200)."),
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Zoom (1-21)'),
                    'name' => 'SPIDER_GMF_ZOOM',
                    'class' => 'fixed-width-sm',
                    'desc' => $this->l('Livello di zoom della mappa.'),
                ],
            ],
            'submit' => [
                'title' => $this->l('Salva'),
                'class' => 'btn btn-default pull-right'
            ]
        ];

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        $helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');
        $helper->allow_employee_form_lang = true;
        $helper->title = $this->displayName;
        $helper->show_toolbar = false;
        $helper->toolbar_scroll = false;
        $helper->submit_action = 'submit'.$this->name;

        $helper->fields_value['SPIDER_GMF_ADDRESS'] = Configuration::get('SPIDER_GMF_ADDRESS');
        $helper->fields_value['SPIDER_GMF_ZOOM'] = (int)Configuration::get('SPIDER_GMF_ZOOM');
        $helper->fields_value['SPIDER_GMF_HEIGHT'] = (int)Configuration::get('SPIDER_GMF_HEIGHT');

        return $helper->generateForm($fields_form);
    }

    public function hookDisplayFooterBefore($params)
    {
        return $this->renderMap();
    }

    public function hookDisplayFooter($params)
    {
        return $this->renderMap();
    }

    protected function renderMap()
    {
        $this->context->smarty->assign([
            'spider_gmf_address' => Configuration::get('SPIDER_GMF_ADDRESS'),
            'spider_gmf_zoom' => (int)Configuration::get('SPIDER_GMF_ZOOM'),
            'spider_gmf_height' => (int)Configuration::get('SPIDER_GMF_HEIGHT'),
        ]);
        return $this->display(__FILE__, 'views/templates/hook/displayFooter.tpl');
    }
}
