<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

class Spider_Headercta extends Module implements WidgetInterface
{
    public function __construct()
    {
        $this->name = 'spider_headercta';
        $this->tab = 'front_office_features';
        $this->version = '1.0.5';
        $this->author = 'Spiderbyte / Alessandra';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Spider Header CTA');
        $this->description = $this->l('Pulsante CTA nell header; compatibile con Hummingbird.');
        $this->ps_versions_compliancy = array('min' => '8.0.0', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        return parent::install()
            && $this->registerHook('displayTop')
            && $this->registerHook('header')
            && $this->installDefaults();
    }

    protected function installDefaults()
    {
        Configuration::updateValue('SPIDER_HEADERCTA_TEXT', 'Scopri le offerte');
        Configuration::updateValue('SPIDER_HEADERCTA_LINK', __PS_BASE_URI__);
        Configuration::updateValue('SPIDER_HEADERCTA_ICON', 'fa-solid fa-bolt');
        Configuration::updateValue('SPIDER_HEADERCTA_COLOR_START', '#ff0080');
        Configuration::updateValue('SPIDER_HEADERCTA_COLOR_END', '#6a00ff');
        Configuration::updateValue('SPIDER_HEADERCTA_USE_GRADIENT', 1);
        Configuration::updateValue('SPIDER_HEADERCTA_BORDER_RADIUS', '999px');
        Configuration::updateValue('SPIDER_HEADERCTA_PADDING', '10px 18px');
        Configuration::updateValue('SPIDER_HEADERCTA_OPEN_NEW', 0);
        Configuration::updateValue('SPIDER_HEADERCTA_EXTRA_CLASS', '');
        Configuration::updateValue('SPIDER_HEADERCTA_MARGIN_TOP', '0');
        Configuration::updateValue('SPIDER_HEADERCTA_MARGIN_BOTTOM', '0');
        Configuration::updateValue('SPIDER_HEADERCTA_LOAD_FA', 1);
        return true;
    }

    public function uninstall()
    {
        return parent::uninstall();
    }

    public function getContent()
    {
        $output = '';
        if (Tools::isSubmit('submitSpiderHeaderCta')) {
            $keys = array(
                'SPIDER_HEADERCTA_TEXT',
                'SPIDER_HEADERCTA_LINK',
                'SPIDER_HEADERCTA_ICON',
                'SPIDER_HEADERCTA_COLOR_START',
                'SPIDER_HEADERCTA_COLOR_END',
                'SPIDER_HEADERCTA_USE_GRADIENT',
                'SPIDER_HEADERCTA_BORDER_RADIUS',
                'SPIDER_HEADERCTA_PADDING',
                'SPIDER_HEADERCTA_OPEN_NEW',
                'SPIDER_HEADERCTA_EXTRA_CLASS',
                'SPIDER_HEADERCTA_MARGIN_TOP',
                'SPIDER_HEADERCTA_MARGIN_BOTTOM',
                'SPIDER_HEADERCTA_LOAD_FA'
            );
            foreach ($keys as $k) {
                $val = Tools::getValue($k);
                if (in_array($k, array('SPIDER_HEADERCTA_USE_GRADIENT','SPIDER_HEADERCTA_OPEN_NEW','SPIDER_HEADERCTA_LOAD_FA'))) {
                    $val = (int) (bool) $val;
                }
                Configuration::updateValue($k, $val);
            }
            $output .= $this->displayConfirmation($this->l('Impostazioni salvate.'));
        }
        return $output.$this->renderForm();
    }

    protected function renderForm()
    {
        $defaultLang = (int) Configuration::get('PS_LANG_DEFAULT');
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Impostazioni pulsante Header'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array('type' => 'text', 'label' => $this->l('Testo pulsante'), 'name' => 'SPIDER_HEADERCTA_TEXT'),
                    array('type' => 'text', 'label' => $this->l('Link'), 'name' => 'SPIDER_HEADERCTA_LINK', 'desc' => $this->l('URL assoluto o relativo')),
                    array('type' => 'text', 'label' => $this->l('Icona (classe)'), 'name' => 'SPIDER_HEADERCTA_ICON', 'desc' => $this->l('Esempio: fa-solid fa-bolt (richiede Font Awesome 6)')),
                    array('type' => 'switch', 'label' => $this->l('Carica Font Awesome da CDN'), 'name' => 'SPIDER_HEADERCTA_LOAD_FA', 'is_bool' => true,
                        'values' => array(
                            array('id' => 'fa_on', 'value' => 1, 'label' => $this->l('Si')),
                            array('id' => 'fa_off', 'value' => 0, 'label' => $this->l('No'))
                        )
                    ),
                    array('type' => 'switch', 'label' => $this->l('Usa sfumatura'), 'name' => 'SPIDER_HEADERCTA_USE_GRADIENT', 'is_bool' => true,
                        'values' => array(
                            array('id' => 'active_on', 'value' => 1, 'label' => $this->l('Si')),
                            array('id' => 'active_off', 'value' => 0, 'label' => $this->l('No'))
                        )
                    ),
                    array('type' => 'color', 'label' => $this->l('Colore/Gradiente start'), 'name' => 'SPIDER_HEADERCTA_COLOR_START'),
                    array('type' => 'color', 'label' => $this->l('Gradiente end (se attivo)'), 'name' => 'SPIDER_HEADERCTA_COLOR_END'),
                    array('type' => 'text', 'label' => $this->l('Raggio bordo'), 'name' => 'SPIDER_HEADERCTA_BORDER_RADIUS', 'desc' => 'es. 6px o 999px per pill'),
                    array('type' => 'text', 'label' => $this->l('Padding'), 'name' => 'SPIDER_HEADERCTA_PADDING', 'desc' => 'es. 10px 18px'),
                    array('type' => 'switch', 'label' => $this->l('Apri in nuova scheda'), 'name' => 'SPIDER_HEADERCTA_OPEN_NEW', 'is_bool' => true,
                        'values' => array(
                            array('id' => 'new_on', 'value' => 1, 'label' => $this->l('Si')),
                            array('id' => 'new_off', 'value' => 0, 'label' => $this->l('No'))
                        )
                    ),
                    array('type' => 'text', 'label' => $this->l('Classe extra'), 'name' => 'SPIDER_HEADERCTA_EXTRA_CLASS'),
                    array('type' => 'text', 'label' => $this->l('Margine TOP (px)'), 'name' => 'SPIDER_HEADERCTA_MARGIN_TOP', 'desc' => 'es. 0, 6, 10 (solo numero in pixel)'),
                    array('type' => 'text', 'label' => $this->l('Margine BOTTOM (px)'), 'name' => 'SPIDER_HEADERCTA_MARGIN_BOTTOM', 'desc' => 'es. 0, 6, 10 (solo numero in pixel)')
                ),
                'submit' => array('title' => $this->l('Salva'), 'class' => 'btn btn-default pull-right')
            )
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $defaultLang;
        $helper->allow_employee_form_lang = $defaultLang;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitSpiderHeaderCta';
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->fields_value = array(
            'SPIDER_HEADERCTA_TEXT' => Configuration::get('SPIDER_HEADERCTA_TEXT'),
            'SPIDER_HEADERCTA_LINK' => Configuration::get('SPIDER_HEADERCTA_LINK'),
            'SPIDER_HEADERCTA_ICON' => Configuration::get('SPIDER_HEADERCTA_ICON'),
            'SPIDER_HEADERCTA_LOAD_FA' => Configuration::get('SPIDER_HEADERCTA_LOAD_FA'),
            'SPIDER_HEADERCTA_COLOR_START' => Configuration::get('SPIDER_HEADERCTA_COLOR_START'),
            'SPIDER_HEADERCTA_COLOR_END' => Configuration::get('SPIDER_HEADERCTA_COLOR_END'),
            'SPIDER_HEADERCTA_USE_GRADIENT' => Configuration::get('SPIDER_HEADERCTA_USE_GRADIENT'),
            'SPIDER_HEADERCTA_BORDER_RADIUS' => Configuration::get('SPIDER_HEADERCTA_BORDER_RADIUS'),
            'SPIDER_HEADERCTA_PADDING' => Configuration::get('SPIDER_HEADERCTA_PADDING'),
            'SPIDER_HEADERCTA_OPEN_NEW' => Configuration::get('SPIDER_HEADERCTA_OPEN_NEW'),
            'SPIDER_HEADERCTA_EXTRA_CLASS' => Configuration::get('SPIDER_HEADERCTA_EXTRA_CLASS'),
            'SPIDER_HEADERCTA_MARGIN_TOP' => Configuration::get('SPIDER_HEADERCTA_MARGIN_TOP'),
            'SPIDER_HEADERCTA_MARGIN_BOTTOM' => Configuration::get('SPIDER_HEADERCTA_MARGIN_BOTTOM')
        );

        return $helper->generateForm(array($fields_form));
    }

    public function renderWidget($hookName = null, array $configuration = array())
    {
        $this->smarty->assign($this->getWidgetVariables($hookName, $configuration));
        return $this->fetch('module:spider_headercta/views/templates/hook/block.tpl');
    }

    public function getWidgetVariables($hookName = null, array $configuration = array())
    {
        $useGradient = (bool) Configuration::get('SPIDER_HEADERCTA_USE_GRADIENT');
        $bg = $useGradient
            ? 'linear-gradient(90deg, '.pSQL(Configuration::get('SPIDER_HEADERCTA_COLOR_START')).' 0%, '.pSQL(Configuration::get('SPIDER_HEADERCTA_COLOR_END')).' 100%)'
            : pSQL(Configuration::get('SPIDER_HEADERCTA_COLOR_START'));
        $mt = (string) Configuration::get('SPIDER_HEADERCTA_MARGIN_TOP');
        $mb = (string) Configuration::get('SPIDER_HEADERCTA_MARGIN_BOTTOM');
        if ($mt === '' || !is_numeric($mt)) { $mt = '0'; }
        if ($mb === '' || !is_numeric($mb)) { $mb = '0'; }

        return array(
            'cta' => array(
                'text' => Configuration::get('SPIDER_HEADERCTA_TEXT'),
                'link' => Configuration::get('SPIDER_HEADERCTA_LINK'),
                'icon' => Configuration::get('SPIDER_HEADERCTA_ICON'),
                'text_color' => '#ffffff',
                'bg' => $bg,
                'radius' => Configuration::get('SPIDER_HEADERCTA_BORDER_RADIUS'),
                'padding' => Configuration::get('SPIDER_HEADERCTA_PADDING'),
                'open_new' => (bool) Configuration::get('SPIDER_HEADERCTA_OPEN_NEW'),
                'extra_class' => Configuration::get('SPIDER_HEADERCTA_EXTRA_CLASS'),
                'margin_top' => $mt,
                'margin_bottom' => $mb
            )
        );
    }

    public function hookHeader()
    {
        if ((int) Configuration::get('SPIDER_HEADERCTA_LOAD_FA')) {
            // Carica Font Awesome 6 da CDN (evita duplicati se il tema già lo carica)
            $this->context->controller->registerStylesheet(
                'spider-fa6',
                'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css',
                array('server' => 'remote', 'media' => 'all', 'priority' => 40)
            );
        }
        $this->context->controller->registerStylesheet(
            'module-spider_headercta',
            'modules/'.$this->name.'/views/assets/front.css',
            array('media' => 'all', 'priority' => 150)
        );
    }
}
