{* Inject CSS+JS to hide/remove PrestaShop footer credit *}
<style>
/* CSS: cover typical selectors and any anchor to prestashop domain */
.footer .copyright,
.footer .site-copyright,
.footer .footer-copyright,
.footer [class*="copyright"],
#footer .copyright,
#footer [class*="copyright"],
.footer a[href*="prestashop.com"],
.footer a[href*="prestashop.net"],
#footer a[href*="prestashop.com"],
#footer a[href*="prestashop.net"]{
  display: none !important;
}
</style>
<script>
// JS fallback: remove any footer node that links to prestashop or contains 'PrestaShop'
(function(){
  function removePS(){
    var roots = document.querySelectorAll('.footer, #footer');
    roots.forEach(function(root){
      // Hide anchors to prestashop domains
      root.querySelectorAll('a[href*="prestashop.com"],a[href*="prestashop.net"]').forEach(function(a){
        var el = a.closest('*');
        if(el){ el.style.display='none'; el.remove(); }
      });
      // Remove nodes which text includes 'PrestaShop'
      root.querySelectorAll('*').forEach(function(n){
        try{
          if(n.childElementCount===0){
            var t=(n.textContent||'').trim();
            if(t && /prestashop/i.test(t)){
              var el = n.closest('*');
              if(el){ el.style.display='none'; el.remove(); }
            }
          }
        }catch(e){}
      });
    });
  }
  if(document.readyState==='loading'){
    document.addEventListener('DOMContentLoaded', removePS);
  }else{
    removePS();
  }
})();
</script>
