<?php
if (!defined('_PS_VERSION_')) { exit; }

class Spider_Homecms extends Module
{
    public function __construct()
    {
        $this->name = 'spider_homecms';
        $this->tab = 'front_office_features';
        $this->version = '1.3.0';
        $this->author = 'Copilot';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('CMS as Homepage (PS9)');
        $this->description = $this->l('Reindirizza la homepage verso una pagina CMS selezionata (301/302). Compatibile con PrestaShop 9.0.x');
        $this->ps_versions_compliancy = ['min' => '9.0.0', 'max' => _PS_VERSION_];
    }

    public function install()
    {
        if (!parent::install()) { return false; }
        if (!$this->registerHook('actionFrontControllerInitAfter')) { return false; }
        // Default values
        return Configuration::updateValue('SPIDER_HOMECMS_ENABLED', 1)
            && Configuration::updateValue('SPIDER_HOMECMS_ID', 0)
            && Configuration::updateValue('SPIDER_HOMECMS_CODE', 302);
    }

    public function uninstall()
    {
        Configuration::deleteByName('SPIDER_HOMECMS_ENABLED');
        Configuration::deleteByName('SPIDER_HOMECMS_ID');
        Configuration::deleteByName('SPIDER_HOMECMS_CODE');
        return parent::uninstall();
    }

    public function getContent()
    {
        $output = '';
        $submitKey = 'submit'.$this->name; // 'submitspider_homecms'
        if (Tools::isSubmit($submitKey)) {
            $id_shop = (int)$this->context->shop->id;
            $enabled = (int)Tools::getValue('SPIDER_HOMECMS_ENABLED');
            $id_cms  = (int)Tools::getValue('SPIDER_HOMECMS_ID');
            $code    = (int)Tools::getValue('SPIDER_HOMECMS_CODE');
            Configuration::updateValue('SPIDER_HOMECMS_ENABLED', $enabled, false, null, $id_shop);
            Configuration::updateValue('SPIDER_HOMECMS_ID', $id_cms, false, null, $id_shop);
            Configuration::updateValue('SPIDER_HOMECMS_CODE', in_array($code,[301,302],true)?$code:302, false, null, $id_shop);
            $output .= $this->displayConfirmation($this->l('Impostazioni salvate.'));
        }
        return $output.$this->renderForm();
    }

    protected function renderForm()
    {
        $id_lang = (int)$this->context->language->id ?: (int)Configuration::get('PS_LANG_DEFAULT');
        $fields_form[0]['form'] = [
            'legend' => ['title' => $this->l('CMS as Homepage (PS9)')],
            'input' => [
                [
                    'type'=>'switch','label'=>$this->l('Abilita'),'name'=>'SPIDER_HOMECMS_ENABLED','values'=>[
                        ['id'=>'on','value'=>1,'label'=>$this->l('On')],
                        ['id'=>'off','value'=>0,'label'=>$this->l('Off')],
                    ]
                ],
                [
                    'type'=>'select','label'=>$this->l('Pagina CMS'),'name'=>'SPIDER_HOMECMS_ID','options'=>[
                        'query'=>$this->getCmsOptions($id_lang), 'id'=>'id_cms', 'name'=>'title']
                ],
                [
                    'type'=>'select','label'=>$this->l('Tipo di redirect'),'name'=>'SPIDER_HOMECMS_CODE','options'=>[
                        'query'=>[
                            ['id'=>302,'name'=>'302 (Temporaneo)'],
                            ['id'=>301,'name'=>'301 (Permanente)'],
                        ],
                        'id'=>'id','name'=>'name'
                    ]
                ]
            ],
            'submit'=>['title'=>$this->l('Salva')]
        ];

        $h = new HelperForm();
        $h->module = $this;
        $h->name_controller = $this->name;
        $h->token = Tools::getAdminTokenLite('AdminModules');
        $h->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        $h->default_form_language = $id_lang;
        $h->allow_employee_form_lang = $id_lang;
        $h->show_toolbar = false;
        $h->submit_action = 'submit'.$this->name; // fondamentale per il salvataggio

        $id_shop = (int)$this->context->shop->id;
        $h->fields_value = [
            'SPIDER_HOMECMS_ENABLED' => (int)Configuration::get('SPIDER_HOMECMS_ENABLED', null, null, $id_shop),
            'SPIDER_HOMECMS_ID'      => (int)Configuration::get('SPIDER_HOMECMS_ID', null, null, $id_shop),
            'SPIDER_HOMECMS_CODE'    => (int)Configuration::get('SPIDER_HOMECMS_CODE', null, null, $id_shop),
        ];
        return $h->generateForm($fields_form);
    }

    protected function getCmsOptions($id_lang)
    {
        $id_shop = (int)$this->context->shop->id;
        $opts = [];
        if (method_exists('CMS','getCMSPages')) {
            $rows = CMS::getCMSPages($id_lang, null, true, $id_shop);
            if (is_array($rows)) foreach ($rows as $r) {
                $title = '';
                if (isset($r['meta_title'])) $title = is_array($r['meta_title'])? reset($r['meta_title']) : $r['meta_title'];
                elseif (isset($r['link_rewrite'])) $title = $r['link_rewrite'];
                $opts[] = ['id_cms'=>(int)$r['id_cms'],'title'=>(string)$title];
            }
        }
        if (!$opts) {
            $sql = 'SELECT c.id_cms FROM '._DB_PREFIX_.'cms c INNER JOIN '._DB_PREFIX_.'cms_shop cs ON (c.id_cms=cs.id_cms AND cs.id_shop='.(int)$id_shop.') WHERE c.active=1 ORDER BY c.id_cms ASC';
            $rows = Db::getInstance()->executeS($sql);
            foreach ((array)$rows as $r) {
                $cms = new CMS((int)$r['id_cms'], $id_lang, $id_shop);
                if (Validate::isLoadedObject($cms)) {
                    $title = is_array($cms->meta_title) ? reset($cms->meta_title) : $cms->meta_title;
                    $opts[] = ['id_cms'=>(int)$cms->id,'title'=>(string)$title];
                }
            }
        }
        array_unshift($opts, ['id_cms'=>0,'title'=>$this->l('-- Seleziona --')]);
        return $opts;
    }

    public function hookActionFrontControllerInitAfter($params)
    {
        if (!$this->active || !Configuration::get('SPIDER_HOMECMS_ENABLED')) return;

        $controller = $this->context->controller;
        if (!is_object($controller) || !($controller instanceof FrontController)) return;
        if ((isset($controller->php_self) && $controller->php_self==='cms')
            || (class_exists('CMSControllerCore') && $controller instanceof CMSControllerCore)
            || (class_exists('CMSController') && $controller instanceof CMSController)) return;

        $pageName = method_exists($controller,'getPageName') ? $controller->getPageName() : ($controller->php_self ?? '');
        $isIndexClass = (class_exists('IndexControllerCore') && $controller instanceof IndexControllerCore) || (class_exists('IndexController') && $controller instanceof IndexController);
        $isHome = in_array($pageName,['index','home','homepage'],true) || $isIndexClass;
        if ($isHome) {
            $id_shop = (int)$this->context->shop->id;
            $id_cms  = (int)Configuration::get('SPIDER_HOMECMS_ID', null, null, $id_shop);
            if ($id_cms > 0) {
                $url = $this->context->link->getCMSLink($id_cms);
                if ($url) {
                    $code = (int)Configuration::get('SPIDER_HOMECMS_CODE', null, null, $id_shop);
                    if (!in_array($code,[301,302],true)) $code = 302;
                    Tools::redirect($url, $code);
                }
            }
        }
    }
}
