<?php
if (!defined('_PS_VERSION_')) { exit; }

class Spider_Storehours extends Module
{
    public function __construct()
    {
        $this->name = 'spider_storehours';
        $this->tab = 'front_office_features';
        $this->version = '1.1.6';
        $this->author = 'Spiderbyte';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('Orari negozio (Footer)');
        $this->description = $this->l('Mostra gli orari del negozio nel footer');
    }

    public function install()
    {
        return parent::install() && $this->registerHook('displayFooter');
    }

    public function hookDisplayFooter($params)
    {
        $this->context->smarty->assign([
            'spider_title' => $this->l('Orari negozio'),
            'spider_hours_html' => 'Dal martedì al venerdì:<br>10:00 – 13:00 e 15:00 – 19:00<br>Sabato orario continuato<br>dalle 10:00 alle 17:00<br><br><strong>CHIUSO</strong> Domenica e Lunedì',
        ]);
        return $this->fetch('module:' . $this->name . '/views/templates/hook/spider_storehours.tpl');
    }
}
