
<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

class AdminSpiderbyteDaneaController extends ModuleAdminController
{
    public function __construct()
    {
        $this->bootstrap = true;
        parent::__construct();
    }

    public function renderList()
    {
        // ---- HelperForm: select gruppo IVA + upload XML ----
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->module = $this->module;
        $helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');
        $helper->allow_employee_form_lang = (int)Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitSpiderbyteDanea';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminSpiderbyteDanea');
        $helper->token = Tools::getAdminTokenLite('AdminSpiderbyteDanea');

        $taxRuleId = (int)Configuration::get('SB_DANEA_TAX_RULE_GROUP_ID');
        if ($taxRuleId < 0) { $taxRuleId = 0; }

        $tax_rules_groups = TaxRulesGroup::getTaxRulesGroups(true);
        $options = array(array('id_option' => 0, 'name' => $this->module->l('Nessuna imposta')));
        foreach ($tax_rules_groups as $trg) {
            $options[] = array(
                'id_option' => (int)$trg['id_tax_rules_group'],
                'name'      => $trg['name'],
            );
        }

        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->module->l('Import Easyfatt (XML)'),
                    'icon'  => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type'   => 'select',
                        'label'  => $this->module->l('Forza IVA (Gruppo regole):'),
                        'name'   => 'SB_DANEA_TAX_RULE_GROUP_ID',
                        'col'    => 3,
                        'class'  => 'spb-iva-select',
                        'options'=> array(
                            'query' => $options,
                            'id'    => 'id_option',
                            'name'  => 'name',
                        ),
                    ),
                    array(
                        'type'  => 'file',
                        'label' => $this->module->l('File XML Danea:'), // con i due punti
                        'name'  => 'SB_DANEA_XML',
                        'desc'  => $this->module->l('Esporta da Easyfatt: Strumenti → E‑Commerce → Aggiorna articoli → Salva su file'),
                    ),
                ),
                'submit' => array(
                    'title' => $this->module->l('Salva file XML'),
                    'class' => 'btn btn-default pull-right'
                ),
            ),
        );

        $helper->fields_value = array(
            'SB_DANEA_TAX_RULE_GROUP_ID' => $taxRuleId
        );

        $helper->tpl_vars = array(
            'fields_value' => $helper->fields_value,
            'enctype'      => 'multipart/form-data',
        );

        // Form principale
        $html = $helper->generateForm(array($fields_form));

        // ---- WRAP del form per scoping CSS (solo il primo form) ----
        $html = preg_replace('/<form\b([^>]*)>/i', '<div id="spb-easyfatt"><form$1>', $html, 1);
        $html = preg_replace('/<\/form>/i', '</form></div>', $html, 1);

        // ---- LOGO DEL MODULO (modules/{modulo}/logo.png) ----
        $logoFs = _PS_MODULE_DIR_ . $this->module->name . '/logo.png';
        $addedWrapper = false;
        if (@file_exists($logoFs)) {
            $logoUrl = $this->context->link->getMediaLink($this->module->getPathUri() . 'logo.png');
            $logoBlock =
                '<div class="spb-logo-wrap" style="flex:0 0 auto; margin:6px 20px 6px 6px; max-width:220px;">
                    <img src="' . htmlspecialchars($logoUrl, ENT_QUOTES, 'UTF-8') . '" alt="Logo"
                         style="max-width:100%; height:auto; display:block;" />
                 </div>';

            // Inserisci container flex dopo la heading, apro anche .spb-form-col
            $html = preg_replace(
                '/(<div\s+class="panel-heading">.*?<\/div>)/is',
                '$1<div class="spb-flex-row" style="display:flex; align-items:flex-start; flex-wrap:nowrap;">' .
                $logoBlock . '<div class="spb-form-col" style="flex:1 1 auto; min-width:420px;">',
                $html,
                1
            );
            $addedWrapper = true;
        }

        // ---- Costruzione messaggio stato XML (da inserire nello spazio indicato) ----
        $last = Configuration::get('SB_DANEA_LAST_XML');
        if ($last && @file_exists($last) && @filesize($last) > 0) {
            $alertBlock = '<div class="alert alert-info spb-inline-alert" style="margin-top:10px;margin-bottom:0;">
                <i class="icon-check"></i> ' . $this->module->l('XML pronto: ') .
                htmlspecialchars($last, ENT_QUOTES, 'UTF-8') .
            '</div>';
        } else {
            $alertBlock = '<div class="alert alert-warning spb-inline-alert" style="margin-top:10px;margin-bottom:0;">
                <i class="icon-warning-sign"></i> ' .
                $this->module->l('Nessun XML salvato: caricalo dal form qui sopra.') .
            '</div>';
        }

        // Se ho aperto i wrapper (logo presente), chiudo PRIMA del panel-footer e inietto la notifica dentro la colonna form
        if ($addedWrapper) {
            $html = preg_replace(
                '/(<div\s+class="panel-footer">)/is',
                $alertBlock . '</div></div>$1', // notifica + chiusura spb-form-col + chiusura spb-flex-row
                $html,
                1
            );
        } else {
            // Nessun logo: inserisco la notifica subito prima del panel-footer
            $html = preg_replace('/(<div\s+class="panel-footer">)/is', $alertBlock . '$1', $html, 1);
        }

        // ---- CSS scoped: allineamenti + compatta + offset + stile pulsante spostato ----
        $compactCss = <<<CSS
<style>
  /* Scope: solo pannello Easyfatt */
  #spb-easyfatt .panel { /* no-op */ }

  /* Ogni form-group su riga propria con layout FLEX */
  #spb-easyfatt .form-horizontal .form-group {
    display: flex;
    align-items: center;    /* centratura verticale base (label + campo) */
    margin: 6px 0;
    padding: 0;
  }

  /* Disattiva float Bootstrap nel nostro flex */
  #spb-easyfatt .form-horizontal .form-group .control-label,
  #spb-easyfatt .form-horizontal .form-group .col-lg-9 {
    float: none !important;
  }

  /* Colonna label fissa => allineamento sinistro perfetto */
  #spb-easyfatt .form-horizontal .form-group .control-label {
    display: flex;
    align-items: center;         /* centra verticalmente il testo */
    justify-content: flex-end;   /* testo verso il campo */
    height: 100%;
    flex: 0 0 230px;             /* <-- puoi regolare a piacere (es. 220/240) */
    max-width: 230px;
    text-align: right;
    margin: 0 12px 0 0;
    padding: 0;
    white-space: nowrap;
  }

  /* Micro-centratura verticale della label "File XML Danea:" (feedback = -16px perfetto) */
  #spb-easyfatt .form-horizontal .form-group:nth-of-type(2) .control-label {
    transform: translateY(-16px);
  }

  /* Colonna input (a destra della label) */
  #spb-easyfatt .form-horizontal .form-group .col-lg-9,
  #spb-easyfatt .form-horizontal .form-group .col-md-9,
  #spb-easyfatt .form-horizontal .form-group .col-xl-9,
  #spb-easyfatt .form-horizontal .form-group [class*="col-"]:not(.control-label) {
    display: flex;               /* per mettere su una riga input + pulsanti */
    align-items: center;
    flex: 1 1 auto;
    gap: 8px;
    padding-left: 0 !important;
    width: auto !important;
  }

  /* === OFFSET ORIZZONTALE DROPDOWN IVA (robusto) === */
  /* 1) Select nativo */
  #spb-easyfatt .form-horizontal select[name="SB_DANEA_TAX_RULE_GROUP_ID"] {
    margin-left: 5px !important; /* cambia a 6/8 px se serve */
  }
  /* 2) BO con Chosen */
  #spb-easyfatt .form-horizontal select[name="SB_DANEA_TAX_RULE_GROUP_ID"] + .chosen-container {
    margin-left: 5px !important;
  }
  /* 3) BO con Select2 */
  #spb-easyfatt .form-horizontal select[name="SB_DANEA_TAX_RULE_GROUP_ID"] + .select2,
  #spb-easyfatt .form-horizontal select[name="SB_DANEA_TAX_RULE_GROUP_ID"] + .select2-container {
    margin-left: 5px !important;
  }
  /* 4) Wrapper non adiacente: copri anche figli dentro la colonna */
  #spb-easyfatt .form-horizontal .form-group .col-lg-9 > .chosen-container,
  #spb-easyfatt .form-horizontal .form-group .col-md-9 > .chosen-container,
  #spb-easyfatt .form-horizontal .form-group .col-xl-9 > .chosen-container,
  #spb-easyfatt .form-horizontal .form-group [class*="col-"]:not(.control-label) > .chosen-container,
  #spb-easyfatt .form-horizontal .form-group .col-lg-9 > .select2,
  #spb-easyfatt .form-horizontal .form-group .col-md-9 > .select2,
  #spb-easyfatt .form-horizontal .form-group .col-xl-9 > .select2,
  #spb-easyfatt .form-horizontal .form-group [class*="col-"]:not(.control-label) > .select2,
  #spb-easyfatt .form-horizontal .form-group .col-lg-9 > .select2-container,
  #spb-easyfatt .form-horizontal .form-group .col-md-9 > .select2-container,
  #spb-easyfatt .form-horizontal .form-group .col-xl-9 > .select2-container,
  #spb-easyfatt .form-horizontal .form-group [class*="col-"]:not(.control-label) > .select2-container {
    margin-left: 5px !important;
  }

  /* Dropdown IVA: compatto, non a 100% */
  #spb-easyfatt .spb-iva-select {
    width: auto !important;
    min-width: 220px;
    max-width: 360px;
  }

  /* Notifica spostata dentro la colonna form */
  #spb-easyfatt .spb-inline-alert {
    margin-top: 10px;
  }

  /* Bottone Salva spostato accanto ad "Aggiungi files" */
  #spb-easyfatt #spbBtnSaveXml {
    margin-left: 8px; /* distanza dal pulsante "Aggiungi files" */
  }

  /* Colonna form a destra del logo */
  #spb-easyfatt .spb-form-col {
    flex: 1 1 auto;
    min-width: 420px;
    padding-top: 6px; /* piccola compensazione vs logo */
  }

  /* Compatta per far salire il pannello successivo */
  #spb-easyfatt .panel .panel-body,
  #spb-easyfatt form {
    margin-bottom: 6px;
  }

  /* Footer vuoto? comprimilo */
  #spb-easyfatt .panel .panel-footer:empty {
    padding: 0 !important;
    border-top: 0 !important;
    min-height: 0 !important;
  }

  /* Mobile: layout verticale classico */
  @media (max-width: 992px) {
    #spb-easyfatt .spb-flex-row { flex-wrap: wrap; }
    #spb-easyfatt .spb-logo-wrap { max-width: 160px; margin-bottom: 8px; }
    #spb-easyfatt .spb-form-col { min-width: 100%; }
    #spb-easyfatt .form-horizontal .form-group { display: block; }
    #spb-easyfatt .form-horizontal .form-group .control-label {
      display: block; transform: none; flex: none; width: auto; max-width: none;
      text-align: left; margin: 0 0 4px 0; padding: 0;
    }
    #spb-easyfatt .form-horizontal .form-group .col-lg-9,
    #spb-easyfatt .form-horizontal .form-group .col-md-9,
    #spb-easyfatt .form-horizontal .form-group .col-xl-9,
    #spb-easyfatt .form-horizontal .form-group [class*="col-"]:not(.control-label) {
      display: block; padding-left: 0 !important;
    }
  }
</style>
CSS;

        $html = $compactCss . $html;

        // ---- PANEL IMPORT ASINCRONO (immutato nelle logiche) ----
        $adminUrl = $this->context->link->getAdminLink('AdminSpiderbyteDanea'); // token incluso

        $panel  = '<div class="panel" style="margin-top:12px;">';
        $panel .= ' <div class="panel-heading"><i class="icon-refresh"></i> ' .
                  $this->module->l('Import Prodotti — modalità asincrona (con progress bar)') .
                  '</div>';
        $panel .= ' <div class="row" style="margin:8px 0">';
        $panel .= '   <div class="col-lg-8">';
        $panel .= '     <div class="progress" style="height:22px;">';
        $panel .= '       <div id="spbProgressBar" class="progress-bar progress-bar-striped" role="progressbar" style="width:0%;">0%</div>';
        $panel .= '     </div>';
        $panel .= '   </div>';
        $panel .= '   <div class="col-lg-4 text-right">';
        $panel .= '     <button id="spbBtnStart"  class="btn btn-primary"><i class="icon-play"></i> ' . $this->module->l('Avvia (batch 10)') . '</button> ';
        $panel .= '     <button id="spbBtnPause"  class="btn btn-warning" disabled><i class="icon-pause"></i> ' . $this->module->l('Pausa') . '</button> ';
        $panel .= '     <button id="spbBtnResume" class="btn btn-success" disabled><i class="icon-play-circle"></i> ' . $this->module->l('Riprendi') . '</button> ';
        $panel .= '     <button id="spbBtnCancel" class="btn btn-danger"  disabled><i class="icon-remove"></i> ' . $this->module->l('Annulla') . '</button>';
        $panel .= '   </div>';
        $panel .= ' </div>';
        $panel .= ' <pre id="spbLog" style="height:180px;overflow:auto;background:#111;color:#0f0;padding:8px;margin-top:8px;"></pre>';
        $panel .= '</div>';

        $html .= $panel;

        // ---- JS: sposta il pulsante "Salva file XML" accanto "Aggiungi files" (robusto per varie griglie) ----
        $html .= <<<JS
<script>
document.addEventListener('DOMContentLoaded', function() {
  var root = document.querySelector('#spb-easyfatt');
  if (!root) return;

  // 1) Trova il pulsante submit generato dall'HelperForm
  var saveBtn = root.querySelector('button[name="submitSpiderbyteDanea"], input[name="submitSpiderbyteDanea"]');
  // 2) Trova il campo file
  var fileInput = root.querySelector('input[name="SB_DANEA_XML"]');

  if (saveBtn && fileInput) {
    // trova la colonna input della riga file (varianti griglia)
    var formGroup = fileInput.closest('.form-group');
    var targetCol = formGroup ? formGroup.querySelector('.col-lg-9, .col-md-9, .col-xl-9, .col-sm-9, [class*="col-"]:not(.control-label)') : null;

    // se non trovassi la colonna, ripiego sul parent immediato
    if (!targetCol) targetCol = fileInput.parentElement;

    if (targetCol) {
      try { saveBtn.classList.remove('pull-right'); } catch(e) {}
      saveBtn.id = 'spbBtnSaveXml';
      targetCol.appendChild(saveBtn); // in coda: a destra di "Aggiungi files"
    }
  }

  // comprimi eventuale footer rimasto vuoto
  var panel = root.querySelector('.panel');
  if (panel) {
    var pf = panel.querySelector('.panel-footer');
    if (pf && pf.textContent.trim() === '') {
      pf.style.padding = '0';
      pf.style.borderTop = '0';
      pf.innerHTML = '';
    }
  }
});
</script>
JS;

        // ---- JS (progress bar asincrona) ----
        $html .= <<<JS
<script>
(function() {
  var adminUrl = {$this->toJsString($adminUrl)};
  var running = false, paused = false, timer = null;

  function log(msg) {
    var el = document.getElementById("spbLog");
    if (!el) return;
    el.textContent += "[" + (new Date()).toLocaleTimeString() + "] " + msg + "\\n";
    el.scrollTop = el.scrollHeight;
  }

  function setProgress(pct, state) {
    var bar = document.getElementById("spbProgressBar");
    if (!bar) return;
    bar.style.width = pct + "%";
    bar.textContent = pct + "%";
    if (state && typeof state.total !== "undefined") {
      bar.title = (state.offset || 0) + " / " + (state.total || 0);
    }
  }

  function setButtons(s) {
    var bStart  = document.getElementById("spbBtnStart");
    var bPause  = document.getElementById("spbBtnPause");
    var bResume = document.getElementById("spbBtnResume");
    var bCancel = document.getElementById("spbBtnCancel");
    if (bStart)  bStart.disabled  = s.start;
    if (bPause)  bPause.disabled  = s.pause;
    if (bResume) bResume.disabled = s.resume;
    if (bCancel) bCancel.disabled = s.cancel;
  }

  function ajax(action, data, cb) {
    var url = adminUrl + "&ajax=1&action=" + encodeURIComponent(action);
    var form = new FormData();
    if (data) { for (var k in data) { form.append(k, data[k]); } }
    fetch(url, { method:"POST", body: form, credentials:"same-origin" })
      .then(function(r){ return r.text(); })
      .then(function(t){
        try { var j = JSON.parse(t); cb && cb(j); }
        catch(e) { log("RAW non-JSON (prime 200): " + t.substr(0,200).replace(/\\n/g,' '));
                   cb && cb({ok:false,msg:"AJAX error"}); }
      })
      .catch(function(e){ log("Errore AJAX: " + e); cb && cb({ok:false,msg:"AJAX error"}); });
  }

  function tick() {
    if (!running || paused) return;
    ajax("SpbImportRun", null, function(res){
      if (!res || !res.ok) {
        log("Errore: " + (res && res.msg ? res.msg : "sconosciuto"));
        running = false;
        setButtons({start:false,pause:true,resume:true,cancel:true});
        return;
      }
      var pct = res.progress || 0;
      setProgress(pct, res.state);
      log("Batch eseguito: offset " + (res.state ? res.state.offset : "?") + " / " + (res.state ? res.state.total : "?"));
      if (res.state && res.state.done) {
        log("✔ Import completato: creati " + res.state.created +
            ", aggiornati " + res.state.updated +
            ", cat " + res.state.assoc_cat +
            ", brand " + res.state.assoc_brand +
            ", feat " + res.state.assoc_feat +
            ", qty " + res.state.qty_set +
            ", gtin " + res.state.ean_set +
            ", price " + res.state.price_set +
            ", iva " + res.state.tax_set + ".");
        running = false; paused = false;
        setButtons({start:false,pause:true,resume:true,cancel:true});
        return;
      }
      timer = setTimeout(tick, 250);
    });
  }

  var bStart  = document.getElementById("spbBtnStart");
  var bPause  = document.getElementById("spbBtnPause");
  var bResume = document.getElementById("spbBtnResume");
  var bCancel = document.getElementById("spbBtnCancel");

  if (bStart) bStart.addEventListener("click", function(){
    if (running) return;
    log("Avvio import async...");
    setButtons({start:true,pause:false,resume:true,cancel:false});
    ajax("SpbImportStart", {batch:10}, function(res){
      if (!res || !res.ok) {
        log("Errore init: " + (res && res.msg ? res.msg : "sconosciuto"));
        setButtons({start:false,pause:true,resume:true,cancel:true});
        return;
      }
      setProgress(0, res.state);
      running = true; paused = false;
      tick();
    });
  });

  if (bPause) bPause.addEventListener("click", function(){
    if (!running) return;
    paused = true;
    setButtons({start:true,pause:true,resume:false,cancel:false});
    log("Pausa...");
  });

  if (bResume) bResume.addEventListener("click", function(){
    if (!paused) return;
    paused = false; running = true;
    setButtons({start:true,pause:false,resume:true,cancel:false});
    log("Ripresa...");
    tick();
  });

  if (bCancel) bCancel.addEventListener("click", function(){
    paused = false; running = false; if (timer) clearTimeout(timer);
    setButtons({start:false,pause:true,resume:true,cancel:true});
    ajax("SpbImportCancel", null, function(){ log("Cancellato stato import."); setProgress(0); });
  });
})();
</script>
JS;

        return $html;
    }

    // ==== AJAX ENDPOINTS ====

    public function ajaxProcessSpbImportStart()
    {
        if (session_status() === PHP_SESSION_ACTIVE) { @session_write_close(); }
        @ini_set('session.gc_probability', '0');
        header('Content-Type: application/json; charset=utf-8');

        $batch = (int)Tools::getValue('batch', 10); // default 10
        $file  = _PS_MODULE_DIR_ . $this->module->name . '/controllers/admin/danea_imp_prodotti_async.php';
        if (!@file_exists($file)) { echo json_encode(['ok'=>false,'msg'=>'File async mancante']); exit; }

        include_once($file);
        $res = spb_danea_async_start($this->module, $this->context, $batch);
        echo json_encode($res); exit;
    }

    public function ajaxProcessSpbImportRun()
    {
        if (session_status() === PHP_SESSION_ACTIVE) { @session_write_close(); }
        @ini_set('session.gc_probability', '0');
        header('Content-Type: application/json; charset=utf-8');

        $file  = _PS_MODULE_DIR_ . $this->module->name . '/controllers/admin/danea_imp_prodotti_async.php';
        if (!@file_exists($file)) { echo json_encode(['ok'=>false,'msg'=>'File async mancante']); exit; }

        include_once($file);
        $res = spb_danea_async_run($this->module, $this->context);
        echo json_encode($res); exit;
    }

    public function ajaxProcessSpbImportStatus()
    {
        if (session_status() === PHP_SESSION_ACTIVE) { @session_write_close(); }
        @ini_set('session.gc_probability', '0');
        header('Content-Type: application/json; charset=utf-8');

        $file  = _PS_MODULE_DIR_ . $this->module->name . '/controllers/admin/danea_imp_prodotti_async.php';
        if (!@file_exists($file)) { echo json_encode(['ok'=>false,'msg'=>'File async mancante']); exit; }

        include_once($file);
        $res = spb_danea_async_status();
        echo json_encode($res); exit;
    }

    public function ajaxProcessSpbImportCancel()
    {
        if (session_status() === PHP_SESSION_ACTIVE) { @session_write_close(); }
        @ini_set('session.gc_probability', '0');
        header('Content-Type: application/json; charset=utf-8');

        $file  = _PS_MODULE_DIR_ . $this->module->name . '/controllers/admin/danea_imp_prodotti_async.php';
        if (!@file_exists($file)) { echo json_encode(['ok'=>false,'msg'=>'File async mancante']); exit; }

        include_once($file);
        $res = spb_danea_async_cancel();
        echo json_encode($res); exit;
    }

    public function postProcess()
    {
        if (Tools::isSubmit('submitSpiderbyteDanea')) {
            $taxRule = (int)Tools::getValue('SB_DANEA_TAX_RULE_GROUP_ID', 0);
            if ($taxRule < 0) { $taxRule = 0; }
            Configuration::updateValue('SB_DANEA_TAX_RULE_GROUP_ID', $taxRule);

            // Upload XML
            if (isset($_FILES['SB_DANEA_XML']) && isset($_FILES['SB_DANEA_XML']['error']) && (int)$_FILES['SB_DANEA_XML']['error'] === UPLOAD_ERR_OK) {
                $tmp = $_FILES['SB_DANEA_XML']['tmp_name'];
                if (!@filesize($tmp)) {
                    $this->errors[] = $this->module->l('File XML vuoto o non leggibile.');
                } else {
                    $dir = _PS_MODULE_DIR_ . $this->module->name . '/tmp';
                    if (!is_dir($dir)) { @mkdir($dir, 0755, true); }
                    $dest = $dir . '/danea_last.xml';
                    if (@move_uploaded_file($tmp, $dest)) {
                        Configuration::updateValue('SB_DANEA_LAST_XML', $dest);
                        $this->confirmations[] = $this->module->l("XML salvato: pronto per l'import.");
                    } else {
                        $this->errors[] = $this->module->l('Spostamento file fallito.');
                    }
                }
            } else {
                if (!isset($_FILES['SB_DANEA_XML']) || !isset($_FILES['SB_DANEA_XML']['error']) || (int)$_FILES['SB_DANEA_XML']['error'] !== UPLOAD_ERR_OK) {
                    $this->errors[] = $this->module->l('Caricamento XML non riuscito o file mancante.');
                }
            }
        }
        parent::postProcess();
    }

    /**
     * Piccolo helper per serializzare una stringa JS in modo sicuro
     */
    private function toJsString($str)
    {
        return json_encode($str, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    }
}
?>