
<?php
if (!defined('_PS_VERSION_')) { exit; }

class spiderbyte_danea extends Module
{
    public $tabs = [
        [
            'name'              => 'Danea Import',
            'class_name'        => 'AdminSpiderbyteDanea',
            'visible'           => true,
            'parent_class_name' => 'AdminCatalog',
            'icon'              => 'import_export',
        ],
    ];

    public function __construct()
    {
        $this->name = 'spiderbyte_danea';
        $this->tab = 'administration';
        $this->version = '2.0.2';
        $this->author = 'Spiderbyte';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = ['min' => '8.0.0', 'max' => _PS_VERSION_];
        parent::__construct();
        $this->displayName = $this->l('Spiderbyte-danea');
        $this->description = $this->l('Import Easyfatt (XML) — Import prodotti asincrono con progress bar.');
    }

    public function install()
    {
        $ok = parent::install() && $this->installTabs();
        $ok = $ok && Configuration::updateValue('SB_DANEA_TAX_RULE_GROUP_ID', 0);
        $ok = $ok && Configuration::updateValue('SB_DANEA_LAST_XML', '');
        $dir = _PS_MODULE_DIR_.$this->name.'/tmp';
        if (!is_dir($dir)) { @mkdir($dir, 0755, true); }
        if ($ok && method_exists('Tools','clearAllCache')) { Tools::clearAllCache(); }
        return $ok;
    }

    public function uninstall()
    {
        return parent::uninstall()
            && $this->uninstallTabs()
            && Configuration::deleteByName('SB_DANEA_TAX_RULE_GROUP_ID')
            && Configuration::deleteByName('SB_DANEA_LAST_XML');
    }

    protected function installTabs()
    {
        foreach ($this->tabs as $t) {
            $id = (int)Tab::getIdFromClassName($t['class_name']);
            if (!$id) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = $t['class_name'];
                $parent = (int)Tab::getIdFromClassName($t['parent_class_name']);
                if (!$parent) { $parent = (int)Tab::getIdFromClassName('AdminParentCatalog'); if (!$parent) $parent = 0; }
                $tab->id_parent = $parent;
                $tab->module = $this->name;
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[(int)$lang['id_lang']] = $this->l($t['name']);
                }
                if (isset($t['icon'])) { $tab->icon = $t['icon']; }
                if (!$tab->add()) { return false; }
            }
        }
        return true;
    }

    protected function uninstallTabs()
    {
        foreach ($this->tabs as $t) {
            $id = (int)Tab::getIdFromClassName($t['class_name']);
            if ($id) { $tab = new Tab($id); $tab->delete(); }
        }
        return true;
    }
}
?>
